/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.unreal.messages;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.ut2004.bot.params.UT2004BotParameters;
import eis.eis2java.exception.TranslationException;
import eis.iilang.Parameter;
import java.util.Map;
import java.util.logging.Logger;
import nl.tudelft.goal.unreal.environment.UnrealEnvironmentException;
import nl.tudelft.goal.unreal.messages.Key;

public abstract class Parameters
extends UT2004BotParameters
implements IComponent {
    public static final int BOT_SERVER_PORT = 3000;
    public static final int CONTROL_SERVER_PORT = 3001;
    public static final String LOCAL_HOST = "127.0.0.1";
    public static final String DEFAULT_NAME = "UnrealGoalBot";
    protected final Logger log;

    public Parameters(IAgentLogger log) {
        this.log = log.getCategory(this);
    }

    @Override
    public void assignDefaults(IAgentParameters defaults) {
        super.assignDefaults(defaults);
    }

    public Parameters(Map<String, Parameter> parameters, IAgentLogger log) throws UnrealEnvironmentException {
        this(log);
        for (Map.Entry<String, Parameter> entry : parameters.entrySet()) {
            String key = entry.getKey();
            Parameter value = entry.getValue();
            try {
                this.setKey(Key.parseKey(key), value);
            }
            catch (TranslationException e) {
                String message = String.format("Could not set %s to %s. Cause: %s", key, value, e.getMessage());
                throw new UnrealEnvironmentException(message, e);
            }
            catch (IllegalArgumentException e) {
                String message = String.format("Could not set %s to %s. Cause: %s", key, value, e.getMessage());
                throw new UnrealEnvironmentException(message, e);
            }
        }
    }

    protected abstract void setKey(Key var1, Parameter var2) throws TranslationException;

    @Override
    public Parameters setAgentId(IAgentId agentId) {
        super.setAgentId(agentId);
        return this;
    }

    public Parameters setAgentId(String name) {
        assert (name != null);
        this.setAgentId(new AgentId(name));
        return this;
    }

    @Override
    public Parameters setWorldAddress(IWorldConnectionAddress address) {
        super.setWorldAddress(address);
        this.log.info(String.format("Set %s to %s.", new Object[]{Key.BOTSERVER, address}));
        return this;
    }

    public Parameters setWorldAddress(String host, Integer port) {
        this.setWorldAddress(new SocketConnectionAddress(host, port));
        return this;
    }
}

