/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.evpull.BracketedDocumentIterator;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.SingletonEventIterator;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.functions.StringJoin;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.FixedElement;
import net.sf.saxon.instruct.ParentNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.ValueOf;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.Validation;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pull.UnconstructedDocument;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TextFragmentValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class DocumentInstr
extends ParentNodeConstructor {
    private boolean textOnly;
    private String constantText;

    public DocumentInstr(boolean textOnly, String constantText, String baseURI) {
        this.textOnly = textOnly;
        this.constantText = constantText;
        this.setBaseURI(baseURI);
    }

    public int getImplementationMethod() {
        return 1;
    }

    public boolean isTextOnly() {
        return this.textOnly;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.setLazyConstruction(visitor.getConfiguration().isLazyConstructionMode());
        return super.simplify(visitor);
    }

    protected void checkContentSequence(StaticContext env) throws XPathException {
        DocumentInstr.checkContentSequence(env, this.content, this.validation, this.getSchemaType());
    }

    protected static void checkContentSequence(StaticContext env, Expression content, int validation, SchemaType type) throws XPathException {
        Expression[] components = content instanceof Block ? ((Block)content).getChildren() : new Expression[]{content};
        int elementCount = 0;
        boolean isXSLT = content.getHostLanguage() == 50;
        TypeHierarchy th = env.getConfiguration().getTypeHierarchy();
        for (int i = 0; i < components.length; ++i) {
            SchemaDeclaration decl;
            XPathException de;
            ItemType it = components[i].getItemType(th);
            if (!(it instanceof NodeTest)) continue;
            int possibleNodeKinds = ((NodeTest)it).getNodeKindMask();
            if (possibleNodeKinds == 4) {
                de = new XPathException("Cannot create an attribute node whose parent is a document node");
                de.setErrorCode(isXSLT ? "XTDE0420" : "XPTY0004");
                de.setLocator(components[i]);
                throw de;
            }
            if (possibleNodeKinds == 8192) {
                de = new XPathException("Cannot create a namespace node whose parent is a document node");
                de.setErrorCode(isXSLT ? "XTDE0420" : "XQTY0024");
                de.setLocator(components[i]);
                throw de;
            }
            if (possibleNodeKinds != 2) continue;
            if (++elementCount > 1 && (validation == 1 || validation == 2 || type != null)) {
                de = new XPathException("A valid document must have only one child element");
                if (isXSLT) {
                    de.setErrorCode("XTTE1550");
                } else {
                    de.setErrorCode("XQDY0061");
                }
                de.setLocator(components[i]);
                throw de;
            }
            if (validation != 1 || !(components[i] instanceof FixedElement) || (decl = env.getConfiguration().getElementDeclaration(((FixedElement)components[i]).getNameCode(null) & 0xFFFFF)) == null) continue;
            ((FixedElement)components[i]).getContentExpression().checkPermittedContents(decl.getType(), env, true);
        }
    }

    public Expression getStringValueExpression(StaticContext env) {
        if (this.textOnly) {
            if (this.constantText != null) {
                return new StringLiteral(new UntypedAtomicValue(this.constantText));
            }
            if (this.content instanceof ValueOf) {
                return ((ValueOf)this.content).convertToStringJoin(env);
            }
            StringJoin fn = (StringJoin)SystemFunction.makeSystemFunction("string-join", new Expression[]{this.content, new StringLiteral(StringValue.EMPTY_STRING)});
            CastExpression cast = new CastExpression(fn, BuiltInAtomicType.UNTYPED_ATOMIC, false);
            ExpressionTool.copyLocationInfo(this, cast);
            return cast;
        }
        throw new AssertionError((Object)"getStringValueExpression() called on non-text-only document instruction");
    }

    public Expression copy() {
        DocumentInstr doc = new DocumentInstr(this.textOnly, this.constantText, this.getBaseURI());
        doc.setContentExpression(this.content.copy());
        doc.setValidationMode(this.getValidationMode());
        doc.setSchemaType(this.getSchemaType());
        doc.setLazyConstruction(this.isLazyConstruction());
        return doc;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return NodeKindTest.DOCUMENT;
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Item item = this.evaluateItem(context);
        if (item != null) {
            SequenceReceiver out = context.getReceiver();
            out.append(item, this.locationId, 2);
        }
        return null;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        DocumentInfo root;
        if (this.isLazyConstruction() && (context.getConfiguration().areAllNodesUntyped() || this.validation == 3 && this.getSchemaType() == null)) {
            return new UnconstructedDocument(this, context);
        }
        Controller controller = context.getController();
        if (this.textOnly) {
            CharSequence textValue;
            if (this.constantText != null) {
                textValue = this.constantText;
            } else {
                Item item;
                FastStringBuffer sb = new FastStringBuffer(100);
                SequenceIterator iter = this.content.iterate(context);
                while ((item = iter.next()) != null) {
                    sb.append(item.getStringValueCS());
                }
                textValue = sb.condense();
            }
            root = new TextFragmentValue(textValue, this.getBaseURI());
            root.setConfiguration(controller.getConfiguration());
        } else {
            try {
                XPathContextMinor c2 = context.newMinorContext();
                c2.setOrigin(this);
                Builder builder = controller.makeBuilder();
                builder.setLineNumbering(controller.getConfiguration().isLineNumbering());
                builder.setBaseURI(this.getBaseURI());
                builder.setTiming(false);
                PipelineConfiguration pipe = controller.makePipelineConfiguration();
                pipe.setHostLanguage(this.getHostLanguage());
                builder.setPipelineConfiguration(pipe);
                c2.changeOutputDestination(null, builder, false, this.getHostLanguage(), this.validation, this.getSchemaType());
                SequenceReceiver out = c2.getReceiver();
                out.open();
                out.startDocument(0);
                this.content.process(c2);
                out.endDocument();
                out.close();
                root = (DocumentInfo)builder.getCurrentRoot();
            }
            catch (XPathException e) {
                e.maybeSetLocation(this);
                e.maybeSetContext(context);
                throw e;
            }
        }
        return root;
    }

    public EventIterator iterateEvents(XPathContext context) throws XPathException {
        if (this.validation != 3) {
            return new SingletonEventIterator(this.evaluateItem(context));
        }
        return new BracketedDocumentIterator(this.content.iterateEvents(context));
    }

    public int getInstructionNameCode() {
        return 142;
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("documentNode");
        out.emitAttribute("validation", Validation.toString(this.validation));
        if (this.getSchemaType() != null) {
            out.emitAttribute("type", this.getSchemaType().getDescription());
        }
        this.content.explain(out);
        out.endElement();
    }
}

