/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.Token;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Value;

public abstract class BinaryExpression
extends Expression {
    protected Expression operand0;
    protected Expression operand1;
    protected int operator;

    public BinaryExpression(Expression p0, int op, Expression p1) {
        this.operator = op;
        this.operand0 = p0;
        this.operand1 = p1;
        this.adoptChildExpression(p0);
        this.adoptChildExpression(p1);
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.operand0 = visitor.simplify(this.operand0);
        this.operand1 = visitor.simplify(this.operand1);
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand0 = visitor.typeCheck(this.operand0, contextItemType);
        this.operand1 = visitor.typeCheck(this.operand1, contextItemType);
        try {
            if (this.operand0 instanceof Literal && this.operand1 instanceof Literal) {
                Value v = Value.asValue(this.evaluateItem(visitor.getStaticContext().makeEarlyEvaluationContext()));
                return Literal.makeLiteral(v);
            }
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand0 = visitor.optimize(this.operand0, contextItemType);
        this.operand1 = visitor.optimize(this.operand1, contextItemType);
        try {
            if (this.operand0 instanceof Literal && this.operand1 instanceof Literal) {
                Value v = Value.asValue(this.evaluateItem(visitor.getStaticContext().makeEarlyEvaluationContext()));
                return Literal.makeLiteral(v);
            }
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
        return this;
    }

    public void setFlattened(boolean flattened) {
        this.operand0.setFlattened(flattened);
        this.operand1.setFlattened(flattened);
    }

    public Expression promote(PromotionOffer offer) throws XPathException {
        Expression exp = offer.accept(this);
        if (exp != null) {
            return exp;
        }
        if (offer.action != 13) {
            this.operand0 = this.doPromotion(this.operand0, offer);
            this.operand1 = this.doPromotion(this.operand1, offer);
        }
        return this;
    }

    public Iterator iterateSubExpressions() {
        return new PairIterator(this.operand0, this.operand1);
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.operand0 == original) {
            this.operand0 = replacement;
            found = true;
        }
        if (this.operand1 == original) {
            this.operand1 = replacement;
            found = true;
        }
        return found;
    }

    public int getOperator() {
        return this.operator;
    }

    public Expression[] getOperands() {
        return new Expression[]{this.operand0, this.operand1};
    }

    public int computeCardinality() {
        if (Cardinality.allowsZero(this.operand0.getCardinality()) || Cardinality.allowsZero(this.operand1.getCardinality())) {
            return 24576;
        }
        return 16384;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000;
    }

    protected static boolean isCommutative(int operator2) {
        return operator2 == 10 || operator2 == 9 || operator2 == 1 || operator2 == 23 || operator2 == 15 || operator2 == 17 || operator2 == 6 || operator2 == 44 || operator2 == 22 || operator2 == 45;
    }

    protected static boolean isAssociative(int operator2) {
        return operator2 == 10 || operator2 == 9 || operator2 == 1 || operator2 == 23 || operator2 == 15 || operator2 == 17;
    }

    protected static boolean isInverse(int op1, int op2) {
        return op1 != op2 && op1 == Token.inverse(op2);
    }

    public boolean equals(Object other) {
        if (other instanceof BinaryExpression) {
            BinaryExpression b = (BinaryExpression)other;
            if (this.operator == b.operator) {
                if (this.operand0.equals(b.operand0) && this.operand1.equals(b.operand1)) {
                    return true;
                }
                if (BinaryExpression.isCommutative(this.operator) && this.operand0.equals(b.operand1) && this.operand1.equals(b.operand0)) {
                    return true;
                }
                if (BinaryExpression.isAssociative(this.operator) && this.pairwiseEqual(this.flattenExpression(new ArrayList(4)), b.flattenExpression(new ArrayList(4)))) {
                    return true;
                }
            }
            if (BinaryExpression.isInverse(this.operator, b.operator) && this.operand0.equals(b.operand1) && this.operand1.equals(b.operand0)) {
                return true;
            }
        }
        return false;
    }

    private List flattenExpression(List list) {
        int i;
        int h;
        if (this.operand0 instanceof BinaryExpression && ((BinaryExpression)this.operand0).operator == this.operator) {
            ((BinaryExpression)this.operand0).flattenExpression(list);
        } else {
            h = this.operand0.hashCode();
            list.add(this.operand0);
            for (i = list.size() - 1; i > 0 && h > list.get(i - 1).hashCode(); --i) {
                list.set(i, list.get(i - 1));
                list.set(i - 1, this.operand0);
            }
        }
        if (this.operand1 instanceof BinaryExpression && ((BinaryExpression)this.operand1).operator == this.operator) {
            ((BinaryExpression)this.operand1).flattenExpression(list);
        } else {
            h = this.operand1.hashCode();
            list.add(this.operand1);
            for (i = list.size() - 1; i > 0 && h > list.get(i - 1).hashCode(); --i) {
                list.set(i, list.get(i - 1));
                list.set(i - 1, this.operand1);
            }
        }
        return list;
    }

    private boolean pairwiseEqual(List a, List b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (a.get(i).equals(b.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int op = Math.min(this.operator, Token.inverse(this.operator));
        return ("BinaryExpression " + op).hashCode() ^ this.operand0.hashCode() ^ this.operand1.hashCode();
    }

    public String toString() {
        return "(" + this.operand0.toString() + " " + this.displayOperator() + " " + this.operand1.toString() + ")";
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("operator");
        out.emitAttribute("op", this.displayOperator());
        this.operand0.explain(out);
        this.operand1.explain(out);
        out.endElement();
    }

    protected String displayOperator() {
        return Token.tokens[this.operator];
    }
}

