/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.objectmanager;

import cz.cuni.amis.utils.objectmanager.IObjectFactory;
import java.lang.ref.SoftReference;
import java.util.LinkedList;
import java.util.Queue;

public class ObjectManager<MANAGED_OBJECT> {
    private Queue<SoftReference<MANAGED_OBJECT>> freeObjects;
    private IObjectFactory<MANAGED_OBJECT> objectFactory;
    private int moreNewObjectsCount;

    public ObjectManager(IObjectFactory<MANAGED_OBJECT> objectFactory) {
        this(objectFactory, 10, 5);
    }

    public ObjectManager(IObjectFactory<MANAGED_OBJECT> objectFactory, int initialObjectCount) {
        this(objectFactory, initialObjectCount, 5);
    }

    public ObjectManager(IObjectFactory<MANAGED_OBJECT> objectFactory, int initialObjectCount, int moreNewObjectsCount) {
        if (moreNewObjectsCount <= 0) {
            moreNewObjectsCount = 1;
        }
        this.moreNewObjectsCount = moreNewObjectsCount;
        this.objectFactory = objectFactory;
        this.freeObjects = new LinkedList<SoftReference<MANAGED_OBJECT>>();
        this.generateNewObjects(initialObjectCount);
    }

    private void generateNewObjects(int count) {
        for (int i = 0; i < count; ++i) {
            this.freeObjects.add(new SoftReference<MANAGED_OBJECT>(this.objectFactory.newObject()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MANAGED_OBJECT get() {
        Queue<SoftReference<MANAGED_OBJECT>> queue = this.freeObjects;
        synchronized (queue) {
            if (this.freeObjects.size() == 0) {
                this.generateNewObjects(this.moreNewObjectsCount);
            }
            SoftReference<MANAGED_OBJECT> reference = this.freeObjects.poll();
            MANAGED_OBJECT obj = reference.get();
            while (obj == null && this.freeObjects.size() > 0) {
                reference = this.freeObjects.poll();
                obj = reference.get();
            }
            if (obj != null) {
                return obj;
            }
            return this.objectFactory.newObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void giveBack(MANAGED_OBJECT obj) {
        Queue<SoftReference<MANAGED_OBJECT>> queue = this.freeObjects;
        synchronized (queue) {
            this.freeObjects.add(new SoftReference<MANAGED_OBJECT>(obj));
        }
    }
}

