/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.future;

import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.future.FutureStatus;
import cz.cuni.amis.utils.future.IFutureListener;
import cz.cuni.amis.utils.listener.Listeners;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public abstract class FutureWithListeners<RESULT>
implements Future<RESULT> {
    protected Object mutex = new Object();
    protected Listeners<IFutureListener<RESULT>> listeners = new Listeners();
    private FutureStatus oldStatus = null;
    private FutureStatus newStatus = null;
    private Listeners.ListenerNotifier<IFutureListener<RESULT>> notifier = new Listeners.ListenerNotifier<IFutureListener<RESULT>>(){

        @Override
        public Object getEvent() {
            return FutureWithListeners.this.newStatus;
        }

        @Override
        public void notify(IFutureListener<RESULT> listener) {
            listener.futureEvent(FutureWithListeners.this, FutureWithListeners.this.oldStatus, FutureWithListeners.this.newStatus);
        }
    };
    private FutureStatus status = FutureStatus.FUTURE_IS_BEING_COMPUTED;
    private RESULT result = null;
    protected CountDownLatch latch = null;
    private Exception exception;

    public FutureStatus getStatus() {
        return this.status;
    }

    public void addFutureListener(IFutureListener<RESULT> listener) {
        this.listeners.addStrongListener(listener);
    }

    public void removeFutureListener(IFutureListener<RESULT> listener) {
        this.listeners.removeListener(listener);
    }

    public boolean isListening(IFutureListener<RESULT> listener) {
        return this.listeners.isListening(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(RESULT result) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.status != FutureStatus.FUTURE_IS_BEING_COMPUTED) {
                throw new PogamutException("Future is not being computed anymore - can't set result.", (Object)this);
            }
            this.result = result;
            this.switchStatus(FutureStatus.FUTURE_IS_READY);
            if (this.latch != null) {
                while (this.latch.getCount() > 0L) {
                    this.latch.countDown();
                }
            } else {
                this.latch = new CountDownLatch(0);
            }
            this.listeners.clearListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computationException(Exception e) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.status != FutureStatus.FUTURE_IS_BEING_COMPUTED) {
                throw new PogamutException("Future is not being computed anymore - can't process computation exception.", e);
            }
            this.exception = e;
            this.switchStatus(FutureStatus.COMPUTATION_EXCEPTION);
            this.result = null;
            if (this.latch != null) {
                while (this.latch.getCount() > 0L) {
                    this.latch.countDown();
                }
            } else {
                this.latch = new CountDownLatch(0);
            }
        }
    }

    protected synchronized void switchStatus(FutureStatus newStatus) {
        if (newStatus == this.status) {
            return;
        }
        this.oldStatus = this.status;
        this.newStatus = newStatus;
        this.status = newStatus;
        this.listeners.notify(this.notifier);
    }

    protected CountDownLatch createLatch() {
        return new CountDownLatch(1);
    }

    protected boolean cancelComputation(boolean mayInterruptIfRunning) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.cancelComputation(mayInterruptIfRunning)) {
                this.switchStatus(FutureStatus.CANCELED);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RESULT get() {
        if (this.status == FutureStatus.FUTURE_IS_READY) {
            return this.result;
        }
        if (this.status == FutureStatus.FUTURE_IS_BEING_COMPUTED) {
            Object object = this.mutex;
            synchronized (object) {
                if (this.status == FutureStatus.FUTURE_IS_READY) {
                    return this.result;
                }
                if (this.status == FutureStatus.FUTURE_IS_BEING_COMPUTED) {
                    this.latch = this.createLatch();
                }
            }
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                throw new PogamutInterruptedException("Interrupted while awaiting furure result.", e, (Object)this);
            }
            if (this.status == FutureStatus.FUTURE_IS_READY) {
                return this.result;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RESULT get(long timeout, TimeUnit unit) {
        if (this.status == FutureStatus.FUTURE_IS_READY) {
            return this.result;
        }
        if (this.status == FutureStatus.FUTURE_IS_BEING_COMPUTED) {
            Object object = this.mutex;
            synchronized (object) {
                if (this.status == FutureStatus.FUTURE_IS_READY) {
                    return this.result;
                }
                if (this.status == FutureStatus.FUTURE_IS_BEING_COMPUTED) {
                    this.latch = this.createLatch();
                }
            }
            try {
                this.latch.await(timeout, unit);
            }
            catch (InterruptedException e) {
                throw new PogamutInterruptedException("Interrupted while awaiting future result.", e, (Object)this);
            }
            if (this.status == FutureStatus.FUTURE_IS_READY) {
                return this.result;
            }
        }
        return null;
    }

    @Override
    public boolean isCancelled() {
        return this.status == FutureStatus.CANCELED;
    }

    @Override
    public boolean isDone() {
        return this.status != FutureStatus.FUTURE_IS_BEING_COMPUTED;
    }

    public Exception getException() {
        return this.exception;
    }
}

