/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.collections;

import cz.cuni.amis.utils.collections.ElementListener;
import cz.cuni.amis.utils.collections.ObservableCollection;
import cz.cuni.amis.utils.collections.ObservableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class TranslatedObservableCollection<T, U>
extends ObservableList<T> {
    Map<Object, T> map = new HashMap<Object, T>();

    public TranslatedObservableCollection(ObservableCollection<U> col) {
        super(new ArrayList());
        col.addCollectionListener(new ElementListener<U>(){

            @Override
            public void elementChanged(U elem, boolean added) {
                if (added) {
                    TranslatedObservableCollection.this.insert(elem);
                } else {
                    Object val = TranslatedObservableCollection.this.map.remove(TranslatedObservableCollection.this.getKeyForObj(elem));
                    TranslatedObservableCollection.this.remove(val);
                }
            }
        });
        for (U val : col) {
            this.insert(val);
        }
    }

    protected synchronized void insert(U elem) {
        if (this.map.containsKey(this.getKeyForObj(elem))) {
            return;
        }
        T val = this.translate(elem);
        if (val != null) {
            this.map.put(this.getKeyForObj(elem), val);
            this.add(val);
        }
    }

    protected Object getKeyForObj(U elem) {
        return elem;
    }

    protected abstract T translate(U var1);
}

