/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.collections;

import cz.cuni.amis.utils.maps.AbstractLazyMap;
import java.util.Collection;
import java.util.Iterator;

public class LazyMapValuesCollection<VALUE, KEY>
implements Collection<VALUE> {
    private AbstractLazyMap<KEY, VALUE> map;

    public AbstractLazyMap<KEY, VALUE> getBaseMap() {
        return this.map;
    }

    public LazyMapValuesCollection(AbstractLazyMap<KEY, VALUE> sourceMap) {
        this.map = sourceMap;
    }

    @Override
    public boolean add(VALUE e) {
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends VALUE> c) {
        return false;
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean contains(Object o) {
        for (KEY key : this.map.keySet()) {
            if (!this.map.get(key).equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<VALUE> iterator() {
        return new Iterator<VALUE>(){
            Iterator<KEY> it = LazyMapValuesCollection.this.getBaseMap().keySet().iterator();
            KEY value = null;

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public VALUE next() {
                this.value = this.it.next();
                return LazyMapValuesCollection.this.getBaseMap().get(this.value);
            }

            @Override
            public void remove() {
                LazyMapValuesCollection.this.getBaseMap().remove(this.value);
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Object[] toArray() {
        Object[] arr = new Object[this.map.size()];
        int i = 0;
        for (KEY key : this.map.keySet()) {
            arr[i] = this.map.get(key);
        }
        return arr;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Object[] arr = new Object[this.map.size()];
        int i = 0;
        for (KEY key : this.map.keySet()) {
            arr[i] = this.map.get(key);
        }
        return arr;
    }
}

