/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils;

import cz.cuni.amis.utils.ObjectFilter;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.maps.HashMapMap;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassUtils {
    private static Map<Class, SoftReference<Set<Class>>> subclassesCache = new HashMap<Class, SoftReference<Set<Class>>>();
    private static HashMapMap<Class, Boolean, SoftReference<List<Field>>> allFieldsCache = new HashMapMap();

    private static void probeInterface(Class interf, Set<Class> interfaces) {
        interfaces.add(interf);
        for (int i = 0; i < interf.getInterfaces().length; ++i) {
            ClassUtils.probeInterface(interf.getInterfaces()[i], interfaces);
        }
    }

    public static synchronized Collection<Class> getSubclasses(Class cls) {
        SoftReference<Set<Class>> reference = subclassesCache.get(cls);
        Set<Class> classes = null;
        if (reference != null) {
            classes = reference.get();
        }
        if (classes != null) {
            return classes;
        }
        classes = new LinkedHashSet<Class>();
        classes.add(cls);
        if (cls.getInterfaces() != null) {
            for (int i = 0; i < cls.getInterfaces().length; ++i) {
                ClassUtils.probeInterface(cls.getInterfaces()[i], classes);
            }
        }
        for (Class superClass = cls.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            classes.add(superClass);
            if (superClass.getInterfaces() == null) continue;
            for (int i = 0; i < superClass.getInterfaces().length; ++i) {
                ClassUtils.probeInterface(superClass.getInterfaces()[i], classes);
            }
        }
        classes.remove(Object.class);
        subclassesCache.put(cls, new SoftReference<Set<Class>>(classes));
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Field> getAllFields(Class cls, boolean includeStatic) {
        SoftReference<List<Field>> fieldsRef;
        HashMapMap<Class, Boolean, SoftReference<List<Field>>> hashMapMap = allFieldsCache;
        synchronized (hashMapMap) {
            fieldsRef = allFieldsCache.get(cls, includeStatic);
        }
        List<Field> fields = null;
        if (fieldsRef != null && (fields = fieldsRef.get()) != null) {
            return fields;
        }
        fields = new ArrayList<Field>();
        Class clz = cls;
        if (includeStatic) {
            while (!clz.equals(Object.class)) {
                MyCollections.toList(clz.getDeclaredFields(), fields);
                clz = clz.getSuperclass();
            }
        } else {
            ObjectFilter<Field> filterStatic = new ObjectFilter<Field>(){

                @Override
                public boolean accept(Field object) {
                    return !Modifier.isStatic(object.getModifiers());
                }
            };
            while (!clz.equals(Object.class)) {
                MyCollections.toList(clz.getDeclaredFields(), fields, filterStatic);
                clz = clz.getSuperclass();
            }
        }
        HashMapMap<Class, Boolean, SoftReference<List<Field>>> hashMapMap2 = allFieldsCache;
        synchronized (hashMapMap2) {
            allFieldsCache.put(cls, includeStatic, new SoftReference<List<Field>>(fields));
        }
        return fields;
    }

    public static String getMethodSignature(Method method) {
        StringBuffer sb = new StringBuffer();
        sb.append(method.getDeclaringClass());
        sb.append("#");
        sb.append(method.getReturnType().getSimpleName());
        sb.append(" ");
        sb.append(method.getName());
        sb.append("(");
        int arg = 0;
        for (Class<?> type : method.getParameterTypes()) {
            if (arg > 0) {
                sb.append(", ");
            }
            sb.append(type.toString());
            sb.append(" ");
            sb.append("arg");
            sb.append(arg++);
        }
        sb.append(")");
        return sb.toString();
    }
}

