/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.bot;

import cz.cuni.amis.pogamut.base.agent.impl.AbstractAgent;
import cz.cuni.amis.pogamut.base.agent.module.LogicModule;
import cz.cuni.amis.pogamut.base.component.bus.event.BusAwareCountDownLatch;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Logger;

@AgentScoped
public class UT2004BotTestController<BOT extends UT2004Bot>
extends UT2004BotModuleController<BOT> {
    private CountDownLatch latch;
    private Flag<Boolean> success = new Flag<Boolean>(false);
    private Flag<Boolean> failure = new Flag<Boolean>(false);
    private String message;
    private Throwable cause;

    @Override
    public void initializeController(BOT bot) {
        super.initializeController(bot);
        this.latch = new BusAwareCountDownLatch(1, ((AbstractAgent)bot).getEventBus(), ((UT2004Bot)bot).getWorldView());
        this.info = new AgentInfo((UT2004Bot)bot);
        this.move = new AdvancedLocomotion((UT2004Bot)bot, (Logger)this.getLog());
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public void setTestLatch(CountDownLatch latch) {
        this.latch = latch;
    }

    public void setSuccess() {
        this.success.setFlag(true);
        this.latch.countDown();
    }

    public void setSuccess(String message) {
        this.message = message;
        this.log.info(message);
        this.success.setFlag(true);
        this.latch.countDown();
    }

    public void timeout() {
        this.latch.countDown();
        this.setFailure("Timeout!");
    }

    public void setFailure() {
        this.failure.setFlag(true);
        this.latch.countDown();
    }

    public void setFailure(String message) {
        this.setMessage(message);
        this.setFailure();
    }

    public void setFailure(Throwable cause) {
        this.setCause(cause);
        this.setFailure();
    }

    public void setFailure(String message, Throwable cause) {
        this.setMessage(message);
        this.setCause(cause);
        this.setFailure();
    }

    private void setCause(Throwable cause) {
        this.cause = cause;
        if (cause != null) {
            this.log.severe(this.message);
        } else {
            this.log.severe("setFailure(cause): cause == null !!!");
        }
    }

    private void setMessage(String message) {
        this.message = message;
        if (message != null) {
            this.log.severe(message);
        } else {
            this.log.severe("setFailure(message): message == null !!!");
        }
    }

    public boolean isFailure() {
        return this.failure.getFlag() != false || this.latch.getCount() == 0L && this.failure.getFlag() == false && this.success.getFlag() == false;
    }

    public ImmutableFlag<Boolean> getFailureFlag() {
        return this.failure.getImmutable();
    }

    public boolean isSuccess() {
        return this.success.getFlag();
    }

    public ImmutableFlag<Boolean> getSuccessFlag() {
        return this.success.getImmutable();
    }

    public CountDownLatch getTestLatch() {
        return this.latch;
    }

    protected LogicModule getLogicModule() {
        return this.logicModule;
    }
}

