/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.worldview.object;

import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.token.Token;
import cz.cuni.amis.utils.token.Tokens;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class WorldObjectId
implements Serializable {
    protected Token token;
    protected boolean isLong;
    protected boolean isDouble;
    private static Map<String, WorldObjectId> map = new HashMap<String, WorldObjectId>();

    protected WorldObjectId(String name) {
        this.token = Tokens.get(name);
        this.isLong = false;
        this.isDouble = false;
    }

    protected WorldObjectId(long id) {
        this.token = Tokens.get(id);
        this.isLong = true;
        this.isDouble = false;
    }

    protected WorldObjectId(double id) {
        this.token = Tokens.get(id);
        this.isLong = false;
        this.isDouble = true;
    }

    protected WorldObjectId(Token token) {
        this.token = token;
    }

    public int hashCode() {
        return this.token.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof WorldObjectId)) {
            return false;
        }
        return this.token.equals(((WorldObjectId)o).token);
    }

    public String getStringId() {
        return this.token.getToken();
    }

    public boolean isNumericId() {
        return this.isLong || this.isDouble;
    }

    public boolean isLongId() {
        return this.isLong;
    }

    public boolean isDoubleId() {
        return this.isDouble;
    }

    public long getLongId() {
        if (!this.isLong) {
            try {
                long result = Long.parseLong(this.token.getToken());
                this.isLong = true;
                return result;
            }
            catch (Exception e) {
                throw new PogamutException("Id does not hold long value! Id: " + this, (Object)this);
            }
        }
        return Long.parseLong(this.token.getToken());
    }

    public double getDoubleId() {
        if (!this.isDouble) {
            try {
                double result = Double.parseDouble(this.token.getToken());
                this.isDouble = true;
                return result;
            }
            catch (Exception e) {
                throw new PogamutException("Id does not hold double value! Id: " + this, (Object)this);
            }
        }
        return Double.parseDouble(this.token.getToken());
    }

    public String toString() {
        return "WorldObjectId[" + this.getStringId() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorldObjectId get(String name) {
        if (name == null) {
            throw new PogamutException("Could not return a WorldObjectId for 'null'!", WorldObjectId.class);
        }
        WorldObjectId id = null;
        id = map.get(name);
        if (id != null) {
            return id;
        }
        Map<String, WorldObjectId> map = WorldObjectId.map;
        synchronized (map) {
            id = WorldObjectId.map.get(name);
            if (id != null) {
                return id;
            }
            id = new WorldObjectId(name);
            WorldObjectId.map.put(name, id);
        }
        return id;
    }

    public static WorldObjectId get(long objId) {
        return WorldObjectId.get(String.valueOf(objId));
    }

    public static WorldObjectId get(double objId) {
        return WorldObjectId.get(String.valueOf(objId));
    }
}

