/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.worldview.event;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.component.bus.event.BusAwareCountDownLatch;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class WorldEventFuture<T extends IWorldEvent>
implements Future<T> {
    private final IWorldView worldView;
    private final Class<T> eventClass;
    private T worldEvent = null;
    private BusAwareCountDownLatch latch;
    private IWorldEventListener<T> listener = null;
    private boolean cancelled = false;

    public WorldEventFuture(final IWorldView worldView, final Class<T> eventClass) {
        this.worldView = worldView;
        this.eventClass = eventClass;
        this.latch = new BusAwareCountDownLatch(1, worldView.getEventBus(), worldView);
        this.listener = new IWorldEventListener<T>(){

            @Override
            public void notify(T event) {
                WorldEventFuture.this.worldEvent = event;
                worldView.removeEventListener(eventClass, this);
                WorldEventFuture.this.customEventEncounteredHook(WorldEventFuture.this.worldEvent);
                WorldEventFuture.this.latch.countDown();
            }
        };
        worldView.addEventListener(eventClass, this.listener);
    }

    protected void customEventEncounteredHook(T obj) {
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.latch != null) {
            this.latch.countDown();
        }
        this.cancelled = true;
        this.worldView.removeEventListener(this.eventClass, this.listener);
        return true;
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.worldEvent != null;
    }

    @Override
    public T get() {
        this.latch.await();
        return this.worldEvent;
    }

    @Override
    public T get(long timeout, TimeUnit unit) {
        this.latch.await(timeout, unit);
        return this.worldEvent;
    }

    public static class WorldEventFutureException
    extends PogamutException {
        public WorldEventFutureException(String message, Object origin) {
            super(message, origin);
        }
    }
}

