/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.introspection.jmx;

import cz.cuni.amis.introspection.AbstractObjectFolder;
import cz.cuni.amis.introspection.Folder;
import cz.cuni.amis.introspection.IntrospectionException;
import cz.cuni.amis.introspection.Property;
import cz.cuni.amis.introspection.jmx.AttributeToPropertyAdapter;
import cz.cuni.amis.introspection.jmx.DynamicProxy;
import java.util.ArrayList;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;

public class DynamicMBeanToFolderAdapter
extends AbstractObjectFolder<DynamicProxy> {
    public DynamicMBeanToFolderAdapter(DynamicProxy folderMBean) {
        super(folderMBean.getObjectName().getKeyProperty("name"), folderMBean);
    }

    public DynamicMBeanToFolderAdapter(DynamicProxy folderMBean, String name) {
        super(name, folderMBean);
    }

    @Override
    protected Property[] computeProperties(DynamicProxy object) {
        MBeanInfo nfo = object.getMBeanInfo();
        MBeanAttributeInfo[] attrs = nfo.getAttributes();
        ArrayList<AttributeToPropertyAdapter> props = new ArrayList<AttributeToPropertyAdapter>();
        for (MBeanAttributeInfo attr : attrs) {
            props.add(new AttributeToPropertyAdapter(attr, object));
        }
        return props.toArray(new Property[0]);
    }

    @Override
    protected Folder[] computeFolders(DynamicProxy object) throws IntrospectionException {
        try {
            ObjectName objName = object.getObjectName();
            ObjectName pattern = new ObjectName(objName.getDomain() + ":type=" + objName.getKeyProperty("type") + "." + objName.getKeyProperty("name") + ",name=*");
            Set<ObjectName> names = object.getMBeanServerConnection().queryNames(pattern, null);
            ArrayList<DynamicMBeanToFolderAdapter> subfolders = new ArrayList<DynamicMBeanToFolderAdapter>();
            for (ObjectName n : names) {
                subfolders.add(new DynamicMBeanToFolderAdapter(new DynamicProxy(n, object.getMBeanServerConnection())));
            }
            return subfolders.toArray(new Folder[0]);
        }
        catch (Exception ex) {
            throw new IntrospectionException(ex);
        }
    }
}

