/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.translators;

import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPref;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import eis.iilang.Function;
import eis.iilang.Parameter;
import java.util.LinkedList;
import nl.tudelft.goal.EIS2Java.exception.TranslationException;
import nl.tudelft.goal.EIS2Java.translation.Parameter2Java;
import nl.tudelft.goal.EIS2Java.translation.Translator;
import nl.tudelft.goal.ut2004.messages.FireMode;

public class WeaponPrefTranslator
implements Parameter2Java<WeaponPref> {
    private static final int WEAPON_PARAMETERS = 2;
    private static final String WEAPON_KEYWORD = "weapon";

    @Override
    public WeaponPref translate(Parameter parameter) throws TranslationException {
        if (!(parameter instanceof Function)) {
            String message = String.format("Expected a function but got %s.", parameter);
            throw new TranslationException(message);
        }
        Function function = (Function)parameter;
        if (!function.getName().equals(WEAPON_KEYWORD)) {
            String message = String.format("Expected a function named weapon but got %s.", parameter);
            throw new TranslationException(message);
        }
        LinkedList parameters = function.getParameters();
        if (parameters.size() != 2) {
            String message = String.format("Expected a function named weapon with exactly 2 arguments but got %s.", parameter);
            throw new TranslationException(message);
        }
        ItemType itemType = Translator.getInstance().translate2Java((Parameter)parameters.getFirst(), ItemType.class);
        FireMode fireMode = Translator.getInstance().translate2Java((Parameter)parameters.getLast(), FireMode.class);
        if (fireMode == FireMode.NONE) {
            String message = String.format("Fire mode should be either primary or secondary but got %s.", parameter);
            throw new TranslationException(message);
        }
        return new WeaponPref(itemType, fireMode.isPrimary());
    }

    @Override
    public Class<WeaponPref> translatesTo() {
        return WeaponPref.class;
    }
}

