/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.agent.module;

import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.utils.exception.PogamutException;
import eis.exceptions.EntityException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.tudelft.goal.EIS2Java.annotation.AsPercept;
import nl.tudelft.goal.EIS2Java.util.EIS2JavaUtil;

public class PerceptModule
extends SensorModule<UT2004Bot> {
    private Map<String, Method> perceptProviders = new HashMap<String, Method>();
    private Map<String, Object> perceptBatch = new HashMap<String, Object>();
    private Map<String, List<Object>> eventPerceptBatch = new HashMap<String, List<Object>>();

    public PerceptModule(UT2004Bot agent) {
        super(agent);
        try {
            Class<?> controllerClass = agent.getController().getClass();
            this.perceptProviders = EIS2JavaUtil.processPerceptAnnotations(controllerClass);
        }
        catch (EntityException e) {
            throw new PogamutException("Could not proccess all annotations", e);
        }
    }

    public synchronized void updatePercepts() {
        this.perceptBatch = new HashMap<String, Object>();
        for (Map.Entry<String, Method> entry : this.perceptProviders.entrySet()) {
            Object percept;
            String perceptName = entry.getKey();
            Method method = entry.getValue();
            AsPercept annotation = method.getAnnotation(AsPercept.class);
            try {
                percept = method.invoke(((UT2004Bot)this.agent).getController(), new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new PogamutException("Unable to update " + perceptName, e);
            }
            catch (IllegalAccessException e) {
                throw new PogamutException("Unable to update " + perceptName, e);
            }
            catch (InvocationTargetException e) {
                throw new PogamutException("Unable to update " + perceptName, e);
            }
            if (annotation.event()) {
                if (!this.eventPerceptBatch.containsKey(perceptName)) {
                    this.eventPerceptBatch.put(perceptName, new ArrayList());
                }
                List<Object> events = this.eventPerceptBatch.get(perceptName);
                if (!annotation.multiplePercepts()) {
                    throw new PogamutException("Unable to update " + perceptName + " event percept must have multiplePercepts.", (Object)this);
                }
                if (!(percept instanceof Collection)) {
                    throw new PogamutException("Unable to update " + perceptName + " return value must be a collection.", (Object)this);
                }
                events.addAll((Collection)percept);
                continue;
            }
            this.perceptBatch.put(perceptName, percept);
        }
        this.perceptBatch.putAll(this.eventPerceptBatch);
    }

    public synchronized Map<String, Object> getAllPercepts() {
        this.eventPerceptBatch.clear();
        return this.perceptBatch;
    }
}

