/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.bot.navigation.focus;

import cz.cuni.amis.pogamut.base.communication.command.ICommandListener;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.bot.UT2004BotTestController;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.navigation.focus.FocusTestBotParameters;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Move;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import java.util.logging.Level;

public class FocusTestBot
extends UT2004BotTestController<UT2004Bot> {
    State state = State.INIT;
    NavPoint startNavPoint = null;
    NavPoint endNavPoint = null;
    UnrealId startNavPointId = null;
    UnrealId endNavPointId = null;
    UnrealId focus = null;
    Integer totalRepetitions = null;
    int repetitions = 0;
    boolean walkInCircles = false;
    String name;
    NavPoint focusNavPoint;
    ICommandListener<Move> moveListener = new ICommandListener<Move>(){

        @Override
        public void notify(Move event) {
            if (FocusTestBot.this.focusNavPoint != null) {
                if (!FocusTestBot.this.focusNavPoint.getId().equals(event.getFocusTarget())) {
                    throw new RuntimeException("FOCUS IS SET INCORRECTLY!!!");
                }
                FocusTestBot.this.log.info("Focus set correctly!");
            }
        }
    };

    @Override
    public void prepareBot(UT2004Bot bot) {
        if (bot.getParams() instanceof FocusTestBotParameters) {
            if (this.startNavPointId == null) {
                this.setStartNavPointId(((FocusTestBotParameters)bot.getParams()).getStartNavPointId());
            }
            if (this.endNavPointId == null) {
                this.setEndNavPointId(((FocusTestBotParameters)bot.getParams()).getEndNavPointId());
            }
            if (this.focus == null) {
                this.setFocus(((FocusTestBotParameters)bot.getParams()).getFocus());
            }
            if (this.totalRepetitions == null) {
                this.totalRepetitions = ((FocusTestBotParameters)bot.getParams()).getNumOfRepetitions();
            }
            this.walkInCircles = ((FocusTestBotParameters)bot.getParams()).isWalkInCircles();
        }
        bot.getAct().addCommandListener(Move.class, this.moveListener);
    }

    @Override
    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
        super.botInitialized(gameInfo, currentConfig, init);
        this.pathExecutor.getLog().setLevel(Level.ALL);
    }

    @Override
    public void botFirstSpawn(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init, Self self) {
        this.name = self.getName();
        this.log.setLevel(Level.ALL);
    }

    @Override
    public void logic() {
        if (this.isFailure()) {
            this.log.severe("FAILED");
            return;
        }
        if (this.isSuccess()) {
            this.log.severe("SUCCEEDED");
            return;
        }
        switch (this.state) {
            case INIT: {
                if (this.startNavPointId == null) {
                    this.setFailure("startNavPointId not set!");
                    return;
                }
                if (this.endNavPointId == null) {
                    this.setFailure("endNavPointId not set!");
                }
                this.startNavPoint = this.world.getAll(NavPoint.class).get(this.startNavPointId);
                if (this.startNavPoint == null) {
                    this.setFailure("Could not find start navpoint '" + this.startNavPointId.getStringId() + "'!");
                    return;
                }
                this.endNavPoint = this.world.getAll(NavPoint.class).get(this.endNavPointId);
                if (this.endNavPoint == null) {
                    this.setFailure("Could not find end navpoint '" + this.endNavPointId.getStringId() + "'!");
                    return;
                }
                if (this.focus != null) {
                    this.focusNavPoint = this.world.getAll(NavPoint.class).get(this.focus);
                }
                if (this.totalRepetitions == null) {
                    this.setFailure("Number of repetitions for the test was not set!");
                    return;
                }
                this.repetitions = this.totalRepetitions;
                if (this.repetitions <= 0) {
                    this.setFailure("Number of repetitions for the test <= 0!");
                    return;
                }
                this.body.getAction().respawn(this.startNavPoint);
                this.state = State.PREPARE_TEST;
                return;
            }
            case PREPARE_TEST: {
                this.body.getAction().respawn(this.startNavPoint);
                this.state = State.SPAWNED;
                return;
            }
            case SPAWNED: {
                if (!this.info.isAtLocation(this.startNavPoint)) {
                    this.log.warning("Bot is not at " + this.startNavPoint.getId().getStringId() + ", respawning again!");
                    this.body.getAction().respawn(this.startNavPoint);
                    return;
                }
                this.log.warning("Navigation test " + (this.totalRepetitions - this.repetitions + 1) + " / " + this.totalRepetitions);
                this.config.setName(String.valueOf(this.name) + " " + (this.totalRepetitions - this.repetitions + 1) + " / " + this.totalRepetitions);
                this.pathExecutor.setFocus(this.focusNavPoint);
                this.pathExecutor.followPath(this.pathPlanner.computePath(this.info.getLocation(), this.endNavPoint));
                this.state = State.COMMAND_ISSUED;
                return;
            }
            case COMMAND_ISSUED: {
                if (this.pathExecutor.isExecuting()) {
                    return;
                }
                if (this.info.isAtLocation(this.endNavPoint)) {
                    if (this.walkInCircles) {
                        this.pathExecutor.setFocus(this.focusNavPoint);
                        this.pathExecutor.followPath(this.pathPlanner.computePath(this.info.getLocation(), this.startNavPoint));
                        this.state = State.RUNNING_BACK;
                        return;
                    }
                    --this.repetitions;
                    if (this.repetitions == 0) {
                        this.setSuccess("Successfully arrived to '" + this.endNavPointId.getStringId() + "'.");
                    } else {
                        this.log.info("Successfully arrived to '" + this.endNavPointId.getStringId() + "'.");
                        this.state = State.PREPARE_TEST;
                    }
                    return;
                }
                this.setFailure("Failed to arrive to '" + this.endNavPointId.getStringId() + "'.");
                return;
            }
            case RUNNING_BACK: {
                if (this.pathExecutor.isExecuting()) {
                    return;
                }
                if (this.info.isAtLocation(this.startNavPoint)) {
                    --this.repetitions;
                    if (this.repetitions == 0) {
                        this.setSuccess("Successfully arrived back to '" + this.startNavPointId.getStringId() + "'.");
                    } else {
                        this.log.info("Successfully arrived back to '" + this.startNavPointId.getStringId() + "'.");
                        this.state = State.SPAWNED;
                    }
                    return;
                }
                this.setFailure("Failed to arrive back at '" + this.startNavPointId.getStringId() + "'.");
                return;
            }
        }
    }

    public UnrealId getStartNavPointId() {
        return this.startNavPointId;
    }

    public void setStartNavPointId(String startNavPointId) {
        this.startNavPointId = UnrealId.get(startNavPointId);
    }

    public UnrealId getEndNavPointId() {
        return this.endNavPointId;
    }

    public void setEndNavPointId(String endNavpointId) {
        this.endNavPointId = UnrealId.get(endNavpointId);
    }

    public void setFocus(String focusId) {
        if (focusId == null) {
            throw new RuntimeException("Focus is null! Wrong bot params!");
        }
        this.focus = UnrealId.get(focusId);
    }

    public void setStartNavPointId(UnrealId startNavPointId) {
        this.startNavPointId = startNavPointId;
    }

    public void setEndNavPointId(UnrealId endNavpointId) {
        this.endNavPointId = endNavpointId;
    }

    public int getRepetitions() {
        return this.totalRepetitions == null ? 0 : this.totalRepetitions;
    }

    public void setRepetitions(int repetitions) {
        this.totalRepetitions = repetitions;
    }

    private static enum State {
        INIT,
        PREPARE_TEST,
        SPAWNED,
        COMMAND_ISSUED,
        RUNNING_BACK;

    }
}

