/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut3.visualizer.connection.client;

import cz.cuni.amis.utils.flag.Flag;
import java.rmi.RemoteException;
import nl.tudelft.goal.ut2004.visualizer.connection.EnvironmentService;
import nl.tudelft.goal.ut2004.visualizer.connection.VisualizerService;

public class RemoteVisualizer {
    private final Flag<Boolean> connectedFlag = new Flag();
    private VisualizerService visualizer;
    private EnvironmentService environment;

    protected void setVisualizerService(VisualizerService visualizer) {
        this.visualizer = visualizer;
        this.setConnected(true);
    }

    public void setEnvironment(EnvironmentService client) {
        try {
            this.environment = client;
            this.visualizer.registerEnvironment(client);
        }
        catch (RemoteException e) {
            this.disconnect();
            e.printStackTrace();
        }
    }

    private void setConnected(boolean connected) {
        this.connectedFlag.setFlag((Object)connected);
    }

    public Flag<Boolean> getConnectedFlag() {
        return this.connectedFlag;
    }

    public void disconnect() {
        try {
            if (this.visualizer != null) {
                this.visualizer.unregisterEnvironment(this.environment);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.environment = null;
        this.setConnected(false);
    }
}

