/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut3.agent;

import cz.cuni.amis.pogamut.base.agent.IGhostAgent;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.EventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weapon;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPref;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPrefs;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004PathNavigator;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.NavigationState;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004AStarPathPlanner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004GetBackToNavGraph;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004Navigation;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004PathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004RunStraight;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.loquenavigator.LoqueNavigator;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004DistanceStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004PositionStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004TimeStuckDetector;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.params.UT2004BotParameters;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.FlagInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerKilled;
import cz.cuni.amis.pogamut.ut3.bot.impl.UT3BotModuleController;
import cz.cuni.amis.pogamut.ut3.communication.messages.UT3ItemType;
import cz.cuni.amis.utils.exception.PogamutException;
import eis.eis2java.annotation.AsAction;
import eis.eis2java.annotation.AsPercept;
import eis.eis2java.translation.Filter;
import eis.eis2java.util.AllPerceptsModule;
import eis.eis2java.util.AllPerceptsProvider;
import eis.exceptions.EntityException;
import eis.exceptions.PerceiveException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.tudelft.goal.unreal.actions.Action;
import nl.tudelft.goal.unreal.actions.ActionQueue;
import nl.tudelft.goal.unreal.floydwarshall.SharedFloydWarshallMap;
import nl.tudelft.goal.unreal.messages.BotParameters;
import nl.tudelft.goal.unreal.messages.None;
import nl.tudelft.goal.unreal.messages.Percept;
import nl.tudelft.goal.unreal.messages.UnrealIdOrLocation;
import nl.tudelft.goal.ut2004.util.Team;
import nl.tudelft.goal.ut3.actions.Deploy;
import nl.tudelft.goal.ut3.actions.Look;
import nl.tudelft.goal.ut3.actions.Navigate;
import nl.tudelft.goal.ut3.actions.Prefer;
import nl.tudelft.goal.ut3.actions.Respawn;
import nl.tudelft.goal.ut3.actions.Shoot;
import nl.tudelft.goal.ut3.actions.Stop;
import nl.tudelft.goal.ut3.messages.FireMode;
import nl.tudelft.goal.ut3.messages.FlagState;
import nl.tudelft.goal.ut3.messages.SelectorList;
import nl.tudelft.goal.ut3.messages.WeaponPrefList;
import nl.tudelft.goal.ut3.selector.ContextSelector;
import nl.tudelft.goal.ut3.selector.NearestEnemy;
import nl.tudelft.pogamut.unreal.agent.module.sensor.Projectiles;
import nl.tudelft.pogamut.unreal.agent.module.shooting.WeaponShooting;
import nl.tudelft.pogamut.unreal.agent.module.shooting.WeaponryShooting;
import nl.tudelft.pogamut.unreal.agent.module.shooting.util.FocusProvider;
import nl.tudelft.pogamut.unreal.agent.module.shooting.util.OrderedFocusProvider;
import nl.tudelft.pogamut.ut3.agent.module.sensor.UT3Projectiles;
import nl.tudelft.pogamut.ut3.agent.module.shooting.weapon.BioRifleShooting;
import nl.tudelft.pogamut.ut3.agent.module.shooting.weapon.EnforcerShooting;
import nl.tudelft.pogamut.ut3.agent.module.shooting.weapon.FlakCannonShooting;
import nl.tudelft.pogamut.ut3.agent.module.shooting.weapon.ImpactHammerShooting;
import nl.tudelft.pogamut.ut3.agent.module.shooting.weapon.LinkGunShooting;
import nl.tudelft.pogamut.ut3.agent.module.shooting.weapon.RocketLauncherShooting;
import nl.tudelft.pogamut.ut3.agent.module.shooting.weapon.ShockRifleShooting;
import nl.tudelft.pogamut.ut3.agent.module.shooting.weapon.SlowVolumeShooting;
import nl.tudelft.pogamut.ut3.agent.module.shooting.weapon.SniperRifleShooting;
import nl.tudelft.pogamut.ut3.agent.module.shooting.weapon.StingerMinigunShooting;

public class UT3BotBehavior
extends UT3BotModuleController<UT2004Bot>
implements AllPerceptsProvider {
    protected List<ContextSelector> targetSelector = new ArrayList<ContextSelector>();
    protected List<ContextSelector> lookSelector = new ArrayList<ContextSelector>();
    protected Projectiles projectiles;
    protected WeaponryShooting weaponShooting;
    protected FocusProvider lookFocus = new FocusProvider();
    protected OrderedFocusProvider focus = new OrderedFocusProvider();
    protected AllPerceptsModule percepts;
    protected BotParameters parameters;
    private static final int ACTION_QUEUE_SIZE = 8;
    private ActionQueue actions = new ActionQueue(8);
    protected long logicIteration;
    protected long actionCount;
    protected SharedFloydWarshallMap sfwMap;
    private List<Percept> fragged = new LinkedList<Percept>();

    public void initializeController(UT2004Bot bot) {
        super.initializeController(bot);
        IAgentLogger logger = bot.getLogger();
        UT2004BotParameters parameters = bot.getParams();
        if (parameters instanceof BotParameters) {
            this.parameters = (BotParameters)parameters;
        } else {
            this.log.warning("Provided parameters were not a subclass of UnrealGoalParameters, using defaults.");
            this.parameters = new BotParameters();
        }
        this.parameters.assignDefaults((IAgentParameters)BotParameters.getDefaults());
    }

    protected void initializeModules(UT2004Bot bot) {
        super.initializeModules(bot);
        this.projectiles = new UT3Projectiles(bot, (AgentInfo)this.info);
        this.weaponShooting = new WeaponryShooting(bot, (AgentInfo)this.info, this.weaponry, this.weaponPrefs, this.shoot);
        try {
            this.percepts = new AllPerceptsModule((Object)this);
        }
        catch (EntityException e) {
            throw new PogamutException("Could not create percept module", (Throwable)e);
        }
        this.initializeWeaponShootings();
    }

    protected void initializeWeaponShootings() {
        this.weaponShooting.addWeaponShooting((WeaponShooting)new LinkGunShooting(this.bot, (AgentInfo)this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting((WeaponShooting)new ShockRifleShooting(this.bot, (AgentInfo)this.info, this.shoot, this.weaponry, this.projectiles));
        this.weaponShooting.addWeaponShooting((WeaponShooting)new StingerMinigunShooting(this.bot, (AgentInfo)this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting((WeaponShooting)new FlakCannonShooting(this.bot, (AgentInfo)this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting((WeaponShooting)new ImpactHammerShooting(this.bot, (AgentInfo)this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting((WeaponShooting)new BioRifleShooting(this.bot, (AgentInfo)this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting((WeaponShooting)new EnforcerShooting(this.bot, (AgentInfo)this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting((WeaponShooting)new RocketLauncherShooting(this.bot, (AgentInfo)this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting((WeaponShooting)new SniperRifleShooting(this.bot, (AgentInfo)this.info, this.shoot, this.weaponry));
        this.weaponShooting.addWeaponShooting((WeaponShooting)new SlowVolumeShooting(this.bot, (AgentInfo)this.info, this.shoot, this.weaponry));
    }

    protected void initializePathFinding(UT2004Bot bot) {
        this.pathPlanner = new UT2004AStarPathPlanner(bot);
        this.sfwMap = new SharedFloydWarshallMap((IGhostAgent)bot);
        this.pathExecutor = new UT2004PathExecutor(bot, (AgentInfo)this.info, this.move, (IUT2004PathNavigator)new LoqueNavigator(bot, (AgentInfo)this.info, this.move, (Logger)bot.getLog()), (Logger)bot.getLog());
        this.pathExecutor.addStuckDetector((IStuckDetector)new UT2004TimeStuckDetector(bot, 3000.0, 100000.0));
        this.pathExecutor.addStuckDetector((IStuckDetector)new UT2004PositionStuckDetector(bot));
        this.pathExecutor.addStuckDetector((IStuckDetector)new UT2004DistanceStuckDetector(bot));
        this.getBackToNavGraph = new UT2004GetBackToNavGraph(bot, (AgentInfo)this.info, this.move);
        this.runStraight = new UT2004RunStraight(bot, (AgentInfo)this.info, this.move);
        this.navigation = new UT2004Navigation(bot, this.pathExecutor, (IPathPlanner)this.sfwMap, this.getBackToNavGraph, this.runStraight);
    }

    public Initialize getInitializeCommand() {
        assert (this.parameters != null);
        Initialize init = super.getInitializeCommand();
        init.setDesiredSkill(Integer.valueOf(this.parameters.getSkill()));
        init.setSkin(this.parameters.getSkin().getUnrealName());
        init.setTeam(this.parameters.getTeam());
        init.setShouldLeadTarget(this.parameters.shouldLeadTarget());
        init.setLocation(this.parameters.getInitialLocation());
        init.setRotation(this.parameters.getInitialRotation());
        this.log.setLevel(this.parameters.getLogLevel());
        return init;
    }

    public void finishControllerInitialization() {
        this.focus.add(this.weaponShooting.getFocus());
        this.focus.add((ILocated)this.lookFocus);
        this.navigation.setFocus((ILocated)this.focus);
        if (this.navBuilder.isUsed()) {
            this.log.info("Navigation graph has been altered by 'navBuilder', triggering recomputation of Floyd-Warshall path matrix...");
            Level oldLevel = this.sfwMap.getLog().getLevel();
            this.sfwMap.getLog().setLevel(Level.FINER);
            this.sfwMap.refreshPathMatrix();
            this.sfwMap.getLog().setLevel(oldLevel);
        }
    }

    private void addDeployablePreferences(WeaponPrefs weaponPrefs) {
        weaponPrefs.addGeneralPref((ItemType)UT3ItemType.SLOW_VOLUME, true);
        weaponPrefs.addGeneralPref((ItemType)UT3ItemType.EMP_MINE, true);
        weaponPrefs.addGeneralPref((ItemType)UT3ItemType.ENERGY_SHIELD, true);
        weaponPrefs.addGeneralPref((ItemType)UT3ItemType.LINK_GENERATOR, true);
        weaponPrefs.addGeneralPref((ItemType)UT3ItemType.SHAPED_CHARGE, true);
        weaponPrefs.addGeneralPref((ItemType)UT3ItemType.XRAY_VOLUME, true);
    }

    public void beforeFirstLogic() {
        this.targetSelector.add(new NearestEnemy().setContext(this));
        this.lookSelector.add(new NearestEnemy().setContext(this));
        this.addDeployablePreferences(this.weaponPrefs);
        this.weaponPrefs.addGeneralPref((ItemType)UT3ItemType.REDEEMER, true);
        this.weaponPrefs.addGeneralPref((ItemType)UT3ItemType.SHOCK_RIFLE, true);
        this.weaponPrefs.addGeneralPref((ItemType)UT3ItemType.ROCKET_LAUNCHER, true);
        this.weaponPrefs.addGeneralPref((ItemType)UT3ItemType.STINGER_MINIGUN, true);
        this.weaponPrefs.addGeneralPref((ItemType)UT3ItemType.FLAK_CANNON, true);
        this.weaponPrefs.addGeneralPref((ItemType)UT3ItemType.LINK_GUN, false);
        this.weaponPrefs.addGeneralPref((ItemType)UT3ItemType.SNIPER_RIFLE, true);
        this.weaponPrefs.addGeneralPref((ItemType)UT3ItemType.BIO_RIFLE, true);
        this.weaponPrefs.addGeneralPref((ItemType)UT3ItemType.ENFORCER, true);
        this.weaponPrefs.addGeneralPref((ItemType)UT3ItemType.IMPACT_HAMMER, true);
    }

    public void logic() {
        ContextSelector selector;
        ContextSelector selector2;
        super.logic();
        for (Action action : this.actions.drain()) {
            action.execute();
            ++this.actionCount;
        }
        ILocated shootSelected = null;
        Iterator<ContextSelector> i$ = this.targetSelector.iterator();
        while (i$.hasNext() && (shootSelected = (ILocated)(selector2 = i$.next()).select(this.players.getVisiblePlayers().values())) == null) {
        }
        if (!UT3ItemType.isDeployable((ItemType)this.weaponry.getCurrentWeapon().getType())) {
            this.weaponShooting.shoot(shootSelected);
        }
        ILocated lookSelected = null;
        Iterator<ContextSelector> i$2 = this.lookSelector.iterator();
        while (i$2.hasNext() && (lookSelected = (ILocated)(selector = i$2.next()).select(this.players.getVisiblePlayers().values())) == null) {
        }
        this.lookFocus.setFocus(lookSelected);
        if (!this.navigation.isNavigating()) {
            if (this.focus.getLocation() != null) {
                this.move.turnTo((ILocated)this.focus.getLocation());
            } else {
                this.move.turnHorizontal(30);
            }
        }
        ++this.logicIteration;
        try {
            this.percepts.updatePercepts();
        }
        catch (PerceiveException e) {
            throw new PogamutException("Could not update percepts", (Throwable)e);
        }
    }

    public void addAction(Action action) throws InterruptedException {
        this.actions.put(action);
    }

    public Map<Method, Object> getAllPercepts() {
        return this.percepts.getAllPercepts();
    }

    @AsAction(name="navigate")
    public void navigate(final UnrealIdOrLocation destination) throws InterruptedException {
        this.log.fine(String.format("called navigate to %s", destination));
        this.addAction(new Navigate(){

            public void execute() {
                ILocated object = destination.toILocated((IWorldView)UT3BotBehavior.this.world, (AgentInfo)UT3BotBehavior.this.info);
                if (object == null) {
                    UT3BotBehavior.this.log.warning(String.format("failed to navigate to %s. The object associated with this Id was not located in the world. Halting.", destination));
                    UT3BotBehavior.this.navigation.stopNavigation();
                    return;
                }
                UT3BotBehavior.this.log.fine(String.format("executed navigate to %s", destination));
                UT3BotBehavior.this.navigation.navigate(object);
            }
        });
    }

    @AsAction(name="stop")
    public void stop() throws InterruptedException {
        this.log.fine("called stop");
        this.addAction(new Stop(){

            public void execute() {
                UT3BotBehavior.this.log.info("executed stop");
                UT3BotBehavior.this.navigation.stopNavigation();
            }
        });
    }

    @AsAction(name="respawn")
    public void respawn() throws InterruptedException {
        this.log.fine("called respawn");
        this.addAction(new Respawn(){

            public void execute() {
                UT3BotBehavior.this.log.info("executed respawn");
                UT3BotBehavior.this.bot.respawn();
            }
        });
    }

    @AsAction(name="deploy")
    public void deploy() throws InterruptedException {
        this.log.fine("called deploy");
        this.addAction(new Deploy(){

            public void execute() {
                if (UT3ItemType.isDeployable((ItemType)UT3BotBehavior.this.weaponry.getCurrentWeapon().getType())) {
                    UT3BotBehavior.this.shoot.shoot();
                }
            }
        });
    }

    @AsAction(name="path")
    public Percept path(UnrealIdOrLocation from, UnrealIdOrLocation to) {
        ILocated toObject = to.toILocated((IWorldView)this.world, (AgentInfo)this.info);
        ILocated fromObject = from.toILocated((IWorldView)this.world, (AgentInfo)this.info);
        if (fromObject == null) {
            throw new PogamutException(String.format("Failed to compute path from %s to %s. The start was not located in the world.", from, to), (Object)this);
        }
        if (toObject == null) {
            throw new PogamutException(String.format("Failed to compute path from %s to %s. The destination was not located in the world.", from, to), (Object)this);
        }
        this.log.info(String.format("executed path from  %s to %s", from, to));
        Location fromLocation = fromObject.getLocation();
        Location toLocation = toObject.getLocation();
        NavPoint fromNav = (NavPoint)DistanceUtils.getNearest(this.world.getAll(NavPoint.class).values(), (ILocated)fromLocation);
        NavPoint toNav = (NavPoint)DistanceUtils.getNearest(this.world.getAll(NavPoint.class).values(), (ILocated)toLocation);
        double distance = this.sfwMap.getDistance(fromNav, toNav);
        List navPoints = this.sfwMap.getPath(fromNav, toNav);
        ArrayList<UnrealId> unrealIds = new ArrayList<UnrealId>(navPoints.size());
        for (NavPoint n : navPoints) {
            unrealIds.add(n.getId());
        }
        return new Percept(new Object[]{fromNav.getId(), toNav.getId(), distance, unrealIds});
    }

    @AsAction(name="shoot")
    public void shoot(final SelectorList targets) throws InterruptedException {
        this.log.fine(String.format("called shoot %s", targets));
        this.addAction(new Shoot(){

            public void execute() {
                UT3BotBehavior.this.targetSelector = targets.setContext(UT3BotBehavior.this);
                UT3BotBehavior.this.log.info(String.format("executed shoot %s ", UT3BotBehavior.this.targetSelector));
            }
        });
    }

    @AsAction(name="stopShooting")
    public void stopShooting() throws InterruptedException {
        this.shoot(new SelectorList(new ContextSelector[0]));
    }

    @AsAction(name="prefer")
    public void prefer(final WeaponPrefList weaponList) throws InterruptedException {
        this.log.fine(String.format("called prefer %s", weaponList));
        this.addAction(new Prefer(){

            public void execute() {
                UT3BotBehavior.this.weaponPrefs.clearAllPrefs();
                UT3BotBehavior.this.addDeployablePreferences(UT3BotBehavior.this.weaponPrefs);
                for (WeaponPref pref : weaponList) {
                    UT3BotBehavior.this.weaponPrefs.addGeneralPref(pref.getWeapon(), pref.isPrimary());
                }
                UT3BotBehavior.this.log.info(String.format("executed prefer %s", weaponList));
            }
        });
    }

    @AsAction(name="look")
    public void look(final SelectorList targets) throws InterruptedException {
        this.log.fine(String.format("called look %s", targets));
        this.addAction(new Look(){

            public void execute() {
                UT3BotBehavior.this.log.info(String.format("executed look %s", targets));
                UT3BotBehavior.this.lookSelector = targets.setContext(UT3BotBehavior.this);
            }
        });
    }

    @AsAction(name="skip")
    public void skip() {
    }

    @AsPercept(name="logic", filter=Filter.Type.ON_CHANGE)
    @Deprecated
    public Percept logicIteration() {
        return new Percept(new Object[]{this.logicIteration});
    }

    @AsPercept(name="actionCount", filter=Filter.Type.ON_CHANGE)
    @Deprecated
    public Percept actionCount() {
        return new Percept(new Object[]{this.actionCount});
    }

    @AsPercept(name="armor", filter=Filter.Type.ON_CHANGE)
    public Percept armor() {
        return new Percept(new Object[]{this.info.getHelmetArmor(), this.info.getVestArmor(), this.info.getThighpadArmor(), this.info.getShieldBeltArmor()});
    }

    @AsPercept(name="self", filter=Filter.Type.ON_CHANGE)
    public Percept self() {
        return new Percept(new Object[]{this.info.getId(), this.info.getName(), Team.valueOf((int)this.info.getTeam())});
    }

    @AsPercept(name="orientation", filter=Filter.Type.ON_CHANGE)
    public Percept orientation() {
        return new Percept(new Object[]{this.info.getLocation(), this.info.getRotation(), this.info.getVelocity()});
    }

    @AsPercept(name="status", filter=Filter.Type.ON_CHANGE)
    public Percept status() {
        return new Percept(new Object[]{this.info.getHealth(), this.info.getArmor(), 0, new None()});
    }

    @AsPercept(name="score", filter=Filter.Type.ON_CHANGE)
    public Percept score() {
        return new Percept(new Object[]{this.info.getKills(), this.info.getDeaths(), this.info.getSuicides()});
    }

    @AsPercept(name="currentWeapon", filter=Filter.Type.ON_CHANGE)
    public Percept currentWeapon() {
        Weapon weapon = this.weaponry.getCurrentWeapon();
        if (weapon == null) {
            return new Percept(new Object[]{new None(), new None(), FireMode.NONE});
        }
        return new Percept(new Object[]{weapon.getType(), FireMode.valueOf(this.info.isPrimaryShooting(), this.info.isSecondaryShooting())});
    }

    @AsPercept(name="weapon", multiplePercepts=true, filter=Filter.Type.ON_CHANGE_NEG)
    public Collection<Percept> weapon() {
        Collection weapons = this.weaponry.getWeapons().values();
        ArrayList<Percept> percepts = new ArrayList<Percept>(weapons.size());
        for (Weapon w : weapons) {
            if (!UT3ItemType.isDeployable((ItemType)w.getType())) {
                percepts.add(new Percept(new Object[]{w.getType(), w.getPrimaryAmmo(), w.getSecondaryAmmo()}));
                continue;
            }
            this.weaponry.changeWeapon(w);
        }
        return percepts;
    }

    @AsPercept(name="deployable", filter=Filter.Type.ON_CHANGE_NEG)
    public Collection<Percept> deployable() {
        Collection weapons = this.weaponry.getWeapons().values();
        ArrayList<Percept> percepts = new ArrayList<Percept>(weapons.size());
        for (Weapon w : weapons) {
            if (!UT3ItemType.isDeployable((ItemType)w.getType())) continue;
            percepts.add(new Percept(new Object[]{w.getType()}));
        }
        return percepts;
    }

    private void fraggedEvent(long time, UnrealId killer, UnrealId victem, String damageType) {
        this.fragged.add(new Percept(new Object[]{time, killer, victem, damageType}));
    }

    @EventListener(eventClass=BotKilled.class)
    public void msgBotKilled(BotKilled msg) {
        this.fraggedEvent(msg.getSimTime(), msg.getKiller(), this.info.getId(), msg.getWeaponName());
    }

    @EventListener(eventClass=PlayerKilled.class)
    public void msgPlayerKilled(PlayerKilled msg) {
        this.fraggedEvent(msg.getSimTime(), msg.getKiller(), msg.getId(), msg.getDamageType());
    }

    @AsPercept(name="fragged", multiplePercepts=true, filter=Filter.Type.ALWAYS, event=true)
    public List<Percept> fragged() {
        ArrayList<Percept> percepts = new ArrayList<Percept>(this.fragged);
        this.fragged.clear();
        return percepts;
    }

    @AsPercept(name="navigation", filter=Filter.Type.ON_CHANGE)
    public Percept navigation() {
        Percept p;
        None lastTarget;
        NavigationState state = (NavigationState)this.navigation.getState().getFlag();
        ILocated lt = this.navigation.getLastTarget();
        if (lt == null) {
            lastTarget = new None();
        } else if (lt instanceof IWorldObject) {
            IWorldObject targetObject = (IWorldObject)this.navigation.getLastTarget();
            lastTarget = targetObject.getId();
        } else {
            lastTarget = lt.getLocation();
        }
        switch (state) {
            case PATH_COMPUTATION_FAILED: {
                p = new Percept(new Object[]{state, lastTarget});
                break;
            }
            case TARGET_REACHED: {
                p = new Percept(new Object[]{state, lastTarget});
                break;
            }
            case STOPPED: {
                p = new Percept(new Object[]{state, new None()});
                break;
            }
            case STUCK: {
                p = new Percept(new Object[]{state, lastTarget});
                break;
            }
            case NAVIGATING: {
                ILocated currentTarget = this.navigation.getCurrentTarget();
                if (currentTarget instanceof IWorldObject) {
                    IWorldObject targetObject = (IWorldObject)this.navigation.getCurrentTarget();
                    p = new Percept(new Object[]{state, targetObject.getId()});
                    break;
                }
                p = new Percept(new Object[]{state, currentTarget.getLocation()});
                break;
            }
            default: {
                p = new Percept(new Object[]{state, new None()});
            }
        }
        return p;
    }

    @AsPercept(name="navPoint", multiplePercepts=true, filter=Filter.Type.ONCE)
    public Collection<Percept> navPoint() {
        Collection navPoints = this.world.getAll(NavPoint.class).values();
        ArrayList<Percept> percepts = new ArrayList<Percept>(navPoints.size());
        for (NavPoint p : navPoints) {
            percepts.add(new Percept(new Object[]{p.getId(), p.getLocation(), p.getOutgoingEdges().keySet()}));
        }
        return percepts;
    }

    @AsPercept(name="pickup", multiplePercepts=true, filter=Filter.Type.ON_CHANGE_NEG)
    public Collection<Percept> visiblePickup() {
        Collection navPoints = this.world.getAll(NavPoint.class).values();
        ArrayList<Percept> percepts = new ArrayList<Percept>(navPoints.size());
        for (NavPoint p : navPoints) {
            if (!p.isVisible()) continue;
            percepts.add(new Percept(new Object[]{p.getId()}));
        }
        return percepts;
    }

    @AsPercept(name="pickup", multiplePercepts=true, filter=Filter.Type.ONCE)
    public Collection<Percept> pickup() {
        Collection pickups = this.items.getKnownPickups().values();
        ArrayList<Percept> percepts = new ArrayList<Percept>(pickups.size());
        for (Item item : pickups) {
            if (item.isDropped() || item.getNavPoint() == null) continue;
            ItemType.Category cat = item.getType().getCategory();
            if (UT3ItemType.isDeployable((ItemType)item.getType())) {
                cat = ItemType.Category.DEPLOYABLE;
            }
            percepts.add(new Percept(new Object[]{item.getNavPointId(), cat, item.getType()}));
        }
        return percepts;
    }

    @AsPercept(name="base", multiplePercepts=true, filter=Filter.Type.ONCE)
    public Collection<Percept> base() {
        Collection flags = this.game.getAllCTFFlagsCollection();
        ArrayList<Percept> percepts = new ArrayList<Percept>(flags.size());
        Collection navPoints = this.world.getAll(NavPoint.class).values();
        for (FlagInfo flag : flags) {
            Team team = Team.valueOf((int)flag.getTeam());
            NavPoint nav = (NavPoint)DistanceUtils.getNearest(navPoints, (ILocated)this.game.getFlagBase(team.id()));
            percepts.add(new Percept(new Object[]{team, nav.getId()}));
        }
        return percepts;
    }

    @AsPercept(name="game", filter=Filter.Type.ON_CHANGE)
    public Percept game() {
        return new Percept(new Object[]{this.game.getGameType(), this.game.getMapName(), this.game.getTeamScoreLimit(), this.game.getRemainingTime()});
    }

    @AsPercept(name="teamScore", filter=Filter.Type.ON_CHANGE)
    public Percept teamScore() {
        return new Percept(new Object[]{this.game.getTeamScore(this.info.getTeam().intValue()), this.game.getTeamScore(1 - this.info.getTeam())});
    }

    @AsPercept(name="flagState", multiplePercepts=true, filter=Filter.Type.ON_CHANGE_NEG)
    public Collection<Percept> flagState() {
        Collection flags = this.game.getAllCTFFlagsCollection();
        ArrayList<Percept> percepts = new ArrayList<Percept>(flags.size());
        for (FlagInfo flag : flags) {
            percepts.add(new Percept(new Object[]{Team.valueOf((int)flag.getTeam()), FlagState.valueOfIgnoreCase(flag.getState())}));
        }
        return percepts;
    }

    @AsPercept(name="item", multiplePercepts=true, filter=Filter.Type.ON_CHANGE_NEG)
    public Collection<Percept> item() {
        Collection visibleItems = this.items.getVisibleItems().values();
        ArrayList<Percept> percepts = new ArrayList<Percept>(visibleItems.size());
        for (Item item : visibleItems) {
            ItemType.Category cat = item.getType().getCategory();
            if (UT3ItemType.isDeployable((ItemType)item.getType())) {
                cat = ItemType.Category.DEPLOYABLE;
            }
            if (item.isDropped() || item.getNavPointId() == null) {
                percepts.add(new Percept(new Object[]{item.getId(), cat, item.getType(), item.getLocation()}));
                continue;
            }
            percepts.add(new Percept(new Object[]{item.getId(), cat, item.getType(), item.getNavPointId()}));
        }
        return percepts;
    }

    @AsPercept(name="flag", multiplePercepts=true, filter=Filter.Type.ON_CHANGE_NEG)
    public Collection<Percept> flag() {
        Collection flags = this.game.getAllCTFFlagsCollection();
        ArrayList<Percept> percepts = new ArrayList<Percept>(flags.size());
        for (FlagInfo flag : flags) {
            if (!flag.isVisible()) continue;
            percepts.add(new Percept(new Object[]{Team.valueOf((int)flag.getTeam()), flag.getHolder(), flag.getLocation()}));
        }
        return percepts;
    }

    @AsPercept(name="bot", multiplePercepts=true, filter=Filter.Type.ON_CHANGE_NEG)
    public Collection<Percept> bot() {
        Collection visible = this.players.getVisiblePlayers().values();
        ArrayList<Percept> wrapped = new ArrayList<Percept>(visible.size());
        for (Player p : visible) {
            wrapped.add(new Percept(new Object[]{p.getId(), p.getName(), Team.valueOf((int)p.getTeam()), p.getLocation(), UT3ItemType.getItemType((String)p.getWeapon()), FireMode.valueOf(p.getFiring())}));
        }
        return wrapped;
    }

    @AsPercept(name="powerup", multiplePercepts=true, filter=Filter.Type.ON_CHANGE)
    public Collection<Percept> powerup() {
        ArrayList<Percept> percepts = new ArrayList<Percept>();
        if (this.info.hasPowerUp()) {
            percepts.add(new Percept(new Object[]{UT3ItemType.getItemType((String)this.info.getPowerUp()), this.info.getPowerUpTime()}));
        } else {
            percepts.add(new Percept(new Object[]{new None(), 0.0}));
        }
        return percepts;
    }

    @AsPercept(name="slowVolume", filter=Filter.Type.ON_CHANGE)
    public Percept slowvolume() {
        ArrayList slowVolumeNavPoints = this.visibility.getVisibleVolumeNavPoints((ItemType)UT3ItemType.SLOW_VOLUME_CONTENT);
        return new Percept(new Object[]{slowVolumeNavPoints});
    }
}

