/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut3.visualizer.connection.client;

import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.FlagListener;
import java.net.URI;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import nl.tudelft.goal.ut2004.visualizer.connection.VisualizerService;
import nl.tudelft.goal.ut3.visualizer.connection.client.RemoteVisualizer;
import nl.tudelft.pogamut.base.server.ServerDefinition;

public class VisualizerServiceDefinition
extends ServerDefinition<RemoteVisualizer> {
    private static final long serialVersionUID = 201212041520L;
    public static final String serviceName = "UnrealVisualizerService";
    private final FlagListener<Boolean> connectionListener = new FlagListener<Boolean>(){

        @Override
        public void flagChanged(Boolean connected) {
            if (!connected.booleanValue()) {
                VisualizerServiceDefinition.this.startServer();
            }
        }
    };
    private RemoteVisualizer visualizer;

    @Override
    public void startServer() {
        try {
            URI uri = this.getUri();
            assert (uri.getHost() != null);
            assert (uri.getPort() != -1);
            Registry registry = LocateRegistry.getRegistry(uri.getHost(), uri.getPort());
            VisualizerService service = (VisualizerService)registry.lookup(serviceName);
            this.visualizer = new RemoteVisualizer();
            this.visualizer.setVisualizerService(service);
            this.visualizer.getConnectedFlag().addListener(this.connectionListener);
            this.setNewServer(this.visualizer);
        }
        catch (RemoteException e) {
            throw new PogamutException("Problem marshalling remote visualizer.", e);
        }
        catch (NotBoundException e) {
            throw new PogamutException("UnrealVisualizer is not running", e);
        }
    }

    @Override
    public void stopServer() {
        if (this.visualizer != null) {
            this.visualizer.getConnectedFlag().removeListener(this.connectionListener);
            this.visualizer.disconnect();
            this.visualizer = null;
            this.setNewServer(null);
        }
    }
}

