/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.sets;

import cz.cuni.amis.utils.sets.ConcurrentHashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConcurrentLinkedHashSet<K>
implements Set<K> {
    private ConcurrentHashSet<K> set = new ConcurrentHashSet();
    private CopyOnWriteArrayList<K> holder = new CopyOnWriteArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(K e) {
        if (this.set.contains(e)) {
            return false;
        }
        ConcurrentHashSet<K> concurrentHashSet = this.set;
        synchronized (concurrentHashSet) {
            this.set.add(e);
            this.holder.add(e);
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends K> c) {
        boolean changed = false;
        for (K element : c) {
            changed = this.add(element) || changed;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.holder.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.holder.size() == 0;
    }

    @Override
    public Iterator<K> iterator() {
        return this.holder.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        if (!this.set.contains(o)) {
            return false;
        }
        ConcurrentHashSet<K> concurrentHashSet = this.set;
        synchronized (concurrentHashSet) {
            this.set.remove(o);
            this.holder.remove(o);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            changed = this.remove(o) || changed;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.clear();
        for (Object element : c) {
            this.add((K)element);
        }
        return true;
    }

    @Override
    public int size() {
        return this.holder.size();
    }

    @Override
    public Object[] toArray() {
        return this.holder.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.holder.toArray(a);
    }
}

