/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.exception;

import cz.cuni.amis.utils.ExceptionToString;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PogamutException
extends RuntimeException {
    private boolean hasBeenLogged = false;
    private Object origin;

    public PogamutException(Throwable cause, Object origin) {
        super(cause);
        this.origin = origin;
    }

    public PogamutException(String message, Object origin) {
        super(origin.toString() + ": " + message);
        this.origin = origin;
    }

    public PogamutException(String message, Throwable cause) {
        super(message, cause);
        this.origin = cause;
    }

    public PogamutException(String message, Throwable cause, Object origin) {
        super((origin == null ? "" : origin.toString() + ": ") + message + " (caused by: " + cause.getMessage() + ")", cause);
        this.origin = origin;
    }

    public PogamutException(String message, Logger log, Object origin) {
        super((origin == null ? "" : origin.toString() + ": ") + message);
        this.origin = origin;
        this.logException(log);
    }

    public PogamutException(Throwable cause, Logger log, Object origin) {
        super(cause);
        this.origin = origin;
        this.logException(log);
    }

    public PogamutException(String message, Throwable cause, Logger log, Object origin) {
        super((origin == null ? "" : origin.toString() + ": ") + message + " (caused by: " + cause.getMessage() + ")", cause);
        this.origin = origin;
        this.logException(log);
    }

    public boolean isLogged() {
        return this.hasBeenLogged;
    }

    public void setLogged(boolean logged) {
        this.hasBeenLogged = logged;
    }

    public Object getOrigin() {
        return this.origin;
    }

    @Override
    public String toString() {
        if (this == null) {
            return "PogamutException-instantiating";
        }
        return this.getClass().getSimpleName() + "[" + this.getMessage() + "]";
    }

    public synchronized void logException(Logger log) {
        try {
            if (log == null) {
                return;
            }
            if (log.isLoggable(Level.SEVERE)) {
                log.severe(ExceptionToString.process(this.getMessage(), this));
            }
            this.hasBeenLogged = true;
        }
        catch (Exception e) {
            System.err.println("PogamutException (and can't log to log '" + log.getName() + "' because \"" + e.getMessage() + "\"), exception: " + this.toString());
            this.printStackTrace(System.err);
        }
    }

    public synchronized void logExceptionOnce(Logger log) {
        if (log == null) {
            return;
        }
        if (this.isLogged()) {
            return;
        }
        this.logException(log);
    }
}

