/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut3.agent.module.sensor;

import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Items;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut3.communication.messages.UT3ItemType;
import java.util.logging.Logger;

public class UT3Items
extends Items {
    public UT3Items(UT2004Bot bot, AgentInfo agentInfo, Game game, Weaponry weaponry, Logger log) {
        super(bot, agentInfo, game, weaponry, log);
    }

    @Override
    public boolean isPickable(Item item) {
        ItemType itemType = item.getType();
        if (itemType == UT3ItemType.MEDIUM_HEALTH && this.agentInfo.isHealthy().booleanValue()) {
            return false;
        }
        if (itemType == UT3ItemType.SUPER_HEALTH_PACK && this.agentInfo.isSuperHealthy().booleanValue()) {
            return false;
        }
        if (itemType == UT3ItemType.HEALTH_VIAL && this.agentInfo.isSuperHealthy().booleanValue()) {
            return false;
        }
        if (itemType.getCategory() == ItemType.Category.WEAPON && this.game.getGameInfo().isWeaponStay()) {
            return !this.weaponry.hasWeapon(itemType);
        }
        return itemType != UT3ItemType.U_DAMAGE_PACK || this.agentInfo.hasUDamage() == false;
    }

    @Override
    public double getItemRespawnTime(ItemType ut3ItemType) {
        if (ut3ItemType.equals(UT3ItemType.U_DAMAGE_PACK) || ut3ItemType.equals(UT3ItemType.REDEEMER)) {
            return 85.5;
        }
        if (ut3ItemType.equals(UT3ItemType.SUPER_HEALTH_PACK) || ut3ItemType.equals(UT3ItemType.ARMOR_SHIELD_BELT)) {
            return 57.0;
        }
        return 28.5;
    }
}

