/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.formation;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMesh;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshConstants;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import javax.vecmath.Vector2d;

public class Formation {
    UT2004BotModuleController bot;
    Player leader;
    Location leaderLastSeenLocation;
    double leaderLastSeenRotation = 0.0;
    long leaderLastTimeSeen = 0L;
    Vector2d direction;
    double distance;
    NavMesh navmesh;
    boolean relativeRotation = true;
    boolean turnToLeaderAtDestination = true;
    boolean watchLeader = true;
    boolean suicideMode = false;

    public Formation(UT2004BotModuleController bot) throws Exception {
        this.bot = bot;
        this.navmesh = ((UT2004Bot)bot.getBot()).getNavMesh();
        if (this.navmesh == null) {
            throw new Exception("Formation cannot be instatiated because there is no navmesh.");
        }
    }

    public void holdFormation() {
        Vector2d rightFrontDirection;
        Vector2d leftFrontDirection;
        double force;
        if (this.leader == null) {
            System.out.println("No leader - no formation");
            return;
        }
        this.updateLeaderInfo();
        if (null == this.bot.getPlayers().getVisiblePlayer(this.leader.getId()) && this.watchLeader) {
            System.out.println("I lost the leader from sight. I look where i last saw him.");
            this.bot.getMove().turnTo(this.leaderLastSeenLocation);
            return;
        }
        if (this.leaderLastSeenLocation == null) {
            System.out.println("I dont know where my leader is...");
            return;
        }
        double yaw = NavMeshConstants.transform2DVectorToRotation(this.direction);
        if (this.relativeRotation) {
            yaw += this.leaderLastSeenRotation;
        }
        Vector2d actualDirection = NavMeshConstants.transformRotationTo2DVector(yaw);
        actualDirection.normalize();
        actualDirection.x *= this.distance;
        actualDirection.y *= this.distance;
        double x = this.leaderLastSeenLocation.x + actualDirection.x;
        double y = this.leaderLastSeenLocation.y + actualDirection.y;
        double z = this.leaderLastSeenLocation.z;
        Location targetLocaton = new Location(x, y, z);
        if (this.bot.getInfo().atLocation(targetLocaton, NavMeshConstants.StepSize / 2.0)) {
            System.out.println("I am at the right spot.");
            if (this.turnToLeaderAtDestination) {
                this.bot.getMove().turnTo(this.leaderLastSeenLocation);
            }
            return;
        }
        Location currenLocation = this.bot.getInfo().getLocation();
        Vector2d mainForce = new Vector2d(targetLocaton.x - currenLocation.x, targetLocaton.y - currenLocation.y);
        mainForce.normalize();
        mainForce.x *= NavMeshConstants.ForceToTarget;
        mainForce.y *= NavMeshConstants.ForceToTarget;
        yaw = this.bot.getInfo().getRotation().getYaw();
        Vector2d frontDirection = NavMeshConstants.transformRotationTo2DVector(yaw);
        double distance = this.navmesh.getDistanceFromEdge(currenLocation, frontDirection, NavMeshConstants.obstacleMaxDistance);
        if (0.0 < distance && distance < NavMeshConstants.obstacleMaxDistance) {
            force = distance / NavMeshConstants.obstacleMaxDistance * NavMeshConstants.obstacleMaxForce;
            Vector2d frontForce = (Vector2d)frontDirection.clone();
            frontForce.negate();
            frontForce.normalize();
            frontForce.x *= force;
            frontForce.y *= force;
            mainForce.add(frontForce);
        }
        if (0.0 < (distance = this.navmesh.getDistanceFromEdge(currenLocation, leftFrontDirection = NavMeshConstants.transformRotationTo2DVector(yaw - NavMeshConstants.UTQuarterAngle / 2.0), NavMeshConstants.obstacleMaxDistance)) && distance < NavMeshConstants.obstacleMaxDistance) {
            force = distance / NavMeshConstants.obstacleMaxDistance * NavMeshConstants.obstacleMaxForce;
            Vector2d leftFrontForce = (Vector2d)leftFrontDirection.clone();
            leftFrontForce.negate();
            leftFrontForce.normalize();
            leftFrontForce.x *= force;
            leftFrontForce.y *= force;
            mainForce.add(leftFrontForce);
        }
        if (0.0 < (distance = this.navmesh.getDistanceFromEdge(currenLocation, rightFrontDirection = NavMeshConstants.transformRotationTo2DVector(yaw + NavMeshConstants.UTQuarterAngle / 2.0), NavMeshConstants.obstacleMaxDistance)) && distance < NavMeshConstants.obstacleMaxDistance) {
            force = distance / NavMeshConstants.obstacleMaxDistance * NavMeshConstants.obstacleMaxForce;
            Vector2d rightFrontForce = (Vector2d)rightFrontDirection.clone();
            rightFrontForce.negate();
            rightFrontForce.normalize();
            rightFrontForce.x *= force;
            rightFrontForce.y *= force;
            mainForce.add(rightFrontForce);
        }
        mainForce.normalize();
        mainForce.x *= NavMeshConstants.StepSize;
        mainForce.y *= NavMeshConstants.StepSize;
        x = currenLocation.x + mainForce.x;
        y = currenLocation.y + mainForce.y;
        z = currenLocation.z;
        Location resultLocation = new Location(x, y, z);
        System.out.println("Moving to resultLocation " + resultLocation);
        this.bot.getMove().moveTo(resultLocation);
    }

    public void updateLeaderInfo() {
        if (this.bot.getPlayers().getVisiblePlayer(this.leader.getId()) != null) {
            System.out.println("Updating leader's location...");
            this.leaderLastSeenLocation = this.leader.getLocation();
            this.leaderLastSeenRotation = this.leader.getRotation().getYaw();
            this.leaderLastTimeSeen = System.nanoTime();
        } else {
            System.out.println("I cannot see the leader.");
        }
    }

    public int howLongLeaderNotSeen() {
        double nano = System.nanoTime() - this.leaderLastTimeSeen;
        return (int)(nano / 1.0E9);
    }

    public void setLeader(Player leader) {
        this.leader = leader;
        this.updateLeaderInfo();
    }

    public void setDirection(Vector2d direction) {
        this.direction = direction;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public Player getLeader() {
        return this.leader;
    }

    public Vector2d getDirection() {
        return this.direction;
    }

    public double getDistance() {
        return this.distance;
    }

    public Location getLeaderLastSeenLocation() {
        return this.leaderLastSeenLocation;
    }

    public long getLeaderLastTimeSeen() {
        return this.leaderLastTimeSeen;
    }
}

