/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.agent.navigation.impl.PrecomputedPathFuture;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.AStarNode;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.BSPNode;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.INavMeshAtom;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.LevelGeometry;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshConstants;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshCore;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshPolygon;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.OffMeshEdge;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.OffMeshPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DrawStayingDebugLines;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004WorldView;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerModule;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import cz.cuni.amis.pogamut.ut2004.utils.LinkFlag;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004ServerRunner;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.vecmath.Vector2d;
import math.geom2d.line.Line2D;
import math.geom2d.line.StraightLine2D;
import math.geom3d.Point3D;
import math.geom3d.Vector3D;
import math.geom3d.plane.Plane3D;

public class NavMesh
implements IPathPlanner<ILocated> {
    private ArrayList<double[]> verts = new ArrayList();
    private ArrayList<int[]> polys = new ArrayList();
    private ArrayList<ArrayList<Integer>> vertsToPolys;
    private ArrayList<Boolean> safeVertex;
    private BSPNode bspTree;
    private BSPNode biggestLeafInTree;
    private ArrayList<OffMeshPoint> offMeshPoints;
    private ArrayList<ArrayList<OffMeshPoint>> polysToOffMeshPoints;
    private LevelGeometry levelGeometry;
    private UT2004Server server;
    public Random random = new Random();

    public NavMesh(boolean loadLevelGeometry) throws FileNotFoundException, IOException {
        ObjectInputStream in;
        UT2004ServerModule serverModule = new UT2004ServerModule();
        UT2004ServerFactory serverFactory = new UT2004ServerFactory(serverModule);
        UT2004ServerRunner serverRunner = new UT2004ServerRunner(serverFactory);
        this.server = (UT2004Server)serverRunner.startAgent();
        String mapName = this.server.getMapName();
        boolean dataRestored = false;
        System.out.println("Looking for previously saved data core...");
        try {
            in = new ObjectInputStream(new FileInputStream(NavMeshConstants.processedMeshDir + "\\" + mapName + ".processed"));
            NavMeshCore core = (NavMeshCore)in.readObject();
            this.biggestLeafInTree = core.biggestLeafInTree;
            this.bspTree = core.bspTree;
            this.polys = core.polys;
            this.verts = core.verts;
            this.vertsToPolys = core.vertsToPolys;
            this.offMeshPoints = core.offMeshPoints;
            this.polysToOffMeshPoints = core.polysToOffMeshPoints;
            this.safeVertex = core.safeVertex;
            System.out.println("Data core has been restored. Great!");
            dataRestored = true;
        }
        catch (Exception e) {
            System.out.println("Previously saved data core could not be restored. New NavMesh will be processed. Exception message: " + e.getMessage());
        }
        if (!dataRestored) {
            String line;
            String fileName = NavMeshConstants.pureMeshReadDir + "\\" + mapName + ".navmesh";
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            while ((line = br.readLine()) != null) {
                String[] toks = line.split("[ \\t]");
                if (toks[0].equals("v")) {
                    double[] v = new double[]{Double.parseDouble(toks[1]), Double.parseDouble(toks[2]), Double.parseDouble(toks[3])};
                    this.verts.add(v);
                }
                if (!toks[0].equals("p")) continue;
                int[] p = new int[toks.length - 1];
                for (int i = 0; i < toks.length - 1; ++i) {
                    p[i] = Integer.parseInt(toks[i + 1]);
                }
                this.polys.add(p);
            }
            this.resetVertsToPolys();
            this.resetSafeVerts();
            this.resetBSPTree();
            this.eliminateUnreachablePolygons();
            this.resetOffMeshConnections();
            System.out.println("Writing navmesh core to a file...");
            try {
                NavMeshCore core = new NavMeshCore();
                core.biggestLeafInTree = this.biggestLeafInTree;
                core.bspTree = this.bspTree;
                core.polys = this.polys;
                core.verts = this.verts;
                core.vertsToPolys = this.vertsToPolys;
                core.offMeshPoints = this.offMeshPoints;
                core.polysToOffMeshPoints = this.polysToOffMeshPoints;
                core.safeVertex = this.safeVertex;
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(NavMeshConstants.processedMeshDir + "\\" + mapName + ".processed"));
                out.writeObject(core);
                System.out.println("Writing navmesh to a file complete.");
            }
            catch (Exception e) {
                System.out.println("Exception during writing navmesh to a file: " + e.getMessage());
            }
        }
        if (loadLevelGeometry) {
            dataRestored = false;
            System.out.println("Looking for previously saved data level geom...");
            try {
                in = new ObjectInputStream(new FileInputStream(NavMeshConstants.processedLevelGeometryDir + "\\" + mapName + ".processed"));
                this.levelGeometry = (LevelGeometry)in.readObject();
                System.out.println("Level geom has been restored. Great!");
                dataRestored = true;
            }
            catch (Exception e) {
                System.out.println("Previously saved level geom could not be restored. Exception message: " + e.getMessage());
                e.printStackTrace();
            }
            if (!dataRestored) {
                System.out.println("Reading and building level geometry...");
                try {
                    this.levelGeometry = new LevelGeometry(mapName);
                    System.out.println("Level geometry read and built ok.");
                    try {
                        System.out.println("Writing level geometry to a file...");
                        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(NavMeshConstants.processedLevelGeometryDir + "\\" + mapName + ".processed"));
                        out.writeObject(this.levelGeometry);
                        System.out.println("Level geometry written ok.");
                    }
                    catch (Exception e) {
                        System.out.println("Exception during writing level geom to a file: " + e.getMessage());
                    }
                }
                catch (Exception e) {
                    System.out.println("Unable to get level geometry from file. Exception message: " + e.getMessage());
                    this.levelGeometry = null;
                }
            }
        }
    }

    public NavMesh() throws FileNotFoundException, IOException {
        this(true);
    }

    public String toDebugString() {
        StringBuilder result = new StringBuilder("");
        for (int i = 0; i < this.polys.size(); ++i) {
            int[] p = this.polys.get(i);
            for (int j = 0; j < p.length; ++j) {
                if (result.length() > 0) {
                    result.append(";");
                }
                double[] v1 = this.verts.get(p[j]);
                double[] v2 = j == p.length - 1 ? this.verts.get(p[0]) : this.verts.get(p[j + 1]);
                result.append(v1[0] + "," + v1[1] + "," + v1[2] + ";" + v2[0] + "," + v2[1] + "," + v2[2]);
            }
        }
        return result.toString();
    }

    public String polygonToDebugString(int polygonNumber) {
        StringBuilder result = new StringBuilder("");
        int[] p = this.polys.get(polygonNumber);
        for (int j = 0; j < p.length; ++j) {
            if (result.length() > 0) {
                result.append(";");
            }
            double[] v1 = this.verts.get(p[j]);
            double[] v2 = j == p.length - 1 ? this.verts.get(p[0]) : this.verts.get(p[j + 1]);
            result.append(v1[0] + "," + v1[1] + "," + v1[2] + ";" + v2[0] + "," + v2[1] + "," + v2[2]);
        }
        return result.toString();
    }

    private String offMeshEdgeToDebugString(OffMeshEdge oe) {
        StringBuilder result = new StringBuilder("");
        Location l1 = oe.getFrom().getLocation();
        Location l2 = oe.getTo().getLocation();
        result.append(l1.x + "," + l1.y + "," + l1.z + ";" + l2.x + "," + l2.y + "," + l2.z);
        double[] vector = new double[]{l1.x - l2.x, l1.y - l2.y, l1.z - l2.z};
        double length = Math.sqrt(vector[0] * vector[0] + vector[1] * vector[1] + vector[2] * vector[2]);
        vector[0] = vector[0] * (1.0 / length * 20.0);
        vector[1] = vector[1] * (1.0 / length * 20.0);
        vector[2] = vector[2] * (1.0 / length * 20.0);
        Point3D cross = new Point3D(l2.x + vector[0], l2.y + vector[1], l2.z + vector[2]);
        double[] vector2 = new double[]{vector[1] / 2.0, -vector[0] / 2.0};
        Point3D arrowPoint1 = new Point3D(cross.getX() + vector2[0], cross.getY() + vector2[1], cross.getZ());
        Point3D arrowPoint2 = new Point3D(cross.getX() - vector2[0], cross.getY() - vector2[1], cross.getZ());
        result.append(";");
        result.append(arrowPoint1.getX() + "," + arrowPoint1.getY() + "," + arrowPoint1.getZ() + ";" + l2.x + "," + l2.y + "," + l2.z);
        result.append(";");
        result.append(arrowPoint2.getX() + "," + arrowPoint2.getY() + "," + arrowPoint2.getZ() + ";" + l2.x + "," + l2.y + "," + l2.z);
        result.append(";");
        result.append(arrowPoint1.getX() + "," + arrowPoint1.getY() + "," + arrowPoint1.getZ() + ";" + arrowPoint2.getX() + "," + arrowPoint2.getY() + "," + arrowPoint2.getZ());
        return result.toString();
    }

    private String pathToDebugString(IPathFuture<ILocated> path) {
        StringBuilder result = new StringBuilder("");
        ILocated p0 = null;
        List<ILocated> pathList = path.get();
        for (ILocated p1 : pathList) {
            if (result.length() > 0) {
                result.append(";");
            }
            if (p0 != null) {
                result.append(Math.round(p0.getLocation().x) + "," + Math.round(p0.getLocation().y) + "," + Math.round(p0.getLocation().z) + ";" + Math.round(p1.getLocation().x) + "," + Math.round(p1.getLocation().y) + "," + Math.round(p1.getLocation().z));
            }
            p0 = p1;
        }
        return result.toString();
    }

    public void draw() {
        for (int i = 0; i < this.polyCount(); ++i) {
            DrawStayingDebugLines d = new DrawStayingDebugLines();
            String lines = this.polygonToDebugString(i);
            d.setVectors(lines);
            d.setColor(new Location(255.0, 255.0, 255.0));
            d.setClearAll(i == 0);
            this.server.getAct().act(d);
        }
        for (OffMeshPoint op : this.offMeshPoints) {
            for (OffMeshEdge oe : op.getOutgoingEdges()) {
                DrawStayingDebugLines d = new DrawStayingDebugLines();
                String lines = this.offMeshEdgeToDebugString(oe);
                d.setVectors(lines);
                d.setColor(NavMeshConstants.getColorForOffMeshConnection(oe, this.server));
                d.setClearAll(false);
                this.server.getAct().act(d);
            }
        }
    }

    public void draw(String lines, Location color) {
        DrawStayingDebugLines d = new DrawStayingDebugLines();
        d.setVectors(lines);
        d.setColor(color);
        d.setClearAll(false);
        this.server.getAct().act(d);
    }

    public void unDraw() {
        DrawStayingDebugLines d = new DrawStayingDebugLines();
        d.setClearAll(true);
        this.server.getAct().act(d);
    }

    public void drawLevelGeometry(Location color) {
        this.levelGeometry.draw(this.server, color);
    }

    public void drawOnePolygon(int i, Location color) {
        DrawStayingDebugLines d = new DrawStayingDebugLines();
        String lines = this.polygonToDebugString(i);
        d.setVectors(lines);
        d.setColor(color);
        d.setClearAll(false);
        this.server.getAct().act(d);
    }

    public void drawOnePolygon(int i) {
        this.drawOnePolygon(i, new Location(255.0, 255.0, 0.0));
    }

    private void drawAtom(INavMeshAtom atom, Location location) {
        if (atom.getClass() == NavMeshPolygon.class) {
            NavMeshPolygon p = (NavMeshPolygon)atom;
            this.drawOnePolygon(p.getPolygonId(), location);
        }
    }

    public void drawPolygonPath(List<INavMeshAtom> polygonPath, Location location) {
        for (INavMeshAtom atom : polygonPath) {
            this.drawAtom(atom, location);
        }
    }

    public void drawPath(IPathFuture<ILocated> path, Location color) {
        List<ILocated> pathList = path.get();
        for (int i = 0; i < pathList.size() - 1; ++i) {
            StringBuilder lines = new StringBuilder();
            lines.append(pathList.get((int)i).getLocation().x + ",");
            lines.append(pathList.get((int)i).getLocation().y + ",");
            lines.append(pathList.get((int)i).getLocation().z + ";");
            lines.append(pathList.get((int)(i + 1)).getLocation().x + ",");
            lines.append(pathList.get((int)(i + 1)).getLocation().y + ",");
            lines.append(pathList.get((int)(i + 1)).getLocation().z + "");
            this.draw(lines.toString(), color);
        }
    }

    public void drawOnlyBiggestLeaf() {
        for (int i = 0; i < this.polyCount(); ++i) {
            if (!this.biggestLeafInTree.polys.contains(i)) continue;
            DrawStayingDebugLines d = new DrawStayingDebugLines();
            String lines = this.polygonToDebugString(i);
            d.setVectors(lines);
            d.setColor(new Location(255.0, 255.0, 0.0));
            d.setClearAll(false);
            this.server.getAct().act(d);
        }
    }

    public int polyCount() {
        return this.polys.size();
    }

    public int vertCount() {
        return this.verts.size();
    }

    public int[] getPolygon(int i) {
        int[] p = (int[])this.polys.get(i).clone();
        return p;
    }

    public double[] getVertex(int i) {
        double[] v = (double[])this.verts.get(i).clone();
        return v;
    }

    private void resetVertsToPolys() {
        int i;
        System.out.println("Setting vertsToPolys mapping array...");
        this.vertsToPolys = new ArrayList();
        for (i = 0; i < this.verts.size(); ++i) {
            this.vertsToPolys.add(new ArrayList());
        }
        for (i = 0; i < this.polys.size(); ++i) {
            int[] p = this.polys.get(i);
            for (int j = 0; j < p.length; ++j) {
                ArrayList<Integer> p2 = this.vertsToPolys.get(p[j]);
                if (p2.contains(i)) continue;
                p2.add(i);
            }
        }
    }

    private void resetSafeVerts() {
        System.out.println("Setting safe vertices...");
        this.safeVertex = new ArrayList();
        int safeCount = 0;
        for (int v1 = 0; v1 < this.verts.size(); ++v1) {
            System.out.println("Looking at vertex " + v1 + "...");
            double sum = 0.0;
            ArrayList<Integer> polys = this.vertsToPolys.get(v1);
            for (Integer pId : polys) {
                int[] polygon = this.getPolygon(pId);
                int v0 = -1;
                int v2 = -1;
                for (int i = 0; i < polygon.length; ++i) {
                    if (polygon[i] != v1) continue;
                    v0 = i == 0 ? polygon[polygon.length - 1] : polygon[i - 1];
                    v2 = i == polygon.length - 1 ? polygon[0] : polygon[i + 1];
                    break;
                }
                double[] vv0 = this.getVertex(v0);
                double[] vv1 = this.getVertex(v1);
                double[] vv2 = this.getVertex(v2);
                double a = Math.sqrt((vv1[0] - vv0[0]) * (vv1[0] - vv0[0]) + (vv1[1] - vv0[1]) * (vv1[1] - vv0[1]) + (vv1[2] - vv0[2]) * (vv1[2] - vv0[2]));
                double b = Math.sqrt((vv2[0] - vv1[0]) * (vv2[0] - vv1[0]) + (vv2[1] - vv1[1]) * (vv2[1] - vv1[1]) + (vv2[2] - vv1[2]) * (vv2[2] - vv1[2]));
                double c = Math.sqrt((vv2[0] - vv0[0]) * (vv2[0] - vv0[0]) + (vv2[1] - vv0[1]) * (vv2[1] - vv0[1]) + (vv2[2] - vv0[2]) * (vv2[2] - vv0[2]));
                double gama = Math.acos((a * a + b * b - c * c) / (2.0 * a * b));
                System.out.println("angle gama is " + gama);
                sum += gama;
            }
            System.out.println("sum angle is " + sum);
            if (sum >= 6.28) {
                this.safeVertex.add(v1, true);
                ++safeCount;
                continue;
            }
            this.safeVertex.add(v1, false);
        }
        System.out.println("There are " + safeCount + " safe and " + (this.verts.size() + safeCount) + " unsafe vertices.");
    }

    public ArrayList getPolygonsByVertex(int i) {
        return (ArrayList)this.vertsToPolys.get(i).clone();
    }

    public ArrayList getNeighbourIdsToPolygon(int i) {
        ArrayList<Integer> neighbours = new ArrayList<Integer>();
        int[] p = this.getPolygon(i);
        for (int j = 0; j < p.length; ++j) {
            ArrayList p2 = this.getPolygonsByVertex(p[j]);
            block1: for (int k = 0; k < p2.size(); ++k) {
                int candidateId = (Integer)p2.get(k);
                int secondVertex = p[j == p.length - 1 ? 0 : j + 1];
                int[] candidatePolygon = this.getPolygon(candidateId);
                for (int l = 0; l < candidatePolygon.length; ++l) {
                    if (candidatePolygon[l] != secondVertex) continue;
                    if (neighbours.contains(candidateId) || candidateId == i) continue block1;
                    neighbours.add(candidateId);
                    continue block1;
                }
            }
        }
        return neighbours;
    }

    public List<OffMeshPoint> getOffMeshPoinsOnPolygon(int pId) {
        return this.polysToOffMeshPoints.get(pId);
    }

    private void resetBSPTree() {
        System.out.println("Creating BSP tree...");
        this.bspTree = new BSPNode(this, null);
        for (int i = 0; i < this.polys.size(); ++i) {
            this.bspTree.polys.add(i);
        }
        this.biggestLeafInTree = null;
        this.bspTree.build();
        System.out.println("BSP tree is done building.");
        System.out.println("Biggest leaf has " + this.biggestLeafInTree.polys.size() + " polygons.");
    }

    public int getNumberOfPolygonsInBiggestLeaf() {
        if (this.biggestLeafInTree != null) {
            return this.biggestLeafInTree.polys.size();
        }
        return -1;
    }

    public void setBiggestLeafInTree(BSPNode node) {
        this.biggestLeafInTree = node;
    }

    public int getPolygonIdByPoint3D(Point3D point3D) {
        math.geom2d.Point2D point2D = new math.geom2d.Point2D(point3D.getX(), point3D.getY());
        BSPNode node = this.bspTree;
        while (!node.isLeaf()) {
            StraightLine2D sepLine = node.sepLine;
            double dist = sepLine.getSignedDistance(point2D);
            if (dist < 0.0) {
                node = node.left;
            }
            if (dist > 0.0) {
                node = node.right;
            }
            if (dist != 0.0) continue;
            point2D = new math.geom2d.Point2D(point3D.getX() + this.random.nextDouble() - 0.5, point3D.getY() + this.random.nextDouble() - 0.5);
        }
        ArrayList<Integer> candidatePolygons = new ArrayList<Integer>();
        for (int i = 0; i < node.polys.size(); ++i) {
            Integer pId = (Integer)node.polys.get(i);
            if (!this.polygonContainsPoint(pId, point2D)) continue;
            candidatePolygons.add(pId);
        }
        if (candidatePolygons.isEmpty()) {
            return -1;
        }
        double minDist = NavMeshConstants.maxDistanceBotPolygon;
        int retPId = -2;
        for (int i = 0; i < candidatePolygons.size(); ++i) {
            double[] v3;
            Vector3D vector2;
            double[] v2;
            Vector3D vector1;
            Integer pId = (Integer)candidatePolygons.get(i);
            int[] polygon = this.getPolygon(pId);
            double[] v1 = this.getVertex(polygon[0]);
            Point3D p1 = new Point3D(v1[0], v1[1], v1[2]);
            Plane3D plane = new Plane3D(p1, vector1 = new Vector3D((v2 = this.getVertex(polygon[1]))[0] - v1[0], v2[1] - v1[1], v2[2] - v1[2]), vector2 = new Vector3D((v3 = this.getVertex(polygon[2]))[0] - v1[0], v3[1] - v1[1], v3[2] - v1[2]));
            double dist = plane.getDistance(point3D);
            if (dist < minDist) {
                retPId = pId;
                minDist = dist;
            }
            if (polygon.length > 3 && (dist = (plane = new Plane3D(p1 = new Point3D((v1 = this.getVertex(polygon[0]))[0], v1[1], v1[2]), vector1 = new Vector3D((v2 = this.getVertex(polygon[1]))[0] - v1[0], v2[1] - v1[1], v2[2] - v1[2]), vector2 = new Vector3D((v3 = this.getVertex(polygon[3]))[0] - v1[0], v3[1] - v1[1], v3[2] - v1[2]))).getDistance(point3D)) < minDist) {
                retPId = pId;
                minDist = dist;
            }
            if (polygon.length <= 4 || !((dist = (plane = new Plane3D(p1 = new Point3D((v1 = this.getVertex(polygon[0]))[0], v1[1], v1[2]), vector1 = new Vector3D((v2 = this.getVertex(polygon[2]))[0] - v1[0], v2[1] - v1[1], v2[2] - v1[2]), vector2 = new Vector3D((v3 = this.getVertex(polygon[4]))[0] - v1[0], v3[1] - v1[1], v3[2] - v1[2]))).getDistance(point3D)) < minDist)) continue;
            retPId = pId;
            minDist = dist;
        }
        System.out.println("distance of a point from polygon " + retPId + " is " + minDist);
        return retPId;
    }

    public int getPolygonIdByLocation(Location location) {
        return this.getPolygonIdByPoint3D(new Point3D(location.x, location.y, location.z));
    }

    private boolean polygonContainsPoint(Integer pId, math.geom2d.Point2D point2D) {
        boolean result = true;
        double rightSide = 0.0;
        int[] polygon = this.getPolygon(pId);
        for (int i = 0; i < polygon.length; ++i) {
            double[] v1 = this.getVertex(polygon[i]);
            double[] v2 = i < polygon.length - 1 ? this.getVertex(polygon[i + 1]) : this.getVertex(polygon[0]);
            math.geom2d.Point2D p1 = new math.geom2d.Point2D(v1[0], v1[1]);
            math.geom2d.Point2D p2 = new math.geom2d.Point2D(v2[0], v2[1]);
            StraightLine2D line = new StraightLine2D((Point2D)p1, (Point2D)p2);
            double dist = line.getSignedDistance(point2D);
            if (rightSide == 0.0) {
                rightSide = Math.signum(dist);
                continue;
            }
            if (!(rightSide * dist < 0.0)) continue;
            result = false;
            break;
        }
        return result;
    }

    private void eliminateUnreachablePolygons() {
        int i;
        System.out.println("eliminateUnreachablePolygons() starts...");
        Map<WorldObjectId, NavPoint> navPoints = ((UT2004WorldView)this.server.getWorldView()).getAll(NavPoint.class);
        boolean[] reachable = new boolean[this.polys.size()];
        System.out.println("marking reachable polygons...");
        for (NavPoint navPoint : navPoints.values()) {
            Point3D point3D = navPoint.getLocation().asPoint3D();
            int pId = this.getPolygonIdByPoint3D(point3D);
            if (pId < 0) continue;
            this.markAsReachableRecursive(pId, reachable);
        }
        int reachableCount = 0;
        int polyDelCount = 0;
        int vertDelCount = 0;
        for (i = 0; i < this.polys.size(); ++i) {
            if (!reachable[i]) continue;
            ++reachableCount;
        }
        System.out.println("Marking complete. There are " + reachableCount + " reachable polygons and " + (this.polys.size() - reachableCount) + " unreachable polygons.");
        System.out.println("Deleting unreachable polygons...");
        for (i = this.polys.size() - 1; i >= 0; --i) {
            if (reachable[i]) continue;
            this.polys.remove(i);
            ++polyDelCount;
        }
        System.out.println("Reseting vertsToPolys...");
        this.resetVertsToPolys();
        System.out.println("Deleting unused vertices...");
        for (i = this.vertsToPolys.size() - 1; i >= 0; --i) {
            ArrayList<Integer> polygons = this.vertsToPolys.get(i);
            if (!polygons.isEmpty()) continue;
            this.verts.remove(i);
            ++vertDelCount;
            for (int j = 0; j < this.polys.size(); ++j) {
                int[] polygon = this.polys.get(j);
                for (int k = 0; k < polygon.length; ++k) {
                    if (polygon[k] <= i) continue;
                    int n = k;
                    polygon[n] = polygon[n] - 1;
                }
            }
        }
        System.out.println("Deleting done. " + polyDelCount + " Polygons and " + vertDelCount + " vertices were deleted.");
        this.resetVertsToPolys();
        this.resetSafeVerts();
        this.resetBSPTree();
    }

    private void markAsReachableRecursive(int pId, boolean[] reachable) {
        if (reachable[pId]) {
            return;
        }
        reachable[pId] = true;
        ArrayList neighbours = this.getNeighbourIdsToPolygon(pId);
        for (int i = 0; i < neighbours.size(); ++i) {
            this.markAsReachableRecursive((Integer)neighbours.get(i), reachable);
        }
    }

    private void resetOffMeshConnections() {
        UnrealId uId;
        NavPoint np;
        System.out.println("Creating off-mesh connections...");
        HashMap<UnrealId, OffMeshPoint> offPoints = new HashMap<UnrealId, OffMeshPoint>();
        Map<WorldObjectId, NavPoint> navPoints = ((UT2004WorldView)this.server.getWorldView()).getAll(NavPoint.class);
        for (Map.Entry<WorldObjectId, NavPoint> entry : navPoints.entrySet()) {
            np = entry.getValue();
            uId = (UnrealId)entry.getKey();
            int pId = this.getPolygonIdByPoint3D(np.getLocation().asPoint3D());
            OffMeshPoint op = new OffMeshPoint(np, pId);
            offPoints.put(uId, op);
        }
        for (Map.Entry<WorldObjectId, NavPoint> entry : navPoints.entrySet()) {
            np = entry.getValue();
            uId = (UnrealId)entry.getKey();
            for (Map.Entry<UnrealId, NavPointNeighbourLink> entry2 : np.getOutgoingEdges().entrySet()) {
                int linkFlags;
                NavPointNeighbourLink link = entry2.getValue();
                UnrealId uId2 = entry2.getKey();
                NavPoint target = link.getToNavPoint();
                System.out.println("Checking edge from navpoint " + uId + " to navpoint " + target.getId() + "...");
                boolean forceIgnore = false;
                boolean forceAdd = false;
                boolean addThisEdge = false;
                if (np.isLiftCenter()) {
                    forceAdd = true;
                }
                if (target.isLiftCenter()) {
                    forceAdd = true;
                }
                if (((linkFlags = link.getFlags()) & LinkFlag.DOOR.get()) > 0) {
                    // empty if block
                }
                if ((linkFlags & LinkFlag.FLY.get()) > 0) {
                    forceIgnore = true;
                }
                if ((linkFlags & LinkFlag.FORCED.get()) > 0) {
                    // empty if block
                }
                if ((linkFlags & LinkFlag.JUMP.get()) > 0) {
                    // empty if block
                }
                if ((linkFlags & LinkFlag.LADDER.get()) > 0) {
                    forceIgnore = true;
                }
                if ((linkFlags & LinkFlag.PLAYERONLY.get()) > 0) {
                    // empty if block
                }
                if ((linkFlags & LinkFlag.PROSCRIBED.get()) > 0) {
                    forceIgnore = true;
                }
                if ((linkFlags & LinkFlag.SPECIAL.get()) > 0) {
                    // empty if block
                }
                if ((linkFlags & LinkFlag.SWIM.get()) > 0) {
                    forceIgnore = true;
                }
                if ((linkFlags & LinkFlag.WALK.get()) > 0) {
                    // empty if block
                }
                if (!forceAdd && !forceIgnore) {
                    Line2D linkAsLine2D = new Line2D(link.getFromNavPoint().getLocation().x, link.getFromNavPoint().getLocation().y, link.getToNavPoint().getLocation().x, link.getToNavPoint().getLocation().y);
                    int currentPolygonId = this.getPolygonIdByPoint3D(link.getFromNavPoint().getLocation().asPoint3D());
                    int targetPolygonId = this.getPolygonIdByPoint3D(link.getToNavPoint().getLocation().asPoint3D());
                    int tabooPolygon = -1;
                    while (currentPolygonId >= 0 && currentPolygonId != targetPolygonId) {
                        int newPolygon = -1;
                        ArrayList neighbours = this.getNeighbourIdsToPolygon(currentPolygonId);
                        for (Integer neighbour : neighbours) {
                            if (neighbour == tabooPolygon) continue;
                            Line2D sharedEdge = null;
                            int[] polygon1 = this.getPolygon(currentPolygonId);
                            int[] polygon2 = this.getPolygon(neighbour);
                            for (int i = 0; i < polygon1.length; ++i) {
                                int v1 = polygon1[i];
                                int v2 = polygon1[i == polygon1.length - 1 ? 0 : i + 1];
                                boolean containsV1 = false;
                                boolean containsV2 = false;
                                for (int j = 0; j < polygon2.length; ++j) {
                                    if (polygon2[j] == v1) {
                                        containsV1 = true;
                                    }
                                    if (polygon2[j] != v2) continue;
                                    containsV2 = true;
                                }
                                if (!containsV1 || !containsV2) continue;
                                double[] vertex1 = this.getVertex(v1);
                                double[] vertex2 = this.getVertex(v2);
                                sharedEdge = new Line2D(vertex1[0], vertex1[1], vertex2[0], vertex2[1]);
                            }
                            if (sharedEdge == null) {
                                System.out.println("Error! shared edge between polygon " + currentPolygonId + " and " + neighbour + " was not found!");
                            }
                            if (linkAsLine2D.getIntersection(sharedEdge) == null) continue;
                            System.out.println("Crossed a line into polygon " + neighbour);
                            tabooPolygon = currentPolygonId;
                            newPolygon = neighbour;
                            break;
                        }
                        currentPolygonId = newPolygon;
                    }
                    addThisEdge = currentPolygonId <= 0;
                } else {
                    if (forceAdd) {
                        addThisEdge = true;
                    }
                    if (forceIgnore) {
                        addThisEdge = false;
                    }
                }
                if (addThisEdge) {
                    System.out.println("This edge is off-mesh!");
                    OffMeshPoint op1 = (OffMeshPoint)offPoints.get(uId);
                    OffMeshPoint op2 = (OffMeshPoint)offPoints.get(target.getId());
                    OffMeshEdge oe = new OffMeshEdge(op1, op2, link);
                    op1.getOutgoingEdges().add(oe);
                    op2.getIncomingEdges().add(oe);
                    continue;
                }
                System.out.println("This edge is not off-mesh.");
            }
        }
        this.offMeshPoints = new ArrayList();
        int offCount = 0;
        for (OffMeshPoint op : offPoints.values()) {
            if (op.getOutgoingEdges().isEmpty() && op.getIncomingEdges().isEmpty()) continue;
            this.offMeshPoints.add(op);
            ++offCount;
        }
        System.out.println("We found " + offCount + " offMeshPoints in total of " + offPoints.size() + " NavPoints.");
        this.polysToOffMeshPoints = new ArrayList();
        for (int i = 0; i < this.polys.size(); ++i) {
            this.polysToOffMeshPoints.add(new ArrayList());
        }
        for (OffMeshPoint op : this.offMeshPoints) {
            int pId = op.getPId();
            if (pId < 0) continue;
            this.polysToOffMeshPoints.get(pId).add(op);
        }
        System.out.println("Off-mesh connections done.");
    }

    public List<INavMeshAtom> getPolygonPath(INavMeshAtom fromAtom, INavMeshAtom toAtom) {
        ArrayList<AStarNode> pickable = new ArrayList<AStarNode>();
        ArrayList<AStarNode> expanded = new ArrayList<AStarNode>();
        pickable.add(new AStarNode(null, fromAtom, this, fromAtom, toAtom));
        AStarNode targetNode = null;
        while (targetNode == null) {
            if (pickable.isEmpty()) {
                return null;
            }
            AStarNode best = (AStarNode)pickable.get(0);
            for (AStarNode node : pickable) {
                if (!(node.getEstimatedTotalDistance() < best.getEstimatedTotalDistance())) continue;
                best = node;
            }
            List<INavMeshAtom> neighbours = best.getAtom().getNeighbours(this);
            for (INavMeshAtom atom : neighbours) {
                boolean add = true;
                for (AStarNode expNode : expanded) {
                    if (!expNode.getAtom().equals(atom)) continue;
                    add = false;
                }
                if (!add) continue;
                AStarNode newNode = new AStarNode(best, atom, this, fromAtom, toAtom);
                best.getFollowers().add(newNode);
                pickable.add(newNode);
                if (!atom.equals(toAtom)) continue;
                targetNode = newNode;
            }
            pickable.remove(best);
            expanded.add(best);
        }
        ArrayList<INavMeshAtom> path = new ArrayList<INavMeshAtom>();
        for (AStarNode node = targetNode; node != null; node = node.getFrom()) {
            path.add(node.getAtom());
        }
        Collections.reverse(path);
        return path;
    }

    public List<INavMeshAtom> getPolygonPath(Location from, Location to) {
        INavMeshAtom fromAtom = this.getNearestAtom(from);
        INavMeshAtom toAtom = this.getNearestAtom(to);
        return this.getPolygonPath(fromAtom, toAtom);
    }

    private List<ILocated> getPolygonCentrePath(ILocated from, ILocated to, List<INavMeshAtom> polygonPath) {
        ArrayList<ILocated> path = new ArrayList<ILocated>();
        path.add(from);
        Object lastAtom = null;
        for (INavMeshAtom atom : polygonPath) {
            if (atom.getClass() == OffMeshPoint.class) {
                NavPoint np = (NavPoint)((UT2004WorldView)this.server.getWorldView()).get(((OffMeshPoint)atom).getNavPointId());
                path.add(np);
            } else {
                NavMeshPolygon polygon = (NavMeshPolygon)atom;
                if (lastAtom == null || lastAtom.getClass() == OffMeshPoint.class) {
                    boolean inside;
                    OffMeshPoint op = (OffMeshPoint)lastAtom;
                    if (lastAtom == null) {
                        inside = this.polygonContainsPoint(polygon.getPolygonId(), new math.geom2d.Point2D(from.getLocation().x, from.getLocation().y));
                    } else {
                        inside = false;
                        List offPs = this.polysToOffMeshPoints.get(polygon.getPolygonId());
                        for (OffMeshPoint op2 : offPs) {
                            if (!op2.equals(op)) continue;
                            inside = true;
                        }
                    }
                    if (!inside) {
                        path.add(this.getLocation(atom));
                    }
                } else {
                    NavMeshPolygon polygon2 = (NavMeshPolygon)lastAtom;
                    int[] p1 = this.getPolygon(polygon.getPolygonId());
                    int[] p2 = this.getPolygon(polygon2.getPolygonId());
                    int v1 = -1;
                    int v2 = -1;
                    block2: for (int i = 0; i < p1.length; ++i) {
                        for (int j = 0; j < p2.length; ++j) {
                            if (p1[i] != p2[j]) continue;
                            if (v1 == -1) {
                                v1 = p1[i];
                                continue;
                            }
                            if (p1[i] == v1) break block2;
                            v2 = p1[i];
                            break block2;
                        }
                    }
                    double[] vv1 = this.getVertex(v1);
                    double[] vv2 = this.getVertex(v2);
                    path.add(new Location((vv1[0] + vv2[0]) / 2.0, (vv1[1] + vv2[1]) / 2.0, (vv1[2] + vv2[2]) / 2.0 + NavMeshConstants.liftPolygonLocation));
                }
            }
            lastAtom = atom;
        }
        path.add(to);
        return path;
    }

    private List<ILocated> getFunneledPath(ILocated from, ILocated to, List<INavMeshAtom> polygonPath) {
        ArrayList<ILocated> path = new ArrayList<ILocated>();
        path.add(from);
        INavMeshAtom lastAtom = null;
        INavMeshAtom atom = null;
        int index = -1;
        while (index < polygonPath.size() - 1) {
            lastAtom = ++index > 0 ? polygonPath.get(index - 1) : null;
            atom = polygonPath.get(index);
            if (atom.getClass() == OffMeshPoint.class) {
                NavPoint np = (NavPoint)((UT2004WorldView)this.server.getWorldView()).get(((OffMeshPoint)atom).getNavPointId());
                path.add(np);
                continue;
            }
            NavMeshPolygon polygon = (NavMeshPolygon)atom;
            if (lastAtom == null || lastAtom.getClass() == OffMeshPoint.class) {
                boolean inside;
                OffMeshPoint op = (OffMeshPoint)lastAtom;
                if (lastAtom == null) {
                    inside = this.polygonContainsPoint(polygon.getPolygonId(), new math.geom2d.Point2D(from.getLocation().x, from.getLocation().y));
                } else {
                    inside = false;
                    List offPs = this.polysToOffMeshPoints.get(polygon.getPolygonId());
                    for (OffMeshPoint op2 : offPs) {
                        if (!op2.equals(op)) continue;
                        inside = true;
                    }
                }
                if (inside) continue;
                path.add(this.getLocation(atom));
                continue;
            }
            ILocated start = (ILocated)path.get(path.size() - 1);
            NavMeshPolygon polygon2 = (NavMeshPolygon)lastAtom;
            int[] p1 = this.getPolygon(polygon.getPolygonId());
            int[] p2 = this.getPolygon(polygon2.getPolygonId());
            int v1 = -1;
            int v2 = -1;
            block2: for (int i = 0; i < p1.length; ++i) {
                for (int j = 0; j < p2.length; ++j) {
                    if (p1[i] != p2[j]) continue;
                    if (v1 == -1) {
                        v1 = p1[i];
                        continue;
                    }
                    if (p1[i] == v1) break block2;
                    v2 = p1[i];
                    break block2;
                }
            }
            double[] vv1 = this.getVertex(v1);
            double[] vv2 = this.getVertex(v2);
            Line2D gateway = new Line2D(vv1[0], vv1[1], vv2[0], vv2[1]);
            if (start.getLocation().x == vv2[0] && start.getLocation().y == vv2[1] || start.getLocation().x == vv1[0] && start.getLocation().y == vv1[1]) {
                System.out.println("We are already in the next polygon. No comparation, let's just continue.");
                continue;
            }
            double dist = gateway.getSignedDistance(start.getLocation().x, start.getLocation().y);
            Line2D leftMantinel = new Line2D(start.getLocation().x, start.getLocation().y, vv2[0], vv2[1]);
            Line2D rightMantinel = new Line2D(start.getLocation().x, start.getLocation().y, vv1[0], vv1[1]);
            if (dist < 0.0) {
                Line2D swap = leftMantinel;
                leftMantinel = rightMantinel;
                rightMantinel = swap;
                vv1 = this.getVertex(v2);
                vv2 = this.getVertex(v1);
                gateway = new Line2D(vv1[0], vv1[1], vv2[0], vv2[1]);
            }
            int leftMantinelIndex = index;
            double leftMantinelZ = vv2[2];
            Location leftMantinelTarget = this.safeVertex.get(v2) != false ? new Location(vv2[0], vv2[1], vv2[2] + NavMeshConstants.liftPolygonLocation) : (gateway.getLength() <= 2.0 * NavMeshConstants.agentRadius ? new Location((vv2[0] + vv1[0]) / 2.0, (vv2[1] + vv1[1]) / 2.0, (vv2[2] + vv1[2]) / 2.0 + NavMeshConstants.liftPolygonLocation) : new Location(vv2[0] + (vv1[0] - vv2[0]) / gateway.getLength() * NavMeshConstants.agentRadius, vv2[1] + (vv1[1] - vv2[1]) / gateway.getLength() * NavMeshConstants.agentRadius, vv2[2] + (vv1[2] - vv2[2]) / gateway.getLength() * NavMeshConstants.agentRadius + NavMeshConstants.liftPolygonLocation));
            int rightMantinelIndex = index;
            double rightMantinelZ = vv1[2];
            Location rightMantinelTarget = this.safeVertex.get(v1) != false ? new Location(vv1[0], vv1[1], vv1[2] + NavMeshConstants.liftPolygonLocation) : (gateway.getLength() <= 2.0 * NavMeshConstants.agentRadius ? new Location((vv2[0] + vv1[0]) / 2.0, (vv2[1] + vv1[1]) / 2.0, (vv2[2] + vv1[2]) / 2.0 + NavMeshConstants.liftPolygonLocation) : new Location(vv1[0] + (vv2[0] - vv1[0]) / gateway.getLength() * NavMeshConstants.agentRadius, vv1[1] + (vv2[1] - vv1[1]) / gateway.getLength() * NavMeshConstants.agentRadius, vv1[2] + (vv2[2] - vv1[2]) / gateway.getLength() * NavMeshConstants.agentRadius + NavMeshConstants.liftPolygonLocation));
            boolean targetAdded = false;
            boolean outOfMantinels = false;
            boolean endOfPolygonPathReached = false;
            while (!targetAdded && !outOfMantinels) {
                lastAtom = polygonPath.get(++index - 1);
                if (index < polygonPath.size()) {
                    atom = polygonPath.get(index);
                } else {
                    endOfPolygonPathReached = true;
                }
                polygon2 = (NavMeshPolygon)lastAtom;
                if (endOfPolygonPathReached || atom.getClass() == OffMeshPoint.class) {
                    NavPoint np = null;
                    if (!endOfPolygonPathReached) {
                        np = (NavPoint)((UT2004WorldView)this.server.getWorldView()).get(((OffMeshPoint)atom).getNavPointId());
                    }
                    ILocated target = endOfPolygonPathReached ? to : np;
                    Line2D virtualGateway1 = new Line2D(target.getLocation().x, target.getLocation().y, leftMantinel.p2.x, leftMantinel.p2.y);
                    dist = virtualGateway1.getSignedDistance(start.getLocation().x, start.getLocation().y);
                    if (dist < 0.0) {
                        path.add(leftMantinelTarget);
                        outOfMantinels = true;
                        index = leftMantinelIndex;
                        continue;
                    }
                    Line2D virtualGateway2 = new Line2D(rightMantinel.p2.x, rightMantinel.p2.y, target.getLocation().x, target.getLocation().y);
                    dist = virtualGateway2.getSignedDistance(start.getLocation().x, start.getLocation().y);
                    if (dist < 0.0) {
                        path.add(rightMantinelTarget);
                        outOfMantinels = true;
                        index = leftMantinelIndex;
                        continue;
                    }
                    if (!endOfPolygonPathReached) {
                        path.add(np);
                    }
                    targetAdded = true;
                    continue;
                }
                polygon = (NavMeshPolygon)atom;
                math.geom2d.Point2D middleOfOldGateway = new math.geom2d.Point2D((gateway.p1.x + gateway.p2.x) / 2.0, (gateway.p1.y + gateway.p2.y) / 2.0);
                p1 = this.getPolygon(polygon.getPolygonId());
                p2 = this.getPolygon(polygon2.getPolygonId());
                v1 = -1;
                v2 = -1;
                block5: for (int i = 0; i < p1.length; ++i) {
                    for (int j = 0; j < p2.length; ++j) {
                        if (p1[i] != p2[j]) continue;
                        if (v1 == -1) {
                            v1 = p1[i];
                            continue;
                        }
                        if (p1[i] == v1) break block5;
                        v2 = p1[i];
                        break block5;
                    }
                }
                if ((dist = (gateway = new Line2D((vv1 = this.getVertex(v1))[0], vv1[1], (vv2 = this.getVertex(v2))[0], vv2[1])).getSignedDistance(middleOfOldGateway)) < 0.0) {
                    vv1 = this.getVertex(v2);
                    vv2 = this.getVertex(v1);
                    gateway = new Line2D(vv1[0], vv1[1], vv2[0], vv2[1]);
                }
                if ((dist = leftMantinel.getSignedDistance(gateway.p2)) < 0.0) {
                    dist = rightMantinel.getSignedDistance(gateway.p2);
                    if (dist > 0.0) {
                        leftMantinel = new Line2D(leftMantinel.p1, gateway.p2);
                        leftMantinelIndex = index;
                        leftMantinelZ = vv2[2];
                        leftMantinelTarget = this.safeVertex.get(v2).booleanValue() ? new Location(vv2[0], vv2[1], vv2[2] + NavMeshConstants.liftPolygonLocation) : (gateway.getLength() <= 2.0 * NavMeshConstants.agentRadius ? new Location((vv2[0] + vv1[0]) / 2.0, (vv2[1] + vv1[1]) / 2.0, (vv2[2] + vv1[2]) / 2.0 + NavMeshConstants.liftPolygonLocation) : new Location(vv2[0] + (vv1[0] - vv2[0]) / gateway.getLength() * NavMeshConstants.agentRadius, vv2[1] + (vv1[1] - vv2[1]) / gateway.getLength() * NavMeshConstants.agentRadius, vv2[2] + (vv1[2] - vv2[2]) / gateway.getLength() * NavMeshConstants.agentRadius + NavMeshConstants.liftPolygonLocation));
                    } else {
                        path.add(rightMantinelTarget);
                        outOfMantinels = true;
                        index = rightMantinelIndex;
                    }
                }
                if (!((dist = rightMantinel.getSignedDistance(gateway.p1)) > 0.0)) continue;
                dist = leftMantinel.getSignedDistance(gateway.p1);
                if (dist < 0.0) {
                    rightMantinel = new Line2D(rightMantinel.p1, gateway.p1);
                    rightMantinelIndex = index;
                    rightMantinelZ = vv1[2];
                    if (this.safeVertex.get(v1).booleanValue()) {
                        rightMantinelTarget = new Location(vv1[0], vv1[1], vv1[2] + NavMeshConstants.liftPolygonLocation);
                        continue;
                    }
                    if (gateway.getLength() <= 2.0 * NavMeshConstants.agentRadius) {
                        rightMantinelTarget = new Location((vv2[0] + vv1[0]) / 2.0, (vv2[1] + vv1[1]) / 2.0, (vv2[2] + vv1[2]) / 2.0 + NavMeshConstants.liftPolygonLocation);
                        continue;
                    }
                    rightMantinelTarget = new Location(vv1[0] + (vv2[0] - vv1[0]) / gateway.getLength() * NavMeshConstants.agentRadius, vv1[1] + (vv2[1] - vv1[1]) / gateway.getLength() * NavMeshConstants.agentRadius, vv1[2] + (vv2[2] - vv1[2]) / gateway.getLength() * NavMeshConstants.agentRadius + NavMeshConstants.liftPolygonLocation);
                    continue;
                }
                path.add(leftMantinelTarget);
                outOfMantinels = true;
                index = leftMantinelIndex;
            }
        }
        path.add(to);
        return path;
    }

    public List<ILocated> getPath(ILocated from, ILocated to) {
        List<INavMeshAtom> polygonPath = this.getPolygonPath(from.getLocation(), to.getLocation());
        if (polygonPath == null) {
            return null;
        }
        List<ILocated> path = this.getFunneledPath(from, to, polygonPath);
        return path;
    }

    @Override
    public IPathFuture<ILocated> computePath(ILocated from, ILocated to) {
        return new PrecomputedPathFuture<ILocated>(from, to, this.getPath(from, to));
    }

    private INavMeshAtom getNearestAtom(Location location) {
        int pId = this.getPolygonIdByLocation(location);
        if (pId > 0) {
            return new NavMeshPolygon(pId);
        }
        double minDist = Double.MAX_VALUE;
        INavMeshAtom nearest = null;
        for (OffMeshPoint op : this.offMeshPoints) {
            double dist = location.getDistance(op.getLocation());
            if (!(dist < minDist)) continue;
            nearest = op;
            minDist = dist;
        }
        if (nearest == null) {
            for (int i = 0; i < this.polys.size(); ++i) {
                NavMeshPolygon p = new NavMeshPolygon(i);
                Location pl = this.getLocation(p);
                double dist = location.getDistance(pl);
                if (!(dist < minDist)) continue;
                nearest = p;
                minDist = dist;
            }
        }
        return nearest;
    }

    double getDistance(INavMeshAtom atom1, INavMeshAtom atom2) {
        if (atom1.equals(atom2)) {
            return 0.0;
        }
        Location l1 = this.getLocation(atom1);
        Location l2 = this.getLocation(atom2);
        return l1.getDistance(l2);
    }

    private Location getLocation(INavMeshAtom atom1) {
        if (atom1.getClass() == OffMeshPoint.class) {
            return this.getLocation((OffMeshPoint)atom1);
        }
        if (atom1.getClass() == NavMeshPolygon.class) {
            return this.getLocation((NavMeshPolygon)atom1);
        }
        throw new UnsupportedOperationException("Not implemented. Not now. Not ever.");
    }

    private Location getLocation(OffMeshPoint op) {
        NavPoint np = (NavPoint)((UT2004WorldView)this.server.getWorldView()).get(op.getNavPointId());
        return np.getLocation();
    }

    private Location getLocation(NavMeshPolygon p) {
        int[] polygon = this.getPolygon(p.getPolygonId());
        double sumX = 0.0;
        double sumY = 0.0;
        double sumZ = 0.0;
        for (int i = 0; i < polygon.length; ++i) {
            double[] v = this.getVertex(polygon[i]);
            sumX += v[0];
            sumY += v[1];
            sumZ += v[2];
        }
        return new Location(sumX / (double)polygon.length, sumY / (double)polygon.length, sumZ / (double)polygon.length + NavMeshConstants.liftPolygonLocation);
    }

    public LevelGeometry getLevelGeometry() {
        return this.levelGeometry;
    }

    public double getDistanceFromEdge(Location location, Vector2d vector, double rayLength) {
        if (rayLength <= 0.0) {
            return 0.0;
        }
        vector.normalize();
        vector.x *= rayLength;
        vector.y *= rayLength;
        Location end = new Location(location.x + vector.x, location.y + vector.y);
        Line2D ray = new Line2D(location.x, location.y, end.x, end.y);
        int pId = this.getPolygonIdByLocation(location);
        if (pId < 0) {
            return 0.0;
        }
        int currentPolygonId = pId;
        int lastPolygonId = -1;
        int nextPolygonId = -1;
        math.geom2d.Point2D cross = null;
        int v1 = -1;
        int v2 = -1;
        int[] polygon = this.getPolygon(currentPolygonId);
        for (int i = 0; i < polygon.length; ++i) {
            double[] vertex2;
            v1 = polygon[i];
            v2 = polygon[i == polygon.length - 1 ? 0 : i + 1];
            double[] vertex1 = this.getVertex(v1);
            Line2D edge = new Line2D(vertex1[0], vertex1[1], (vertex2 = this.getVertex(v2))[0], vertex2[1]);
            cross = ray.getIntersection(edge);
            if (cross == null) continue;
            if (cross.x <= Math.max(edge.p1.x, edge.p2.x) && cross.x >= Math.min(edge.p1.x, edge.p2.x) && cross.x <= Math.max(ray.p1.x, ray.p2.x) && cross.x >= Math.min(ray.p1.x, ray.p2.x)) break;
            cross = null;
        }
        if (cross == null || ray.p1.getDistance(cross) >= rayLength) {
            return 0.0;
        }
        nextPolygonId = this.getNeighbourPolygon(currentPolygonId, v1, v2);
        if (nextPolygonId == -1) {
            return ray.p1.getDistance(cross);
        }
        vector = (Vector2d)vector.clone();
        vector.normalize();
        Location crossLocation = new Location(cross.x + vector.x, cross.y + vector.y, location.z);
        return this.getDistanceFromEdge(crossLocation, vector, rayLength - ray.p1.getDistance(cross));
    }

    public double getDistanceFromEdge(Location location, Vector2d vector) {
        return this.getDistanceFromEdge(location, vector, Double.MAX_VALUE);
    }

    private int getNeighbourPolygon(int currentPolygonId, int v1, int v2) {
        ArrayList neighbours = this.getNeighbourIdsToPolygon(currentPolygonId);
        for (Integer neighbour : neighbours) {
            int[] polygon2 = this.getPolygon(neighbour);
            boolean containsV1 = false;
            boolean containsV2 = false;
            for (int j = 0; j < polygon2.length; ++j) {
                if (polygon2[j] == v1) {
                    containsV1 = true;
                }
                if (polygon2[j] != v2) continue;
                containsV2 = true;
            }
            if (!containsV1 || !containsV2) continue;
            return neighbour;
        }
        return -1;
    }
}

