/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.IOException;
import java.util.List;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.event.ParseOptions;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.type.SchemaType;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class AugmentedSource
implements Source {
    private Source source;
    private ParseOptions options = new ParseOptions();
    private EntityResolver entityResolver = null;

    private AugmentedSource(Source source) {
        if (source instanceof AugmentedSource) {
            throw new IllegalArgumentException("Contained source must not be an AugmentedSource");
        }
        this.source = source;
    }

    public static AugmentedSource makeAugmentedSource(Source source) {
        if (source instanceof AugmentedSource) {
            return (AugmentedSource)source;
        }
        return new AugmentedSource(source);
    }

    public void addFilter(ProxyReceiver filter) {
        this.options.addFilter(filter);
    }

    public List getFilters() {
        return this.options.getFilters();
    }

    public Source getContainedSource() {
        return this.source;
    }

    public void setStripSpace(int stripAction) {
        this.options.setStripSpace(stripAction);
    }

    public int getStripSpace() {
        return this.options.getStripSpace();
    }

    public void setTreeModel(int model) {
        this.options.setTreeModel(model);
    }

    public int getTreeModel() {
        return this.options.getTreeModel();
    }

    public void setSchemaValidationMode(int option) {
        this.options.setSchemaValidationMode(option);
    }

    public int getSchemaValidation() {
        return this.options.getSchemaValidationMode();
    }

    public void setTopLevelElement(StructuredQName elementName) {
        this.options.setTopLevelElement(elementName);
    }

    public StructuredQName getTopLevelElement() {
        return this.options.getTopLevelElement();
    }

    public void setTopLevelType(SchemaType type) {
        this.options.setTopLevelType(type);
    }

    public SchemaType getTopLevelType() {
        return this.options.getTopLevelType();
    }

    public void setDTDValidationMode(int option) {
        this.options.setDTDValidationMode(option);
    }

    public int getDTDValidation() {
        return this.options.getDTDValidationMode();
    }

    public void setLineNumbering(boolean lineNumbering) {
        this.options.setLineNumbering(lineNumbering);
    }

    public boolean isLineNumbering() {
        return this.options.isLineNumbering();
    }

    public boolean isLineNumberingSet() {
        return this.options.isLineNumberingSet();
    }

    public void setXMLReader(XMLReader parser2) {
        this.options.setXMLReader(parser2);
        if (this.source instanceof SAXSource) {
            ((SAXSource)this.source).setXMLReader(parser2);
        }
    }

    public XMLReader getXMLReader() {
        XMLReader parser2 = this.options.getXMLReader();
        if (parser2 != null) {
            return parser2;
        }
        if (this.source instanceof SAXSource) {
            return ((SAXSource)this.source).getXMLReader();
        }
        return null;
    }

    public void setWrapDocument(Boolean wrap) {
        this.options.setWrapDocument(wrap);
    }

    public Boolean getWrapDocument() {
        return this.options.getWrapDocument();
    }

    public void setSystemId(String id) {
        this.source.setSystemId(id);
    }

    public String getSystemId() {
        return this.source.getSystemId();
    }

    public void setXIncludeAware(boolean state) {
        this.options.setXIncludeAware(state);
    }

    public boolean isXIncludeAwareSet() {
        return this.options.isXIncludeAwareSet();
    }

    public boolean isXIncludeAware() {
        return this.options.isXIncludeAware();
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setErrorListener(ErrorListener listener) {
        this.options.setErrorListener(listener);
    }

    public ErrorListener getErrorListener() {
        return this.options.getErrorListener();
    }

    public void setPleaseCloseAfterUse(boolean close) {
        this.options.setPleaseCloseAfterUse(close);
    }

    public boolean isPleaseCloseAfterUse() {
        return this.options.isPleaseCloseAfterUse();
    }

    public void setSourceIsXQJ(boolean flag) {
        this.options.setSourceIsXQJ(flag);
    }

    public boolean sourceIsXQJ() {
        return this.options.sourceIsXQJ();
    }

    public void close() {
        try {
            InputSource is;
            if (this.source instanceof StreamSource) {
                StreamSource ss = (StreamSource)this.source;
                if (ss.getInputStream() != null) {
                    ss.getInputStream().close();
                }
                if (ss.getReader() != null) {
                    ss.getReader().close();
                }
            } else if (this.source instanceof SAXSource && (is = ((SAXSource)this.source).getInputSource()) != null) {
                if (is.getByteStream() != null) {
                    is.getByteStream().close();
                }
                if (is.getCharacterStream() != null) {
                    is.getCharacterStream().close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

