/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut3.factory.guice.remoteagent;

import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import cz.cuni.amis.pogamut.base.agent.params.impl.AgentParameters;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnection;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.ISocketConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnection;
import cz.cuni.amis.pogamut.base.communication.parser.IWorldMessageParser;
import cz.cuni.amis.pogamut.base.communication.parser.impl.yylex.IYylex;
import cz.cuni.amis.pogamut.base.communication.parser.impl.yylex.IYylexObserver;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceRemoteAgentModule;
import cz.cuni.amis.pogamut.base.utils.guice.AdaptableProvider;
import cz.cuni.amis.pogamut.ut2004.agent.params.UT2004AgentParameters;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemTypeTranslator;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Yylex;
import cz.cuni.amis.pogamut.ut2004.communication.parser.IUT2004Yylex;
import cz.cuni.amis.pogamut.ut2004.communication.parser.UT2004Parser;
import cz.cuni.amis.pogamut.ut3.communication.messages.UT3ItemTypeTranslator;

public class UT3CommunicationModule<PARAMS extends UT2004AgentParameters>
extends GuiceRemoteAgentModule<PARAMS> {
    protected AdaptableProvider<ComponentDependencies> connectionDependenciesProvider = new AdaptableProvider<Object>(null);

    @Override
    public void prepareNewAgent(PARAMS agentParameters) {
        super.prepareNewAgent(agentParameters);
        this.connectionDependenciesProvider.set(new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add(((AgentParameters)agentParameters).getAgentId()));
    }

    @Override
    protected void configureModules() {
        super.configureModules();
        this.addModule(new AbstractModule(){

            @Override
            public void configure() {
                this.bind(IWorldConnection.class).to(SocketConnection.class);
                this.bind(ComponentDependencies.class).annotatedWith(Names.named("ConnectionDependency")).toProvider(UT3CommunicationModule.this.connectionDependenciesProvider);
                this.bind(ISocketConnectionAddress.class).annotatedWith(Names.named("ConnectionAddressDependency")).toProvider(UT3CommunicationModule.this.getAddressProvider());
                this.bind(IWorldMessageParser.class).to(UT2004Parser.class);
                this.bind(ItemTypeTranslator.class).to(UT3ItemTypeTranslator.class);
                this.bind(IYylex.class).to(IUT2004Yylex.class);
                this.bind(IUT2004Yylex.class).to(Yylex.class);
                this.bind(IYylexObserver.class).to(IYylexObserver.LogObserver.class);
                this.bind(UT2004AgentParameters.class).toProvider(UT3CommunicationModule.this.getAgentParamsProvider());
            }
        });
    }
}

