/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.ItemDescriptor;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.WeaponDescriptor;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.ItemDescriptorObtained;
import java.util.HashMap;
import java.util.Map;

public class ItemDescriptors
extends SensorModule<UT2004Bot> {
    private Map<String, ItemDescriptor> inventoryTypeDescs = new HashMap<String, ItemDescriptor>();
    private Map<ItemType, ItemDescriptor> descs = new HashMap<ItemType, ItemDescriptor>();
    private HashMap<ItemType, ItemType> ammoToWeapon = new HashMap();
    private ItemDescriptorObtainedListener itemDescObtainedListener;

    public ItemType getWeaponForAmmo(ItemType ammoType) {
        if (ammoType == null) {
            return null;
        }
        return this.ammoToWeapon.get(ammoType);
    }

    public boolean hasDescriptor(ItemType itemType) {
        if (itemType == null) {
            return false;
        }
        return this.descs.containsKey(itemType);
    }

    public ItemDescriptor getDescriptor(ItemType itemType) {
        if (itemType == null) {
            return null;
        }
        return this.descs.get(itemType);
    }

    public boolean hasDescriptor(String inventoryType) {
        if (inventoryType == null) {
            return false;
        }
        return this.inventoryTypeDescs.containsKey(inventoryType);
    }

    public ItemDescriptor getDescriptor(String inventoryType) {
        if (inventoryType == null) {
            return null;
        }
        return this.inventoryTypeDescs.get(inventoryType);
    }

    public ItemDescriptors(UT2004Bot bot) {
        this(bot, null);
    }

    public ItemDescriptors(UT2004Bot bot, LogCategory moduleLog) {
        super(bot, moduleLog);
        this.itemDescObtainedListener = new ItemDescriptorObtainedListener(bot.getWorldView());
        this.cleanUp();
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this.inventoryTypeDescs.clear();
        this.descs.clear();
    }

    private class ItemDescriptorObtainedListener
    implements IWorldEventListener<ItemDescriptorObtained> {
        private IWorldView worldView;

        public ItemDescriptorObtainedListener(IWorldView worldView) {
            worldView.addEventListener(ItemDescriptorObtained.class, this);
            this.worldView = worldView;
        }

        @Override
        public void notify(ItemDescriptorObtained event) {
            ItemDescriptors.this.log.info("Processing: " + event);
            if (event.getItemDescriptor() == null) {
                return;
            }
            ItemDescriptors.this.inventoryTypeDescs.put(event.getItemDescriptor().getInventoryType(), event.getItemDescriptor());
            ItemDescriptors.this.descs.put(event.getItemDescriptor().getPickupType(), event.getItemDescriptor());
            if (event.getItemDescriptor() instanceof WeaponDescriptor) {
                WeaponDescriptor desc = (WeaponDescriptor)event.getItemDescriptor();
                if (desc.getPriAmmoItemType() != null) {
                    ItemDescriptors.this.ammoToWeapon.put(desc.getPriAmmoItemType(), desc.getPickupType());
                }
                if (desc.getSecAmmoItemType() != null) {
                    ItemDescriptors.this.ammoToWeapon.put(desc.getSecAmmoItemType(), desc.getPickupType());
                }
            }
        }
    }
}

