/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.NumberFn;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.GenericAtomicComparer;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.StringValue;

public class GeneralComparison10
extends BinaryExpression {
    protected int singletonOperator;
    protected AtomicComparer comparer;
    private boolean atomize0 = true;
    private boolean atomize1 = true;
    private boolean maybeBoolean0 = true;
    private boolean maybeBoolean1 = true;

    public GeneralComparison10(Expression p0, int op, Expression p1) {
        super(p0, op, p1);
        this.singletonOperator = GeneralComparison10.getSingletonOperator(op);
    }

    public int computeCardinality() {
        return 16384;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand0 = visitor.typeCheck(this.operand0, contextItemType);
        this.operand1 = visitor.typeCheck(this.operand1, contextItemType);
        StaticContext env = visitor.getStaticContext();
        StringCollator comp = env.getCollation(env.getDefaultCollationName());
        if (comp == null) {
            comp = CodepointCollator.getInstance();
        }
        XPathContext context = env.makeEarlyEvaluationContext();
        this.comparer = new GenericAtomicComparer(comp, context);
        if (this.operand0 instanceof Literal && this.operand1 instanceof Literal) {
            return Literal.makeLiteral((AtomicValue)this.evaluateItem(context));
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Optimizer opt = visitor.getConfiguration().getOptimizer();
        StaticContext env = visitor.getStaticContext();
        this.operand0 = visitor.optimize(this.operand0, contextItemType);
        this.operand1 = visitor.optimize(this.operand1, contextItemType);
        this.operand0 = ExpressionTool.unsorted(opt, this.operand0, false);
        this.operand1 = ExpressionTool.unsorted(opt, this.operand1, false);
        if (this.operand0 instanceof Literal && this.operand1 instanceof Literal) {
            return Literal.makeLiteral((AtomicValue)this.evaluateItem(env.makeEarlyEvaluationContext()));
        }
        TypeHierarchy th = env.getConfiguration().getTypeHierarchy();
        ItemType type0 = this.operand0.getItemType(th);
        ItemType type1 = this.operand1.getItemType(th);
        if (type0.isAtomicType()) {
            this.atomize0 = false;
        }
        if (type1.isAtomicType()) {
            this.atomize1 = false;
        }
        if (th.relationship(type0, BuiltInAtomicType.BOOLEAN) == 4) {
            this.maybeBoolean0 = false;
        }
        if (th.relationship(type1, BuiltInAtomicType.BOOLEAN) == 4) {
            this.maybeBoolean1 = false;
        }
        if (!this.maybeBoolean0 && !this.maybeBoolean1) {
            boolean numeric1;
            int n0 = th.relationship(type0, BuiltInAtomicType.NUMERIC);
            int n1 = th.relationship(type1, BuiltInAtomicType.NUMERIC);
            boolean maybeNumeric0 = n0 != 4;
            boolean maybeNumeric1 = n1 != 4;
            boolean numeric0 = n0 == 2 || n0 == 0;
            boolean bl = numeric1 = n1 == 2 || n1 == 0;
            if (this.operator == 6 || this.operator == 22) {
                if (!maybeNumeric0 && !maybeNumeric1 || numeric0 && numeric1) {
                    BinaryExpression gc = opt.makeGeneralComparison(this.operand0, this.operator, this.operand1, false);
                    ExpressionTool.copyLocationInfo(this, gc);
                    return visitor.optimize(visitor.typeCheck(gc, contextItemType), contextItemType);
                }
            } else if (numeric0 && numeric1) {
                BinaryExpression gc = opt.makeGeneralComparison(this.operand0, this.operator, this.operand1, false);
                ExpressionTool.copyLocationInfo(this, gc);
                return visitor.optimize(visitor.typeCheck(gc, contextItemType), contextItemType);
            }
        }
        return this;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        SequenceIterator iter0 = null;
        if (this.maybeBoolean0) {
            Item i02;
            iter0 = this.operand0.iterate(context);
            Item i01 = iter0.next();
            Item item = i02 = i01 == null ? null : iter0.next();
            if (i01 instanceof BooleanValue && i02 == null) {
                boolean b = this.operand1.effectiveBooleanValue(context);
                return GeneralComparison10.compare((BooleanValue)i01, this.singletonOperator, BooleanValue.get(b), this.comparer, context);
            }
            if (i01 == null && !this.maybeBoolean1) {
                return false;
            }
        }
        SequenceIterator iter1 = null;
        if (this.maybeBoolean1) {
            Item i12;
            iter1 = this.operand1.iterate(context);
            Item i11 = iter1.next();
            Item item = i12 = i11 == null ? null : iter1.next();
            if (i11 instanceof BooleanValue && i12 == null) {
                boolean b = this.operand0.effectiveBooleanValue(context);
                return GeneralComparison10.compare(BooleanValue.get(b), this.singletonOperator, (BooleanValue)i11, this.comparer, context);
            }
            if (i11 == null && !this.maybeBoolean0) {
                return false;
            }
        }
        iter0 = iter0 == null ? this.operand0.iterate(context) : iter0.getAnother();
        iter1 = iter1 == null ? this.operand1.iterate(context) : iter1.getAnother();
        if (this.atomize0) {
            iter0 = Atomizer.getAtomizingIterator(iter0);
        }
        if (this.atomize1) {
            iter1 = Atomizer.getAtomizingIterator(iter1);
        }
        if (this.operator == 12 || this.operator == 14 || this.operator == 11 || this.operator == 13) {
            iter0 = new ItemMappingIterator(iter0, new NumberFn());
            iter1 = new ItemMappingIterator(iter1, new NumberFn());
        }
        ArrayList<AtomicValue> seq1 = null;
        AtomicValue item0;
        block2: while ((item0 = (AtomicValue)iter0.next()) != null) {
            if (iter1 == null) {
                AtomicValue item1;
                Iterator listIter1 = seq1.iterator();
                do {
                    if (!listIter1.hasNext()) continue block2;
                } while (!GeneralComparison10.compare(item0, this.singletonOperator, item1 = (AtomicValue)listIter1.next(), this.comparer, context));
                return true;
            }
            while (true) {
                AtomicValue item1;
                if ((item1 = (AtomicValue)iter1.next()) == null) {
                    iter1 = null;
                    if (seq1 == null) return false;
                    continue block2;
                }
                try {
                    if (GeneralComparison10.compare(item0, this.singletonOperator, item1, this.comparer, context)) {
                        return true;
                    }
                    if (seq1 == null) {
                        seq1 = new ArrayList<AtomicValue>(40);
                    }
                    seq1.add(item1);
                }
                catch (XPathException e) {
                    e.maybeSetLocation(this);
                    e.maybeSetContext(context);
                    throw e;
                }
            }
            break;
        }
        return false;
    }

    public Expression copy() {
        GeneralComparison10 gc = new GeneralComparison10(this.operand0.copy(), this.operator, this.operand1.copy());
        gc.comparer = this.comparer;
        gc.atomize0 = this.atomize0;
        gc.atomize1 = this.atomize1;
        gc.maybeBoolean0 = this.maybeBoolean0;
        gc.maybeBoolean1 = this.maybeBoolean1;
        return gc;
    }

    private static boolean compare(AtomicValue a0, int operator2, AtomicValue a1, AtomicComparer comparer, XPathContext context) throws XPathException {
        comparer = comparer.provideContext(context);
        BuiltInAtomicType t0 = a0.getPrimitiveType();
        BuiltInAtomicType t1 = a1.getPrimitiveType();
        if (t0.isPrimitiveNumeric() || t1.isPrimitiveNumeric()) {
            DoubleValue v0 = NumberFn.convert(a0);
            DoubleValue v1 = NumberFn.convert(a1);
            return ValueComparison.compare(v0, operator2, v1, comparer);
        }
        if (t0.equals(BuiltInAtomicType.STRING) || t1.equals(BuiltInAtomicType.STRING) || t0.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && t1.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            StringValue s0 = (StringValue)a0.convert(BuiltInAtomicType.STRING, true, context).asAtomic();
            StringValue s1 = (StringValue)a1.convert(BuiltInAtomicType.STRING, true, context).asAtomic();
            return ValueComparison.compare(s0, operator2, s1, comparer);
        }
        if (t0.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            a0 = a0.convert(t1, true, context).asAtomic();
        }
        if (t1.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            a1 = a1.convert(t0, true, context).asAtomic();
        }
        return ValueComparison.compare(a0, operator2, a1, comparer);
    }

    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.BOOLEAN;
    }

    private static int getSingletonOperator(int op) {
        switch (op) {
            case 6: {
                return 44;
            }
            case 13: {
                return 48;
            }
            case 22: {
                return 45;
            }
            case 12: {
                return 47;
            }
            case 11: {
                return 46;
            }
            case 14: {
                return 49;
            }
        }
        return op;
    }

    protected String displayOperator() {
        return "many-to-many (1.0) " + super.displayOperator();
    }
}

