/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.bot.impl.test;

import cz.cuni.amis.pogamut.base.agent.module.LogicModule;
import cz.cuni.amis.pogamut.base.communication.parser.impl.yylex.YylexParser;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.test.BotModuleTestLogic;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UT2004ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import java.util.logging.Level;

public class ModuleCheckingBot
extends BotModuleTestLogic {
    boolean prepareBotCalled = false;
    boolean logicInitializedCalled = false;
    boolean botInitializedCalled = false;
    boolean botSpawnedCalled = false;
    boolean gameInfoSensed = false;
    boolean gameModuleGameInfoSensed = false;
    IWorldObjectListener<GameInfo> gameInfoListener = new IWorldObjectListener<GameInfo>(){

        @Override
        public void notify(IWorldObjectEvent<GameInfo> event) {
            ModuleCheckingBot.this.gameInfoSensed = true;
            if (event.getObject() == null) {
                throw new RuntimeException("GameInfo event received, but the inner object was NULL!!!");
            }
            ModuleCheckingBot.this.gameModuleGameInfoSensed = ModuleCheckingBot.this.game.getGameInfo() != null;
        }
    };

    private void fail(String message) {
        this.log.severe(message);
        throw new RuntimeException(message);
    }

    @Override
    public void prepareBot(UT2004Bot bot) {
        if (this.prepareBotCalled) {
            this.fail("prepareBot(): called twice!!!");
        }
        this.prepareBotCalled = true;
        if (bot == null) {
            this.fail("prepareBot(): bot is null!!!");
        }
        bot.getLogger().getCategory(YylexParser.COMPONENT_ID.getToken()).setLevel(Level.ALL);
        bot.getWorldView().addObjectListener(GameInfo.class, this.gameInfoListener);
        this.game.getLog().setLevel(Level.ALL);
        this.descriptors.getLog().setLevel(Level.ALL);
    }

    @Override
    public void logicInitialize(LogicModule logicModule) {
        super.logicInitialize(logicModule);
        if (this.logicInitializedCalled) {
            this.fail("logicInitialized(): called twice!!!");
        }
        this.logicInitializedCalled = true;
        if (logicModule == null) {
            this.fail("logicInitialize(): logicModule is null!!!");
        }
    }

    @Override
    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
        if (this.botInitializedCalled) {
            this.fail("botInitialized(): called twice!!!");
        }
        this.botInitializedCalled = true;
        if (gameInfo == null) {
            this.fail("botInitialized(): gameInfo is null!!!");
        }
        if (currentConfig == null) {
            this.fail("botInitialized(): currentConfig is null!!!");
        }
        if (init == null) {
            this.fail("botInitialized(): init is null!!!");
        }
    }

    @Override
    public void botFirstSpawn(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init, Self self) {
        if (this.botSpawnedCalled) {
            this.fail("botSpawned(): called twice!!!");
        }
        this.botSpawnedCalled = true;
        if (gameInfo == null) {
            this.fail("botSpawned(): gameInfo is null!!!");
        }
        if (currentConfig == null) {
            this.fail("botSpawned(): currentConfig is null!!!");
        }
        if (init == null) {
            this.fail("botSpawned(): init is null!!!");
        }
        if (self == null) {
            this.fail("botSpawned(): self is null!!!");
        }
    }

    @Override
    public void logic() {
        if (!this.prepareBotCalled) {
            this.fail("logic(): prepareBot() not called!!!");
        }
        if (!this.logicInitializedCalled) {
            this.fail("logic(): logicInitialized() not called!!!");
        }
        if (!this.botInitializedCalled) {
            this.fail("logic(): botInitialized() not called!!!");
        }
        if (!this.botSpawnedCalled) {
            this.fail("logic(): botSpawned() not called!!!");
        }
        this.log.info("LOGIC!");
        this.moduleCheck();
        super.logic();
    }

    private void moduleCheck() {
        boolean failure = false;
        this.log.info("MODULE CHECK");
        StringBuffer sb = new StringBuffer();
        sb.append("moduleCheck(): ERRORS ");
        try {
            if (this.info.getSelf() == null) {
                sb.append("| info.getSelf() is null!!!");
                failure = true;
            }
        }
        catch (Exception e) {
            failure = true;
        }
        try {
            if (this.info.getLocation() == null) {
                sb.append("| info.getLocation() is null!!!");
                failure = true;
            }
        }
        catch (Exception e) {
            failure = true;
        }
        try {
            if (this.info.getCurrentWeapon() == null) {
                sb.append("| info.getCurrentWeapon() is null!!!");
                failure = true;
            }
        }
        catch (Exception e) {
            failure = true;
        }
        try {
            if (this.config.getConfig() == null) {
                sb.append("| config.getConfig() is null!!!");
                failure = true;
            }
        }
        catch (Exception e) {
            failure = true;
        }
        try {
            if (this.game.getGameInfo() == null) {
                sb.append("| game.getGameInfo() is null!!!");
                failure = true;
            }
        }
        catch (Exception e) {
            failure = true;
        }
        try {
            if (this.game.getGameType() == null) {
                sb.append("| game.getGameType() is null!!!");
                failure = true;
            }
        }
        catch (Exception e) {
            failure = true;
        }
        try {
            if (this.game.getMapName() == null) {
                sb.append("| game.getMapName() is null!!!");
                failure = true;
            }
        }
        catch (Exception e) {
            failure = true;
        }
        try {
            if (this.game.getTeamScoreLimit() == null) {
                sb.append("| game.getTeamScoreLimit() is null!!!");
                failure = true;
            }
        }
        catch (Exception e) {
            failure = true;
        }
        try {
            if (this.game.getTimeLimit() == null) {
                sb.append("| game.getTimeLimit() is null!!!");
                failure = true;
            }
        }
        catch (Exception e) {
            failure = true;
        }
        try {
            if (this.descriptors.getDescriptor(UT2004ItemType.ASSAULT_RIFLE) == null) {
                sb.append("| descriptors.getDescriptor(ItemType.ASSAULT_RIFLE) is null!!!");
                failure = true;
            }
        }
        catch (Exception e) {
            failure = true;
        }
        try {
            if (this.items.getRandomItem() == null) {
                sb.append("| items.getRandomItem() is null!!!");
                failure = true;
            }
        }
        catch (Exception e) {
            failure = true;
        }
        try {
            if (this.players == null) {
                sb.append("| players is null!!!");
                failure = true;
            }
        }
        catch (Exception e) {
            failure = true;
        }
        try {
            if (this.world.getAll(Item.class).size() == 0) {
                sb.append("| there is no Item present in the world view!!!");
                failure = true;
            }
        }
        catch (Exception e) {
            failure = true;
        }
        try {
            if (this.world.getAll(NavPoint.class).size() == 0) {
                sb.append("| there is no NavPoint present in the world view!!!");
                failure = true;
            }
        }
        catch (Exception e) {
            failure = true;
        }
        if (!this.gameInfoSensed) {
            sb.append("| GAMEINFO was not sensed by our custom listener!!!");
            failure = true;
        } else {
            sb.append("| GAMEINFO was SENSED by our custom listener OK.");
        }
        if (failure) {
            this.fail(sb.toString());
        }
    }

    @Override
    public void botShutdown() {
        this.logicInitializedCalled = false;
        this.botInitializedCalled = false;
        this.botSpawnedCalled = false;
    }
}

