/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.bot.impl;

import com.google.inject.Inject;
import cz.cuni.amis.introspection.Folder;
import cz.cuni.amis.introspection.java.ReflectionObjectFolder;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.agent.jmx.AgentJMXComponents;
import cz.cuni.amis.pogamut.base.agent.jmx.adapter.AgentMBeanAdapter;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.react.EventReact;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.event.BusAwareCountDownLatch;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantStartException;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base3d.agent.AbstractAgent3D;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.ProjectileCleanUp;
import cz.cuni.amis.pogamut.ut2004.bot.IUT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.IUT2004BotController;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotName;
import cz.cuni.amis.pogamut.ut2004.bot.jmx.BotJMXMBeanAdapter;
import cz.cuni.amis.pogamut.ut2004.bot.params.UT2004BotParameters;
import cz.cuni.amis.pogamut.ut2004.bot.state.impl.BotStateHelloBotReceived;
import cz.cuni.amis.pogamut.ut2004.bot.state.impl.BotStateInited;
import cz.cuni.amis.pogamut.ut2004.bot.state.impl.BotStatePassword;
import cz.cuni.amis.pogamut.ut2004.bot.state.impl.BotStateSendingInit;
import cz.cuni.amis.pogamut.ut2004.bot.state.impl.BotStateSpawned;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DisconnectBot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.PasswordReply;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Ready;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Respawn;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.HelloBotHandshake;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Password;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.InitCommandRequest;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.ReadyCommandRequest;
import cz.cuni.amis.pogamut.ut2004.utils.PogamutUT2004Property;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.exception.PogamutJMXException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

@AgentScoped
public class UT2004Bot<WORLD_VIEW extends IVisionWorldView, ACT extends IAct, CONTROLLER extends IUT2004BotController>
extends AbstractAgent3D<WORLD_VIEW, ACT>
implements IUT2004Bot {
    private CONTROLLER controller;
    private BusAwareCountDownLatch endMessageLatch;
    private boolean botStoppedCalled = false;
    private EventReact<HelloBotHandshake> helloBotReaction;
    private UT2004BotParameters params;
    private UT2004BotName botName;
    private ProjectileCleanUp projectileCleanUp;
    protected Thread botDisconnectorThread;
    private IWorldEventListener<ReadyCommandRequest> readyCommandRequestListener = new IWorldEventListener<ReadyCommandRequest>(){

        @Override
        public void notify(ReadyCommandRequest event) {
            UT2004Bot.this.controller.getLog().setLevel(Level.ALL);
            UT2004Bot.this.setState(new BotStateHelloBotReceived("GameBots2004 greeted us, adding custom listeners onto the worldview."));
            UT2004Bot.this.readyCommandRequested();
            UT2004Bot.this.setState(new BotStateHelloBotReceived("READY sent, handshaking."));
        }
    };
    private IWorldEventListener<InitCommandRequest> initCommandRequestListener = new IWorldEventListener<InitCommandRequest>(){

        @Override
        public void notify(InitCommandRequest event) {
            UT2004Bot.this.setState(new BotStateSendingInit("Handshake over, sending INIT."));
            UT2004Bot.this.initCommandRequested();
            UT2004Bot.this.setState(new BotStateSendingInit("Handshake over, INIT sent."));
        }
    };
    private IWorldEventListener<Password> passwordRequestedListener = new IWorldEventListener<Password>(){

        @Override
        public void notify(Password event) {
            UT2004Bot.this.setState(new BotStatePassword("Password requested by the world."));
            PasswordReply passwordReply = UT2004Bot.this.getController().getPassword();
            if (passwordReply == null) {
                if (UT2004Bot.this.log.isLoggable(Level.WARNING)) {
                    UT2004Bot.this.log.warning("createPasswordReply() returned null");
                }
                passwordReply = new PasswordReply("");
            }
            if (UT2004Bot.this.log.isLoggable(Level.INFO)) {
                UT2004Bot.this.log.info("Password required for the world, replying with '" + passwordReply.getPassword() + "'.");
            }
            UT2004Bot.this.getAct().act(passwordReply);
            UT2004Bot.this.setState(new BotStatePassword("Password sent."));
        }
    };
    private IWorldObjectEventListener<InitedMessage, WorldObjectUpdatedEvent<InitedMessage>> initedMessageListener = new IWorldObjectEventListener<InitedMessage, WorldObjectUpdatedEvent<InitedMessage>>(){

        @Override
        public void notify(WorldObjectUpdatedEvent<InitedMessage> event) {
            UT2004Bot.this.setState(new BotStateInited("InitedMessage received, calling botInitialized()."));
            UT2004Bot.this.controller.botInitialized(UT2004Bot.this.getWorldView().getSingle(GameInfo.class), UT2004Bot.this.getWorldView().getSingle(ConfigChange.class), (InitedMessage)event.getObject());
            UT2004Bot.this.setState(new BotStateInited("Bot initialized."));
        }
    };
    private IWorldEventListener<BotKilled> killedListener = new IWorldEventListener<BotKilled>(){

        @Override
        public void notify(BotKilled event) {
            UT2004Bot.this.getController().botKilled(event);
        }
    };
    private IWorldEventListener<EndMessage> endListener = new IWorldEventListener<EndMessage>(){

        @Override
        public void notify(EndMessage event) {
            UT2004Bot.this.setState(new BotStateSpawned("First batch of informations received - calling botSpawned()."));
            UT2004Bot.this.controller.botFirstSpawn(UT2004Bot.this.getWorldView().getSingle(GameInfo.class), UT2004Bot.this.getWorldView().getSingle(ConfigChange.class), UT2004Bot.this.getWorldView().getSingle(InitedMessage.class), UT2004Bot.this.getWorldView().getSingle(Self.class));
            UT2004Bot.this.setState(new BotStateSpawned("botSpawned() finished, finalizing controller initialization..."));
            UT2004Bot.this.controller.finishControllerInitialization();
            UT2004Bot.this.setState(new BotStateSpawned("finishControllerInitialization() finished, UT2004Bot is running."));
            UT2004Bot.this.getWorldView().removeEventListener(EndMessage.class, this);
            UT2004Bot.this.endMessageLatch.countDown();
        }
    };

    @Inject
    public UT2004Bot(UT2004BotParameters parameters, IComponentBus eventBus, IAgentLogger logger, IWorldView worldView, IAct act, IUT2004BotController init) {
        super(parameters.getAgentId(), eventBus, logger, (IVisionWorldView)worldView, act);
        this.params = parameters;
        this.controller = init;
        NullCheck.check(this.controller, "init");
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer("Initializing the controller...");
        }
        this.controller.initializeController((UT2004Bot)this);
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer("Preparing the controller...");
        }
        this.controller.prepareBot((UT2004Bot)this);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Controller initialized.");
        }
        this.helloBotReaction = new EventReact<HelloBotHandshake>(HelloBotHandshake.class, worldView){

            @Override
            protected void react(HelloBotHandshake event) {
                if (event.isServerFull()) {
                    throw new ComponentCantStartException("Server is full.", UT2004Bot.this);
                }
            }
        };
        this.getWorldView().addEventListener(ReadyCommandRequest.class, this.readyCommandRequestListener);
        this.getWorldView().addEventListener(InitCommandRequest.class, this.initCommandRequestListener);
        this.getWorldView().addEventListener(Password.class, this.passwordRequestedListener);
        this.getWorldView().addObjectListener(InitedMessage.class, WorldObjectUpdatedEvent.class, this.initedMessageListener);
        this.getWorldView().addEventListener(BotKilled.class, this.killedListener);
        this.endMessageLatch = new BusAwareCountDownLatch(1, this.getEventBus(), this.getWorldView());
        this.projectileCleanUp = new ProjectileCleanUp(this);
        this.botName = new UT2004BotName(this, "undefined");
    }

    public CONTROLLER getController() {
        return this.controller;
    }

    public UT2004BotParameters getParams() {
        return this.params;
    }

    @Override
    protected void startAgent() {
        this.botStoppedCalled = false;
        super.startAgent();
        this.getWorldView().addEventListener(EndMessage.class, this.endListener);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Waiting for the handshake to finish for 300s.");
        }
        if (!this.endMessageLatch.await(300000L, TimeUnit.MILLISECONDS)) {
            throw new ComponentCantStartException("The bot did not received first EndMessage in 300 seconds.", this);
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Handshake finished.");
        }
    }

    @Override
    protected void startPausedAgent() {
        this.botStoppedCalled = false;
        super.startPausedAgent();
        this.getWorldView().addEventListener(EndMessage.class, this.endListener);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Waiting for the handshake to finish for 300s.");
        }
        if (!this.endMessageLatch.await(300000L, TimeUnit.MILLISECONDS)) {
            throw new ComponentCantStartException("The bot did not received first EndMessage in 300 seconds.", this);
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Handshake finished.");
        }
    }

    @Override
    protected void preStopAgent() {
        super.preStopAgent();
        try {
            this.tryDisconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stopAgent() {
        block14: {
            try {
                if (this.botStoppedCalled) break block14;
                this.botStoppedCalled = true;
                this.controller.botShutdown();
            }
            catch (Throwable throwable) {
                try {
                    this.removeBotDisconnector();
                }
                catch (Throwable throwable2) {
                    try {
                        super.stopAgent();
                    }
                    catch (Throwable throwable3) {
                        this.endMessageLatch = new BusAwareCountDownLatch(1, this.getEventBus(), this.getWorldView());
                        throw throwable3;
                    }
                    this.endMessageLatch = new BusAwareCountDownLatch(1, this.getEventBus(), this.getWorldView());
                    throw throwable2;
                }
                try {
                    super.stopAgent();
                }
                catch (Throwable throwable4) {
                    this.endMessageLatch = new BusAwareCountDownLatch(1, this.getEventBus(), this.getWorldView());
                    throw throwable4;
                }
                this.endMessageLatch = new BusAwareCountDownLatch(1, this.getEventBus(), this.getWorldView());
                throw throwable;
            }
        }
        try {
            this.removeBotDisconnector();
        }
        catch (Throwable throwable) {
            try {
                super.stopAgent();
            }
            catch (Throwable throwable5) {
                this.endMessageLatch = new BusAwareCountDownLatch(1, this.getEventBus(), this.getWorldView());
                throw throwable5;
            }
            this.endMessageLatch = new BusAwareCountDownLatch(1, this.getEventBus(), this.getWorldView());
            throw throwable;
        }
        try {
            super.stopAgent();
        }
        catch (Throwable throwable) {
            this.endMessageLatch = new BusAwareCountDownLatch(1, this.getEventBus(), this.getWorldView());
            throw throwable;
        }
        this.endMessageLatch = new BusAwareCountDownLatch(1, this.getEventBus(), this.getWorldView());
    }

    @Override
    protected void preKillAgent() {
        super.preKillAgent();
        try {
            this.tryDisconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void killAgent() {
        block14: {
            try {
                if (this.botStoppedCalled) break block14;
                this.botStoppedCalled = true;
                this.controller.botShutdown();
            }
            catch (Throwable throwable) {
                try {
                    this.removeBotDisconnector();
                }
                catch (Throwable throwable2) {
                    try {
                        super.killAgent();
                    }
                    catch (Throwable throwable3) {
                        this.endMessageLatch = new BusAwareCountDownLatch(1, this.getEventBus(), this.getWorldView());
                        throw throwable3;
                    }
                    this.endMessageLatch = new BusAwareCountDownLatch(1, this.getEventBus(), this.getWorldView());
                    throw throwable2;
                }
                try {
                    super.killAgent();
                }
                catch (Throwable throwable4) {
                    this.endMessageLatch = new BusAwareCountDownLatch(1, this.getEventBus(), this.getWorldView());
                    throw throwable4;
                }
                this.endMessageLatch = new BusAwareCountDownLatch(1, this.getEventBus(), this.getWorldView());
                throw throwable;
            }
        }
        try {
            this.removeBotDisconnector();
        }
        catch (Throwable throwable) {
            try {
                super.killAgent();
            }
            catch (Throwable throwable5) {
                this.endMessageLatch = new BusAwareCountDownLatch(1, this.getEventBus(), this.getWorldView());
                throw throwable5;
            }
            this.endMessageLatch = new BusAwareCountDownLatch(1, this.getEventBus(), this.getWorldView());
            throw throwable;
        }
        try {
            super.killAgent();
        }
        catch (Throwable throwable) {
            this.endMessageLatch = new BusAwareCountDownLatch(1, this.getEventBus(), this.getWorldView());
            throw throwable;
        }
        this.endMessageLatch = new BusAwareCountDownLatch(1, this.getEventBus(), this.getWorldView());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tryDisconnect() {
        try {
            DisconnectBot cmd = new DisconnectBot();
            try {
                this.log.info("Sending " + cmd + " to destroy bot inside UT2004.");
            }
            finally {
                this.getAct().act(cmd);
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            this.log.warning(ExceptionToString.process("Failed to disconnect the bot, we hope that GB2004 will remove it when the socket gets closed.", e));
        }
    }

    protected void addBotDisconnector() {
        if (this.botDisconnectorThread == null) {
            this.botDisconnectorThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    UT2004Bot.this.tryDisconnect();
                }
            }, this.getName() + "-Disconnector");
            try {
                Runtime.getRuntime().addShutdownHook(this.botDisconnectorThread);
            }
            catch (Exception e) {
                throw new PogamutException("Failed to add BotDisconnectorThread as a JVM shutdown hook.", e, (Object)this);
            }
        }
    }

    protected void removeBotDisconnector() {
        if (this.botDisconnectorThread != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.botDisconnectorThread);
            }
            catch (Exception e) {
                this.log.warning(ExceptionToString.process("Failed to remove BotDisconnectorThread as a JVM shutdown hook.", e));
            }
            this.botDisconnectorThread = null;
        }
    }

    protected void readyCommandRequested() {
        this.getAct().act(new Ready());
    }

    protected void initCommandRequested() {
        Initialize initializeCommand = this.getController().getInitializeCommand();
        if (initializeCommand == null) {
            throw new AgentException("getBotInit().getInitializeCommand() method returned null message, can't initialize the agent!", (Logger)this.log, (Object)this);
        }
        if (initializeCommand.getName() == null) {
            initializeCommand.setName(this.getComponentId().getName().getFlag());
        } else {
            this.getComponentId().getName().setFlag(initializeCommand.getName());
        }
        this.botName.setNameBase(initializeCommand.getName());
        if (initializeCommand.getTeam() == null) {
            initializeCommand.setTeam(this.params.getTeam());
        }
        if (initializeCommand.getLocation() == null) {
            initializeCommand.setLocation(this.params.getInitialLocation());
        }
        if (initializeCommand.getRotation() == null) {
            initializeCommand.setRotation(this.params.getInitialRotation());
        }
        try {
            initializeCommand.setJmx(this.getJMX().enableJMX());
        }
        catch (Exception e) {
            throw new PogamutJMXException("Error seting up JMX name of the agent.", (Throwable)e, this.log, this);
        }
        String defaultName = (String)PogamutUT2004Property.POGAMUT_UT2004_BOT_INIT_NAME.getValue();
        String defaultSkin = (String)PogamutUT2004Property.POGAMUT_UT2004_BOT_INIT_SKIN.getValue();
        Integer defaultTeam = (Integer)PogamutUT2004Property.POGAMUT_UT2004_BOT_INIT_TEAM.getValue();
        Integer defaultSkill = (Integer)PogamutUT2004Property.POGAMUT_UT2004_BOT_INIT_SKILL.getValue();
        if (((Boolean)PogamutUT2004Property.POGAMUT_UT2004_BOT_INIT_OVERRIDE_PARAMS.getValue()).booleanValue()) {
            if (defaultName != null) {
                initializeCommand.setName(defaultName);
                this.botName.setNameBase(defaultName);
            }
            if (defaultSkin != null) {
                initializeCommand.setSkin(defaultSkin);
            }
            if (defaultTeam != null) {
                initializeCommand.setTeam(defaultTeam);
            }
            if (defaultSkill != null) {
                initializeCommand.setDesiredSkill(defaultSkill);
            }
        } else {
            if (defaultName != null && initializeCommand.getName() == null) {
                initializeCommand.setName(defaultName);
                this.botName.setNameBase(defaultName);
            }
            if (defaultSkin != null && initializeCommand.getSkin() == null) {
                initializeCommand.setSkin(defaultSkin);
            }
            if (defaultTeam != null && initializeCommand.getTeam() == null) {
                initializeCommand.setTeam(defaultTeam);
            }
            if (defaultSkill != null && initializeCommand.getDesiredSkill() == null) {
                initializeCommand.setDesiredSkill(defaultSkill);
            }
        }
        this.getAct().act(initializeCommand);
    }

    public Self getSelf() {
        return this.getWorldView().getSingle(Self.class);
    }

    @Override
    public Location getLocation() {
        Self self = this.getWorldView().getSingle(Self.class);
        if (self != null) {
            return self.getLocation();
        }
        return null;
    }

    @Override
    public Rotation getRotation() {
        Self self = this.getWorldView().getSingle(Self.class);
        if (self != null) {
            return self.getRotation();
        }
        return null;
    }

    @Override
    public Velocity getVelocity() {
        Self self = this.getWorldView().getSingle(Self.class);
        if (self != null) {
            return self.getVelocity();
        }
        return null;
    }

    @Override
    public void respawn() throws PogamutException {
        this.getAct().act(new Respawn());
    }

    @Override
    protected AgentJMXComponents createAgentJMX() {
        return new AgentJMXComponents<IUT2004Bot>((IUT2004Bot)this){

            @Override
            protected AgentMBeanAdapter createAgentMBean(ObjectName objectName, MBeanServer mbs) throws MalformedObjectNameException, InstanceAlreadyExistsException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
                return new BotJMXMBeanAdapter<UT2004Bot>(UT2004Bot.this, objectName, mbs);
            }
        };
    }

    @Override
    public void setBoolConfigure(IUT2004Bot.BoolBotParam param, boolean value) {
        try {
            Configuration configuration = new Configuration();
            ConfigChange confCh = this.getWorldView().getSingle(ConfigChange.class);
            configuration.copy(confCh);
            param.set(configuration, value);
            param.setField(confCh, value);
            this.getAct().act(configuration);
        }
        catch (Exception ex) {
            Logger.getLogger(UT2004Bot.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public boolean getBoolConfigure(IUT2004Bot.BoolBotParam param) {
        try {
            return param.get(this.getWorldView().getSingle(ConfigChange.class));
        }
        catch (Exception ex) {
            Logger.getLogger(UT2004Bot.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @Override
    protected Folder createIntrospection() {
        return new ReflectionObjectFolder("root", this.controller);
    }

    @Override
    public WORLD_VIEW getWorldView() {
        return (WORLD_VIEW)((IVisionWorldView)super.getWorldView());
    }

    public UT2004BotName getBotName() {
        return this.botName;
    }
}

