/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing;

import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.IUT2004ServerProvider;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DrawStayingDebugLines;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import java.awt.Color;
import java.util.logging.Logger;

public class UT2004Draw {
    protected Logger log;
    protected IUT2004ServerProvider serverProvider;
    protected Color defaultColor = Color.WHITE;
    protected Location origin = new Location(0.0, 0.0, 0.0);
    protected double scale = 1.0;

    public UT2004Draw(Logger log, IUT2004ServerProvider serverProvider) {
        this.log = log;
        if (log == null) {
            log = new LogCategory("Draw");
        }
        this.serverProvider = serverProvider;
    }

    protected UT2004Server getServer() {
        return this.serverProvider.getServer();
    }

    public void init() {
        this.serverProvider.getServer();
    }

    public Location getOrigin() {
        return this.origin;
    }

    public void setOrigin(Location location) {
        this.origin = location;
        if (this.origin == null) {
            this.origin = new Location(0.0, 0.0, 0.0);
        }
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public Color getColor() {
        return this.defaultColor;
    }

    public void setColor(Color color) {
        this.defaultColor = color;
        if (this.defaultColor == null) {
            this.defaultColor = Color.WHITE;
        }
    }

    public void drawLine(Location from, Location to) {
        this.drawLine(this.defaultColor, from, to);
    }

    public void drawLine(Color color, Location from, Location to) {
        if (color == null || from == null || to == null) {
            return;
        }
        this.init();
        DrawStayingDebugLines cmd = this.newDrawCommand(color);
        cmd.setVectors(this.getDrawVectors(from, to));
        this.getServer().getAct().act(cmd);
    }

    public void drawPolyLine(Location ... points) {
        this.drawPolyLine(this.defaultColor, points);
    }

    public void drawPolyLine(Color color, Location ... vertices) {
        if (color == null || vertices == null || vertices.length < 2) {
            return;
        }
        this.init();
        DrawStayingDebugLines cmd = this.newDrawCommand(color);
        cmd.setVectors(this.getDrawPolyLine(vertices));
        this.getServer().getAct().act(cmd);
    }

    public void drawPolygon(Location ... vertices) {
        this.drawPolygon(this.defaultColor, vertices);
    }

    public void drawPolygon(Color color, Location ... vertices) {
        if (color == null || vertices == null || vertices.length < 3) {
            return;
        }
        this.init();
        DrawStayingDebugLines cmd = this.newDrawCommand(color);
        cmd.setVectors(this.getDrawPolygon(vertices));
        this.getServer().getAct().act(cmd);
    }

    public void clearAll() {
        this.init();
        DrawStayingDebugLines cmd = new DrawStayingDebugLines();
        cmd.setClearAll(true);
        this.getServer().getAct().act(cmd);
    }

    private Location adjustLocation(Location location) {
        return location.scale(this.scale).add(this.origin);
    }

    private String getDrawVector(Location point) {
        if (point == null) {
            return "";
        }
        point = this.adjustLocation(point);
        int x = (int)Math.round(point.x);
        int y = (int)Math.round(point.y);
        int z = (int)Math.round(point.z);
        return x + "," + y + "," + z;
    }

    private void writeDrawVector(StringBuffer sb, Location point) {
        if (point == null) {
            return;
        }
        point = this.adjustLocation(point);
        int x = (int)Math.round(point.x);
        int y = (int)Math.round(point.y);
        int z = (int)Math.round(point.z);
        sb.append(x);
        sb.append(",");
        sb.append(y);
        sb.append(",");
        sb.append(z);
    }

    private String getDrawVectors(Location ... points) {
        if (points == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (Location point : points) {
            if (first) {
                first = false;
            } else {
                sb.append(";");
            }
            this.writeDrawVector(sb, point);
        }
        return sb.toString();
    }

    private String getDrawPolyLine(Location ... points) {
        if (points == null || points.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Location point = points[0];
        for (int i = 1; i < points.length; ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(";");
            }
            this.writeDrawVector(sb, point);
            sb.append(";");
            this.writeDrawVector(sb, points[i]);
            point = points[i];
        }
        return sb.toString();
    }

    private String getDrawPolygon(Location ... points) {
        if (points == null || points.length < 2) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Location point = points[0];
        for (int i = 1; i < points.length; ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(";");
            }
            this.writeDrawVector(sb, point);
            sb.append(";");
            this.writeDrawVector(sb, points[i]);
            point = points[i];
        }
        sb.append(";");
        this.writeDrawVector(sb, points[points.length - 1]);
        sb.append(";");
        this.writeDrawVector(sb, points[0]);
        return sb.toString();
    }

    private DrawStayingDebugLines newDrawCommand() {
        return this.newDrawCommand(this.defaultColor);
    }

    private DrawStayingDebugLines newDrawCommand(Color color) {
        DrawStayingDebugLines cmd = new DrawStayingDebugLines();
        cmd.setColor(new Location(this.defaultColor.getRed(), this.defaultColor.getGreen(), this.defaultColor.getBlue()));
        cmd.setClearAll(false);
        return cmd;
    }
}

