/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.io.IOException;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.StandardErrorHandler;
import net.sf.saxon.event.DocumentSender;
import net.sf.saxon.event.EventSource;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.NamePoolConverter;
import net.sf.saxon.event.ParseOptions;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.EventIteratorToReceiver;
import net.sf.saxon.evpull.PullEventSource;
import net.sf.saxon.om.AllElementStripper;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.PullPushCopier;
import net.sf.saxon.pull.PullSource;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class Sender {
    PipelineConfiguration pipe;

    public Sender(PipelineConfiguration pipe) {
        this.pipe = pipe;
    }

    public void send(Source source, Receiver receiver) throws XPathException {
        this.send(source, receiver, false);
    }

    public void send(Source source, Receiver receiver, boolean isFinal) throws XPathException {
        Controller controller;
        Configuration config = this.pipe.getConfiguration();
        receiver.setPipelineConfiguration(this.pipe);
        receiver.setSystemId(source.getSystemId());
        Receiver next = receiver;
        ParseOptions options = new ParseOptions();
        options.setXIncludeAware(config.isXIncludeAware());
        int schemaValidation = config.getSchemaValidationMode();
        if (isFinal) {
            schemaValidation |= 0x10000;
        }
        options.setSchemaValidationMode(schemaValidation);
        options.setDTDValidationMode(config.isValidation() ? 1 : 4);
        options.setXIncludeAware(config.isXIncludeAware());
        int stripSpace = 3;
        XMLReader parser2 = null;
        SchemaType topLevelType = null;
        if (source instanceof AugmentedSource) {
            int localDTDValidate;
            AugmentedSource as = (AugmentedSource)source;
            options.setPleaseCloseAfterUse(as.isPleaseCloseAfterUse());
            stripSpace = as.getStripSpace();
            if (as.isXIncludeAwareSet()) {
                options.setXIncludeAware(as.isXIncludeAware());
            }
            options.setSourceIsXQJ(as.sourceIsXQJ());
            int localValidate = ((AugmentedSource)source).getSchemaValidation();
            if (localValidate != 0) {
                schemaValidation = localValidate;
                if (isFinal) {
                    schemaValidation |= 0x10000;
                }
                options.setSchemaValidationMode(schemaValidation);
            }
            topLevelType = ((AugmentedSource)source).getTopLevelType();
            StructuredQName topLevelName = ((AugmentedSource)source).getTopLevelElement();
            if (topLevelName != null) {
                options.setTopLevelElement(topLevelName);
            }
            if ((localDTDValidate = ((AugmentedSource)source).getDTDValidation()) != 0) {
                options.setDTDValidationMode(localDTDValidate);
            }
            parser2 = ((AugmentedSource)source).getXMLReader();
            List filters = ((AugmentedSource)source).getFilters();
            if (filters != null) {
                for (int i = filters.size() - 1; i >= 0; --i) {
                    ProxyReceiver filter = (ProxyReceiver)filters.get(i);
                    filter.setPipelineConfiguration(this.pipe);
                    filter.setSystemId(source.getSystemId());
                    filter.setUnderlyingReceiver(next);
                    next = filter;
                }
            }
            source = ((AugmentedSource)source).getContainedSource();
        }
        if (stripSpace == 3) {
            stripSpace = config.getStripsWhiteSpace();
        }
        options.setStripSpace(stripSpace);
        if (stripSpace == 2) {
            AllElementStripper s = new AllElementStripper();
            s.setStripAll();
            s.setPipelineConfiguration(this.pipe);
            s.setUnderlyingReceiver(receiver);
            next = s;
        } else if (stripSpace == 4 && (controller = this.pipe.getController()) != null) {
            next = controller.makeStripper(next);
        }
        if (source instanceof NodeInfo) {
            int kind;
            NodeInfo ns = (NodeInfo)source;
            String baseURI = ns.getBaseURI();
            int val = schemaValidation & 0xFF;
            if (val != 3) {
                StructuredQName topLevelName = options.getTopLevelElement();
                int topLevelNameCode = -1;
                if (topLevelName != null) {
                    topLevelNameCode = config.getNamePool().allocate(topLevelName.getPrefix(), topLevelName.getNamespaceURI(), topLevelName.getLocalName());
                }
                next = config.getDocumentValidator(next, baseURI, val, stripSpace, topLevelType, topLevelNameCode);
            }
            if ((kind = ns.getNodeKind()) != 9 && kind != 1) {
                throw new IllegalArgumentException("Sender can only handle document or element nodes");
            }
            next.setSystemId(baseURI);
            this.sendDocumentInfo(ns, next);
            return;
        }
        if (source instanceof PullSource) {
            this.sendPullSource((PullSource)source, next, options);
            return;
        }
        if (source instanceof PullEventSource) {
            this.sendPullEventSource((PullEventSource)source, next, options);
            return;
        }
        if (source instanceof EventSource) {
            ((EventSource)source).send(next);
            return;
        }
        if (source instanceof SAXSource) {
            this.sendSAXSource((SAXSource)source, next, options);
            return;
        }
        if (source instanceof StreamSource) {
            StreamSource ss = (StreamSource)source;
            boolean dtdValidation = options.getDTDValidationMode() == 1;
            Source ps = Configuration.getPlatform().getParserSource(this.pipe, ss, schemaValidation, dtdValidation, stripSpace);
            if (ps == ss) {
                String url = source.getSystemId();
                InputSource is = new InputSource(url);
                is.setCharacterStream(ss.getReader());
                is.setByteStream(ss.getInputStream());
                boolean reuseParser = false;
                if (parser2 == null) {
                    parser2 = config.getSourceParser();
                    reuseParser = true;
                }
                SAXSource sax = new SAXSource(parser2, is);
                sax.setSystemId(source.getSystemId());
                this.sendSAXSource(sax, next, options);
                if (reuseParser) {
                    config.reuseSourceParser(parser2);
                }
            } else {
                this.send(ps, next, isFinal);
            }
            return;
        }
        next = this.makeValidator(next, source.getSystemId(), options);
        Source newSource = config.getSourceResolver().resolveSource(source, config);
        if (newSource instanceof StreamSource || newSource instanceof SAXSource || newSource instanceof NodeInfo || newSource instanceof PullSource || newSource instanceof AugmentedSource || newSource instanceof EventSource) {
            this.send(newSource, next, isFinal);
        }
        List externalObjectModels = config.getExternalObjectModels();
        for (int m = 0; m < externalObjectModels.size(); ++m) {
            ExternalObjectModel model = (ExternalObjectModel)externalObjectModels.get(m);
            boolean done = model.sendSource(source, next, this.pipe);
            if (!done) continue;
            return;
        }
        if (source instanceof DOMSource) {
            throw new XPathException("DOMSource cannot be processed: check that saxon9-dom.jar is on the classpath");
        }
        throw new XPathException("A source of type " + source.getClass().getName() + " is not supported in this environment");
    }

    private void sendDocumentInfo(NodeInfo top, Receiver receiver) throws XPathException {
        NamePool targetNamePool = this.pipe.getConfiguration().getNamePool();
        if (top.getNamePool() != targetNamePool) {
            NamePoolConverter converter = new NamePoolConverter(top.getNamePool(), targetNamePool);
            converter.setUnderlyingReceiver(receiver);
            converter.setPipelineConfiguration(receiver.getPipelineConfiguration());
            receiver = converter;
        }
        DocumentSender sender = new DocumentSender(top);
        sender.send(receiver);
    }

    private void sendSAXSource(SAXSource source, Receiver receiver, ParseOptions options) throws XPathException {
        ReceivingContentHandler ce;
        Configuration config;
        boolean reuseParser;
        XMLReader parser2;
        block33: {
            parser2 = source.getXMLReader();
            reuseParser = false;
            config = this.pipe.getConfiguration();
            if (parser2 == null) {
                SAXSource ss = new SAXSource();
                ss.setInputSource(source.getInputSource());
                ss.setSystemId(source.getSystemId());
                parser2 = config.getSourceParser();
                ss.setXMLReader(parser2);
                source = ss;
                reuseParser = true;
            } else {
                Sender.configureParser(parser2);
            }
            if (!this.pipe.isExpandAttributeDefaults()) {
                try {
                    parser2.setFeature("http://xml.org/sax/features/use-attributes2", true);
                }
                catch (SAXNotRecognizedException err) {
                }
                catch (SAXNotSupportedException err) {
                    // empty catch block
                }
            }
            boolean dtdValidation = options.getDTDValidationMode() == 1;
            try {
                parser2.setFeature("http://xml.org/sax/features/validation", dtdValidation);
            }
            catch (SAXNotRecognizedException err) {
                if (dtdValidation) {
                    throw new XPathException("XML Parser does not recognize request for DTD validation");
                }
            }
            catch (SAXNotSupportedException err) {
                if (!dtdValidation) break block33;
                throw new XPathException("XML Parser does not support DTD validation");
            }
        }
        boolean xInclude = options.isXIncludeAware();
        if (xInclude) {
            boolean tryAgain = false;
            try {
                parser2.setFeature("http://apache.org/xml/features/xinclude-aware", true);
            }
            catch (SAXNotRecognizedException err) {
                tryAgain = true;
            }
            catch (SAXNotSupportedException err) {
                tryAgain = true;
            }
            if (tryAgain) {
                try {
                    parser2.setFeature("http://apache.org/xml/features/xinclude", true);
                }
                catch (SAXNotRecognizedException err) {
                    throw new XPathException("Selected XML parser " + parser2.getClass().getName() + " does not recognize request for XInclude processing");
                }
                catch (SAXNotSupportedException err) {
                    throw new XPathException("Selected XML parser " + parser2.getClass().getName() + " does not support XInclude processing");
                }
            }
        }
        StandardErrorHandler errorHandler = new StandardErrorHandler(this.pipe.getErrorListener());
        parser2.setErrorHandler(errorHandler);
        receiver = this.makeValidator(receiver, source.getSystemId(), options);
        ContentHandler ch = parser2.getContentHandler();
        if (ch instanceof ReceivingContentHandler && config.isCompatible(((ReceivingContentHandler)ch).getConfiguration())) {
            ce = (ReceivingContentHandler)ch;
            ce.reset();
        } else {
            ce = new ReceivingContentHandler();
            parser2.setContentHandler(ce);
            parser2.setDTDHandler(ce);
            try {
                parser2.setProperty("http://xml.org/sax/properties/lexical-handler", ce);
            }
            catch (SAXNotSupportedException err) {
            }
            catch (SAXNotRecognizedException err) {
                // empty catch block
            }
        }
        ce.setReceiver(receiver);
        ce.setPipelineConfiguration(this.pipe);
        boolean xqj = options.sourceIsXQJ();
        try {
            if (xqj) {
                parser2.parse("dummy");
            } else {
                parser2.parse(source.getInputSource());
            }
        }
        catch (SAXException err) {
            Exception nested = err.getException();
            if (nested instanceof XPathException) {
                throw (XPathException)nested;
            }
            if (nested instanceof RuntimeException) {
                throw (RuntimeException)nested;
            }
            if (errorHandler.getErrorCount() == 0) {
                throw new XPathException("Error reported by XML parser processing " + source.getSystemId() + ": " + err.getMessage());
            }
            XPathException de = new XPathException(err);
            de.setHasBeenReported();
            throw de;
        }
        catch (IOException err) {
            throw new XPathException(err);
        }
        if (errorHandler.getErrorCount() > 0) {
            throw new XPathException("The XML parser reported one or more errors");
        }
        if (reuseParser) {
            config.reuseSourceParser(parser2);
        }
    }

    private Receiver makeValidator(Receiver receiver, String systemId, ParseOptions options) {
        Configuration config = this.pipe.getConfiguration();
        int schemaValidation = options.getSchemaValidationMode();
        if ((schemaValidation & 0xFF) != 3) {
            int stripSpace = options.getStripSpace();
            SchemaType topLevelType = options.getTopLevelType();
            StructuredQName topLevelElement = options.getTopLevelElement();
            int topLevelElementCode = -1;
            if (topLevelElement != null) {
                topLevelElementCode = config.getNamePool().allocate(topLevelElement.getPrefix(), topLevelElement.getNamespaceURI(), topLevelElement.getLocalName());
            }
            receiver = config.getDocumentValidator(receiver, systemId, schemaValidation, stripSpace, topLevelType, topLevelElementCode);
        }
        return receiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPullSource(PullSource source, Receiver receiver, ParseOptions options) throws XPathException {
        boolean xInclude = options.isXIncludeAware();
        if (xInclude) {
            throw new XPathException("XInclude processing is not supported with a pull parser");
        }
        receiver = this.makeValidator(receiver, source.getSystemId(), options);
        PullProvider provider = source.getPullProvider();
        if (provider instanceof LocationProvider) {
            this.pipe.setLocationProvider((LocationProvider)((Object)provider));
        }
        provider.setPipelineConfiguration(this.pipe);
        receiver.setPipelineConfiguration(this.pipe);
        PullPushCopier copier = new PullPushCopier(provider, receiver);
        try {
            copier.copy();
        }
        finally {
            if (options.isPleaseCloseAfterUse()) {
                provider.close();
            }
        }
    }

    private void sendPullEventSource(PullEventSource source, Receiver receiver, ParseOptions options) throws XPathException {
        boolean xInclude = options.isXIncludeAware();
        if (xInclude) {
            throw new XPathException("XInclude processing is not supported with a pull parser");
        }
        receiver = this.makeValidator(receiver, source.getSystemId(), options);
        receiver.open();
        EventIterator provider = source.getEventIterator();
        if (provider instanceof LocationProvider) {
            this.pipe.setLocationProvider((LocationProvider)((Object)provider));
        }
        receiver.setPipelineConfiguration(this.pipe);
        SequenceReceiver out = receiver instanceof SequenceReceiver ? (SequenceReceiver)receiver : new TreeReceiver(receiver);
        EventIteratorToReceiver.copy(provider, out);
        receiver.close();
    }

    public static void configureParser(XMLReader parser2) throws XPathException {
        try {
            parser2.setFeature("http://xml.org/sax/features/namespaces", true);
        }
        catch (SAXNotSupportedException err) {
            throw new XPathException("The SAX2 parser " + parser2.getClass().getName() + " does not recognize the 'namespaces' feature");
        }
        catch (SAXNotRecognizedException err) {
            throw new XPathException("The SAX2 parser " + parser2.getClass().getName() + " does not support setting the 'namespaces' feature to true");
        }
        try {
            parser2.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXNotSupportedException err) {
            throw new XPathException("The SAX2 parser " + parser2.getClass().getName() + " does not recognize the 'namespace-prefixes' feature");
        }
        catch (SAXNotRecognizedException err) {
            throw new XPathException("The SAX2 parser " + parser2.getClass().getName() + " does not support setting the 'namespace-prefixes' feature to false");
        }
    }
}

