/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.bot.impl;

import cz.cuni.amis.pogamut.base.agent.IGhostAgent;
import cz.cuni.amis.pogamut.base.agent.IObservingAgent;
import cz.cuni.amis.pogamut.base.agent.impl.AbstractAgent;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.AnnotationListenerRegistrator;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.unreal.agent.navigation.IUnrealPathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.AdrenalineCombo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.AgentConfig;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Raycasting;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.UT2004Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentStats;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.CTF;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.ItemDescriptors;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Items;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.NavPoints;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.NavigationGraphBuilder;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Players;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Senses;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.UT2004AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.UT2004Items;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPrefs;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.visibility.Visibility;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004GetBackToNavGraph;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004Navigation;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004PathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004RunStraight;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004AStarPathPlanner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004GetBackToNavGraph;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004Navigation;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004PathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004RunStraight;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.astar.UT2004AStar;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.floydwarshall.FloydWarshallMap;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.loquenavigator.LoqueNavigator;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.LevelGeometry;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.LevelGeometryModule;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMesh;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshModule;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.IUT2004ServerProvider;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.UT2004Draw;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.UT2004ServerProvider;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004DistanceStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004PositionStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004TimeStuckDetector;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.command.CompleteBotCommandsWrapper;
import cz.cuni.amis.pogamut.ut2004.bot.command.ImprovedShooting;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotLogicController;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.Random;
import java.util.logging.Level;

public class UT2004BotModuleController<BOT extends UT2004Bot>
extends UT2004BotLogicController<BOT> {
    protected Random random = new Random(System.currentTimeMillis());
    protected IUT2004Navigation navigation;
    protected Game game;
    protected AgentInfo info;
    protected Players players;
    protected ItemDescriptors descriptors;
    protected Items items;
    protected Senses senses;
    protected Weaponry weaponry;
    protected AgentConfig config;
    protected Raycasting raycasting;
    protected CompleteBotCommandsWrapper body;
    protected ImprovedShooting shoot;
    protected AdvancedLocomotion move;
    protected CTF ctf;
    protected AdrenalineCombo combo;
    protected IUT2004PathExecutor<ILocated> pathExecutor = null;
    protected IPathPlanner<ILocated> pathPlanner = null;
    protected NavigationGraphBuilder navBuilder = null;
    protected AnnotationListenerRegistrator listenerRegistrator;
    protected WeaponPrefs weaponPrefs;
    protected IVisionWorldView world;
    protected IAct act;
    protected AgentStats stats;
    protected FloydWarshallMap fwMap;
    protected IUT2004GetBackToNavGraph getBackToNavGraph;
    protected IUT2004RunStraight runStraight;
    protected Visibility visibility;
    protected NavPoints navPoints;
    protected UT2004AStar aStar;
    protected NavMeshModule navMeshModule;
    protected LevelGeometryModule levelGeometryModule;
    private IUT2004ServerProvider serverProvider;
    protected UT2004Draw draw;
    private FlagListener<IAgentState> botStateListener = new FlagListener<IAgentState>(){

        @Override
        public void flagChanged(IAgentState changedValue) {
            if (changedValue instanceof IAgentStateDown) {
                UT2004BotModuleController.this.botAgentDown();
            }
        }
    };

    @Override
    public void initializeController(BOT bot) {
        super.initializeController(bot);
        ((AbstractAgent)bot).getState().addListener(this.botStateListener);
        this.world = this.getWorldView();
        this.act = this.getAct();
        this.initializeModules(bot);
        this.initializePathFinding(bot);
        this.initializeListeners(bot);
    }

    protected void initializeListeners(BOT bot) {
        this.listenerRegistrator = new AnnotationListenerRegistrator(this, this.getWorldView(), ((AbstractAgent)bot).getLogger().getCategory("Listeners"));
        this.listenerRegistrator.addListeners();
    }

    protected void initializePathFinding(BOT bot) {
        this.pathPlanner = new UT2004AStarPathPlanner((UT2004Bot)bot);
        this.fwMap = new FloydWarshallMap((IGhostAgent)bot);
        this.aStar = new UT2004AStar((UT2004Bot)bot);
        this.pathExecutor = new UT2004PathExecutor<ILocated>((UT2004Bot)bot, this.info, this.move, new LoqueNavigator((UT2004Bot)bot, this.info, this.move, ((AbstractAgent)bot).getLog()), ((AbstractAgent)bot).getLog());
        this.pathExecutor.addStuckDetector(new UT2004TimeStuckDetector((UT2004Bot)bot, 3000.0, 100000.0));
        this.pathExecutor.addStuckDetector(new UT2004PositionStuckDetector((UT2004Bot)bot));
        this.pathExecutor.addStuckDetector(new UT2004DistanceStuckDetector((UT2004Bot)bot));
        this.getBackToNavGraph = new UT2004GetBackToNavGraph((UT2004Bot)bot, this.info, this.move);
        this.runStraight = new UT2004RunStraight((UT2004Bot)bot, this.info, this.move);
        this.navigation = new UT2004Navigation((UT2004Bot)bot, this.pathExecutor, this.fwMap, this.getBackToNavGraph, this.runStraight);
    }

    protected void initializeModules(BOT bot) {
        this.game = new Game((UT2004Bot)bot);
        this.navPoints = new NavPoints((UT2004Bot)bot);
        this.players = new Players((UT2004Bot)bot);
        this.descriptors = new ItemDescriptors((UT2004Bot)bot);
        this.config = new AgentConfig((UT2004Bot)bot);
        this.raycasting = new Raycasting((UT2004Bot)bot);
        this.stats = new AgentStats((IObservingAgent)bot);
        this.navBuilder = new NavigationGraphBuilder((UT2004Bot)bot);
        this.info = new UT2004AgentInfo((UT2004Bot)bot, this.game);
        this.visibility = new Visibility((UT2004Bot)bot, this.info);
        this.ctf = new CTF((UT2004Bot)bot, this.info);
        this.weaponry = new UT2004Weaponry((UT2004Bot)bot, this.descriptors);
        this.items = new UT2004Items((UT2004Bot)bot, this.info, this.game, this.weaponry, null);
        this.senses = new Senses((UT2004Bot)bot, this.info, this.players);
        this.body = new CompleteBotCommandsWrapper((UT2004Bot)bot, this.weaponry, null);
        this.shoot = this.body.getImprovedShooting();
        this.move = this.body.getLocomotion();
        this.weaponPrefs = new WeaponPrefs(this.weaponry, (UT2004Bot)bot);
        this.combo = new AdrenalineCombo((UT2004Bot)bot, this.info);
        this.serverProvider = new UT2004ServerProvider();
        this.navMeshModule = new NavMeshModule(this.serverProvider, this.getWorldView(), ((AbstractAgent)bot).getLogger());
        this.levelGeometryModule = new LevelGeometryModule(this.getWorldView(), ((AbstractAgent)bot).getLogger());
        this.draw = new UT2004Draw(((AbstractAgent)bot).getLogger().getCategory("Draw"), this.serverProvider);
    }

    @Override
    public void finishControllerInitialization() {
        if (this.navBuilder.isUsed()) {
            this.log.info("Navigation graph has been altered by 'navBuilder', triggering recomputation of Floyd-Warshall path matrix...");
            Level oldLevel = this.fwMap.getLog().getLevel();
            this.fwMap.getLog().setLevel(Level.FINER);
            this.fwMap.refreshPathMatrix();
            this.fwMap.getLog().setLevel(oldLevel);
            this.aStar.mapChanged();
        }
    }

    public Random getRandom() {
        return this.random;
    }

    public UT2004AStar getAStar() {
        return this.aStar;
    }

    public Game getGame() {
        return this.game;
    }

    public AgentInfo getInfo() {
        return this.info;
    }

    public Players getPlayers() {
        return this.players;
    }

    public ItemDescriptors getDescriptors() {
        return this.descriptors;
    }

    public Items getItems() {
        return this.items;
    }

    public Senses getSenses() {
        return this.senses;
    }

    public Weaponry getWeaponry() {
        return this.weaponry;
    }

    public AgentConfig getConfig() {
        return this.config;
    }

    public Raycasting getRaycasting() {
        return this.raycasting;
    }

    public CompleteBotCommandsWrapper getBody() {
        return this.body;
    }

    public ImprovedShooting getShoot() {
        return this.shoot;
    }

    public AdvancedLocomotion getMove() {
        return this.move;
    }

    public IUnrealPathExecutor<ILocated> getPathExecutor() {
        return this.pathExecutor;
    }

    public IPathPlanner<ILocated> getPathPlanner() {
        return this.pathPlanner;
    }

    public AdrenalineCombo getCombo() {
        return this.combo;
    }

    public NavigationGraphBuilder getNavBuilder() {
        return this.navBuilder;
    }

    public WeaponPrefs getWeaponPrefs() {
        return this.weaponPrefs;
    }

    public IVisionWorldView getWorld() {
        return this.world;
    }

    public AgentStats getStats() {
        return this.stats;
    }

    public FloydWarshallMap getFwMap() {
        return this.fwMap;
    }

    public IUT2004Navigation getNavigation() {
        return this.navigation;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public NavMeshModule getNavMeshModule() {
        return this.navMeshModule;
    }

    public NavMesh getNavMesh() {
        if (!this.navMeshModule.isInitialized()) {
            this.log.warning("NavMeshModule has not been initialized (yet)! You are either calling this method too early or missing .navmesh file in the local directory of your bot!");
        }
        return this.navMeshModule.getNavMesh();
    }

    public LevelGeometryModule getLevelGeometryModule() {
        return this.levelGeometryModule;
    }

    public LevelGeometry getLevelGeometry() {
        if (!this.levelGeometryModule.isInitialized()) {
            this.log.warning("LevelGeometryModule has not been initialized (yet)! You are either calling this method too early or missing .obj, .scale, .center files in the local directory of your bot!");
        }
        return this.levelGeometryModule.getLevelGeometry();
    }

    protected void botAgentDown() {
        if (this.serverProvider != null) {
            this.serverProvider.killServer();
        }
    }
}

