/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pathfinding.alg.astar;

import cz.cuni.amis.pathfinding.alg.astar.AStarHeapComparator;
import cz.cuni.amis.pathfinding.alg.astar.AStarResult;
import cz.cuni.amis.pathfinding.map.IPFGoal;
import cz.cuni.amis.pathfinding.map.IPFMap;
import cz.cuni.amis.pathfinding.map.IPFMapView;
import cz.cuni.amis.utils.Iterators;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.heap.Heap;
import cz.cuni.amis.utils.heap.ImmutableHeap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class AStar<NODE> {
    private IPFMap<NODE> map;
    private IPFMapView<NODE> view;
    private IPFGoal<NODE> goal = null;
    private long iterationsMax = 0L;
    private AStarResult<NODE> result = null;

    public AStar(IPFMap<NODE> map) {
        this.map = map;
        this.view = new IPFMapView.DefaultView();
        NullCheck.check(this.map, "map");
    }

    public AStar(IPFMap<NODE> map, IPFMapView<NODE> view) {
        this.map = map;
        this.view = view;
        NullCheck.check(this.map, "map");
        if (this.view == null) {
            this.view = new IPFMapView.DefaultView();
        }
    }

    public IPFMap<NODE> getMap() {
        return this.map;
    }

    public synchronized void setMap(IPFMap<NODE> map) {
        this.map = map;
    }

    public IPFMapView<NODE> getMapView() {
        return this.view;
    }

    public synchronized void setMapView(IPFMapView<NODE> mapView) {
        this.view = mapView;
    }

    public synchronized AStarResult<NODE> findPath(IPFGoal<NODE> goal, long iterationsMax) {
        this.goal = goal;
        this.iterationsMax = iterationsMax;
        NODE start = goal.getStart();
        this.result = new AStarResult();
        this.result.openList = new Heap(new AStarHeapComparator(this.result.estimatedCost), 64);
        this.result.closeList = new HashSet();
        Set close = this.result.closeList;
        goal.setCloseList(Collections.unmodifiableSet(this.result.closeList));
        goal.setOpenList(new ImmutableHeap(this.result.openList));
        this.result.startNode = start;
        this.result.putCostToNode(this.result.startNode, 0);
        this.result.putEstimatedCostToNode(this.result.startNode, goal.getEstimatedCostToGoal(this.result.startNode));
        this.result.openList.add(this.result.startNode);
        while (!(this.result.openList.empty() || this.iterationsMax > 0L && this.result.interations >= iterationsMax)) {
            ++this.result.interations;
            Object node = this.result.openList.getMin();
            if (node == null) {
                this.result.success = false;
                break;
            }
            this.result.openList.deleteMin();
            if (goal.isGoalReached(node)) {
                this.result.goalNode = node;
                this.result.success = true;
                break;
            }
            int nodePathCost = this.result.getCostToNode(node);
            Collection<NODE> neighbors = this.map.getNeighbors(node);
            Collection<NODE> extraNeighbors = this.view.getExtraNeighbors(node, neighbors);
            Iterators nodeIter = new Iterators(neighbors == null ? null : neighbors.iterator(), extraNeighbors == null ? null : extraNeighbors.iterator());
            while (nodeIter.hasNext()) {
                int estimatedPathCost;
                Object nextNode = nodeIter.next();
                if (nextNode == null || !this.view.isNodeOpened(nextNode) || !this.view.isArcOpened(node, nextNode)) continue;
                int travelCost = this.map.getArcCost(node, nextNode);
                int extraCost = this.view.getArcExtraCost(node, nextNode, travelCost);
                int nodeCost = this.map.getNodeCost(nextNode);
                int nodeExtraCost = this.view.getNodeExtraCost(nextNode, nodeCost);
                int nextNodePathCost = this.result.getCostToNode(nextNode);
                if (nextNodePathCost == -1) {
                    nextNodePathCost = nodePathCost + travelCost + extraCost + nodeCost + nodeExtraCost;
                    if (nextNodePathCost < 0) {
                        nextNodePathCost = 0;
                    }
                    this.result.putCostToNode(nextNode, nextNodePathCost);
                    this.result.putPreviousNode(nextNode, node);
                    estimatedPathCost = nextNodePathCost + goal.getEstimatedCostToGoal(nextNode);
                    this.result.putEstimatedCostToNode(nextNode, estimatedPathCost);
                    this.result.openList.add(nextNode);
                    continue;
                }
                int newNextNodePathCost = nodePathCost + travelCost + extraCost + nodeCost + nodeExtraCost;
                if (newNextNodePathCost < 0) {
                    newNextNodePathCost = 0;
                }
                if (newNextNodePathCost >= nextNodePathCost) continue;
                estimatedPathCost = newNextNodePathCost + goal.getEstimatedCostToGoal(nextNode);
                this.result.putCostToNode(nextNode, newNextNodePathCost);
                this.result.putEstimatedCostToNode(nextNode, estimatedPathCost);
                if (close.contains(nextNode)) {
                    close.remove(nextNode);
                    this.result.openList.add(nextNode);
                    continue;
                }
                if (this.result.openList.contains(nextNode)) {
                    this.result.openList.decreaseKey(node);
                    continue;
                }
                this.result.openList.add(nextNode);
            }
            close.add(node);
        }
        return this.result;
    }

    public synchronized AStarResult<NODE> findPath(IPFGoal<NODE> goal, IPFMapView<NODE> mapView) {
        IPFMapView<NODE> oldView = this.view;
        this.view = mapView;
        AStarResult<NODE> result = this.findPath(goal, 0L);
        this.view = oldView;
        return result;
    }

    public synchronized AStarResult<NODE> findPath(IPFGoal<NODE> goal) {
        return this.findPath(goal, 0L);
    }
}

