/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.unreal.environment;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.ut2004.agent.params.UT2004AgentParameters;
import cz.cuni.amis.pogamut.ut2004.bot.IUT2004BotController;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotController;
import cz.cuni.amis.pogamut.ut2004.bot.params.UT2004BotParameters;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Pause;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerModule;
import cz.cuni.amis.pogamut.ut2004.server.IUT2004Server;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004ServerRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.FlagListener;
import eis.eis2java.exception.TranslationException;
import eis.eis2java.handlers.ActionHandler;
import eis.eis2java.handlers.PerceptHandler;
import eis.eis2java.translation.Parameter2Java;
import eis.eis2java.translation.Translator;
import eis.exceptions.EntityException;
import eis.exceptions.ManagementException;
import eis.exceptions.RelationException;
import eis.iilang.Action;
import eis.iilang.EnvironmentState;
import eis.iilang.Parameter;
import java.util.HashMap;
import java.util.Map;
import nl.tudelft.goal.unreal.environment.MapOfParameters;
import nl.tudelft.goal.unreal.environment.SimpleTransitioningEnvironment;
import nl.tudelft.goal.unreal.messages.BotParameters;
import nl.tudelft.goal.unreal.messages.Configuration;
import nl.tudelft.goal.unreal.translators.AgentIdTranslator;
import nl.tudelft.goal.unreal.translators.BotParametersKeyTranslator;
import nl.tudelft.goal.unreal.translators.BotParametersListTranslator;
import nl.tudelft.goal.unreal.translators.BotParametersTranslator;
import nl.tudelft.goal.unreal.translators.ConfigurationKeyTranslator;
import nl.tudelft.goal.unreal.translators.ConfigurationTranslator;
import nl.tudelft.goal.unreal.translators.LevelTranslator;
import nl.tudelft.goal.unreal.translators.LocationTranslator;
import nl.tudelft.goal.unreal.translators.ParameterMapTranslator;
import nl.tudelft.goal.unreal.translators.RotationTranslator;
import nl.tudelft.goal.unreal.translators.SkinTranslator;
import nl.tudelft.goal.unreal.translators.TeamTranslator;
import nl.tudelft.goal.unreal.translators.URITranslator;
import nl.tudelft.goal.unreal.translators.UnrealIdTranslator;
import nl.tudelft.goal.unreal.translators.VelocityTranslator;
import nl.tudelft.goal.unreal.util.EnvironmentUtil;
import nl.tudelft.goal.unreal.util.vecmathcheck.VecmathCheck;

public abstract class AbstractUnrealEnvironment
extends SimpleTransitioningEnvironment
implements IComponent {
    private static final long serialVersionUID = 6786623950045095814L;
    protected final IAgentId id = new AgentId(this.getName());
    protected final IAgentLogger environmentLogger;
    protected final LogCategory log;
    private final Map<String, AgentDownListener> agentDownListeners = new HashMap<String, AgentDownListener>();
    protected Configuration configuration;
    private IUT2004Server utServer;

    public AbstractUnrealEnvironment() {
        this.environmentLogger = new AgentLogger(this.id);
        this.environmentLogger.addDefaultConsoleHandler();
        this.log = this.environmentLogger.getCategory(this);
        this.log.info("Environment has been created.");
        this.log.addConsoleHandler();
        Translator translator = Translator.getInstance();
        translator.registerParameter2JavaTranslator((Parameter2Java)new AgentIdTranslator());
        translator.registerParameter2JavaTranslator((Parameter2Java)new BotParametersKeyTranslator());
        translator.registerParameter2JavaTranslator((Parameter2Java)new BotParametersListTranslator());
        translator.registerParameter2JavaTranslator((Parameter2Java)new BotParametersTranslator());
        translator.registerParameter2JavaTranslator((Parameter2Java)new ConfigurationKeyTranslator());
        translator.registerParameter2JavaTranslator((Parameter2Java)new ConfigurationTranslator());
        translator.registerParameter2JavaTranslator((Parameter2Java)new LevelTranslator());
        translator.registerParameter2JavaTranslator((Parameter2Java)new LocationTranslator());
        translator.registerParameter2JavaTranslator((Parameter2Java)new ParameterMapTranslator());
        translator.registerParameter2JavaTranslator((Parameter2Java)new RotationTranslator());
        translator.registerParameter2JavaTranslator((Parameter2Java)new SkinTranslator());
        translator.registerParameter2JavaTranslator((Parameter2Java)new TeamTranslator());
        translator.registerParameter2JavaTranslator((Parameter2Java)new UnrealIdTranslator());
        translator.registerParameter2JavaTranslator((Parameter2Java)new URITranslator());
        translator.registerParameter2JavaTranslator((Parameter2Java)new VelocityTranslator());
        this.registerTranslators();
    }

    protected abstract void registerTranslators();

    @Override
    public IAgentId getComponentId() {
        return this.id;
    }

    public String toString() {
        return EnvironmentUtil.simplefyID(this.getComponentId());
    }

    public String getName() {
        return "Unreal Environment for EIS" + this.requiredVersion();
    }

    @Override
    protected synchronized void initializeEnvironment(Map<String, Parameter> parameters) throws ManagementException {
        if (!VecmathCheck.check()) {
            throw new ManagementException(VecmathCheck.getErrorMessage());
        }
        try {
            MapOfParameters parameterMap = new MapOfParameters(parameters);
            this.configuration = (Configuration)Translator.getInstance().translate2Java((Parameter)parameterMap, Configuration.class);
            this.configuration.assignDefaults(Configuration.getDefaults());
        }
        catch (TranslationException e) {
            throw new ManagementException("Invalid parameters", (Exception)((Object)e));
        }
        this.log.setLevel(this.configuration.getLogLevel());
    }

    @Override
    protected synchronized void connectEnvironment() throws ManagementException {
        assert (this.configuration != null);
        this.startServer();
        for (BotParameters bot : this.configuration.getBots()) {
            this.startAgent(bot);
        }
    }

    protected void startServer() throws ManagementException {
        try {
            UT2004ServerRunner<? extends IUT2004Server, ? extends UT2004AgentParameters> serverRunner = this.createServerRunner();
            this.utServer = serverRunner.startAgent();
        }
        catch (PogamutException e) {
            throw new ManagementException("Pogmut was unable to start the server. Cause: " + e.toString());
        }
        String simpleID = EnvironmentUtil.simplefyID(this.utServer.getComponentId());
        try {
            this.registerEntity(simpleID, "server", this.utServer);
        }
        catch (EntityException e) {
            this.utServer.stop();
            throw new ManagementException("Unable to register entity", (Exception)((Object)e));
        }
        this.agentDownListeners.put(simpleID, new AgentDownListener(simpleID, this.utServer));
    }

    protected UT2004ServerRunner<? extends IUT2004Server, ? extends UT2004AgentParameters> createServerRunner() {
        UT2004ServerModule serverModule = new UT2004ServerModule();
        UT2004ServerFactory serverFactory = new UT2004ServerFactory(serverModule);
        UT2004ServerRunner serverRunner = new UT2004ServerRunner(serverFactory, "UTServer", this.configuration.getControlServerHost(), this.configuration.getControlServerPort());
        return serverRunner;
    }

    protected synchronized void startAgent(BotParameters parameters) throws ManagementException {
        UT2004Bot agent;
        if (this.getState() == EnvironmentState.KILLED) {
            return;
        }
        this.utServer.getAct().act(new Pause(false, false));
        parameters.assignDefaults(BotParameters.getDefaults());
        UT2004BotRunner runner = new UT2004BotRunner(this.getControlerClass(), this.configuration.getDefaultBotName(), this.configuration.getBotServerHost(), this.configuration.getBotServerPort());
        runner.setLogLevel(parameters.getLogLevel());
        try {
            agent = (UT2004Bot)runner.startAgents(new UT2004BotParameters[]{parameters}).get(0);
        }
        catch (PogamutException e) {
            throw new ManagementException("Pogmut was unable to start an agents. Cause: " + e.toString());
        }
        String simpleID = EnvironmentUtil.simplefyID(agent.getComponentId());
        UT2004BotController controller = (UT2004BotController)agent.getController();
        try {
            this.registerEntity(simpleID, "bot", controller, this.createActionHandler(controller), this.createPerceptHandler(controller));
        }
        catch (EntityException e) {
            agent.stop();
            throw new ManagementException("Unable to register entity", (Exception)((Object)e));
        }
        this.agentDownListeners.put(simpleID, new AgentDownListener(simpleID, agent));
        if (agent.inState(IAgentStateDown.class)) {
            this.agentDownListeners.get(simpleID).removeListener();
            this.synchronizedDeleteEntity(simpleID);
        }
    }

    protected abstract Class<? extends IUT2004BotController> getControlerClass();

    protected abstract PerceptHandler createPerceptHandler(UT2004BotController var1) throws EntityException;

    protected abstract ActionHandler createActionHandler(UT2004BotController var1) throws EntityException;

    @Override
    protected void startEnvironment() throws ManagementException {
        this.utServer.getAct().act(new Pause(false, false));
    }

    @Override
    protected void pauseEvironment() {
        this.utServer.getAct().act(new Pause(true, false));
    }

    @Override
    protected synchronized void killEnvironment() {
        this.utServer.getAct().act(new Pause(false, false));
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e1) {
            // empty catch block
        }
        for (String id : this.getEntities()) {
            IAgent bot;
            Object entity = this.getEntity(id);
            if (entity instanceof UT2004BotController) {
                UT2004BotController controller = (UT2004BotController)this.getEntity(id);
                bot = controller.getBot();
            } else {
                bot = (IAgent)entity;
            }
            try {
                this.agentDownListeners.get(id).removeListener();
                bot.stop();
                this.log.info(bot.getName() + " has been stopped");
            }
            catch (AgentException e) {
                this.log.info(bot.getName() + " has been killed", e);
            }
        }
        this.utServer.stop();
        this.utServer = null;
        this.configuration = null;
        Pogamut.getPlatform().close();
    }

    protected synchronized void synchronizedDeleteEntity(String name) {
        try {
            this.deleteEntity(name);
        }
        catch (RelationException e) {
            this.log.severe("Could not delete entity " + name);
        }
        catch (EntityException e) {
            this.log.severe("Could not delete entity " + name + ", it was already deleted.");
        }
    }

    protected boolean isSupportedByEnvironment(Action arg0) {
        return true;
    }

    protected boolean isSupportedByType(Action arg0, String arg1) {
        return true;
    }

    private class AgentDownListener
    implements FlagListener<IAgentState> {
        private final String key;
        private final IAgent agent;

        public AgentDownListener(String key, IAgent agent) {
            this.key = key;
            this.agent = agent;
            this.agent.getState().addStrongListener(this);
        }

        @Override
        public void flagChanged(IAgentState state) {
            if (state instanceof IAgentStateDown) {
                this.removeListener();
                AbstractUnrealEnvironment.this.synchronizedDeleteEntity(this.key);
            }
        }

        public void removeListener() {
            this.agent.getState().removeListener(this);
            AbstractUnrealEnvironment.this.agentDownListeners.remove(this.key);
        }
    }
}

