/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.codenorm;

import net.sf.saxon.charcode.UTF16;
import net.sf.saxon.codenorm.NormalizerData;
import net.sf.saxon.codenorm.UnicodeDataParser;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class Normalizer {
    static final byte COMPATIBILITY_MASK = 1;
    static final byte COMPOSITION_MASK = 2;
    public static final byte D = 0;
    public static final byte C = 2;
    public static final byte KD = 1;
    public static final byte KC = 3;
    public static final byte NO_ACTION = 8;
    private byte form;
    private static NormalizerData data = null;

    public Normalizer(byte form) {
        this.form = form;
        if (data == null) {
            data = UnicodeDataParser.build();
        }
    }

    public Normalizer(CharSequence formCS) throws XPathException {
        int fb;
        String formString = Whitespace.trim(formCS);
        if (formString.length() == 0) {
            fb = 8;
        } else if (formString.equalsIgnoreCase("NFC")) {
            fb = 2;
        } else if (formString.equalsIgnoreCase("NFD")) {
            fb = 0;
        } else if (formString.equalsIgnoreCase("NFKC")) {
            fb = 3;
        } else if (formString.equalsIgnoreCase("NFKD")) {
            fb = 1;
        } else {
            String msg = "Normalization form " + formString + " is not supported";
            throw new XPathException(msg, "FOCH0003");
        }
        this.form = (byte)fb;
        if (data == null) {
            data = UnicodeDataParser.build();
        }
    }

    private StringBuffer normalize(CharSequence source, StringBuffer target) {
        if (this.form == 8 || source.length() == 0) {
            return new StringBuffer(((Object)source).toString());
        }
        this.internalDecompose(source, target);
        if ((this.form & 2) != 0) {
            this.internalCompose(target);
        }
        return target;
    }

    public CharSequence normalize(CharSequence source) {
        return this.normalize(source, new StringBuffer(source.length() + 8));
    }

    private void internalDecompose(CharSequence source, StringBuffer target) {
        StringBuffer buffer = new StringBuffer(8);
        boolean canonical = (this.form & 1) == 0;
        int i = 0;
        while (i < source.length()) {
            buffer.setLength(0);
            int ch32 = source.charAt(i++);
            if (UTF16.isHighSurrogate(ch32)) {
                char low = source.charAt(i++);
                ch32 = UTF16.combinePair((char)ch32, low);
            }
            data.getRecursiveDecomposition(canonical, ch32, buffer);
            int j = 0;
            while (j < buffer.length()) {
                int k;
                int ch;
                if (UTF16.isHighSurrogate(ch = buffer.charAt(j++))) {
                    char low = buffer.charAt(j++);
                    ch = UTF16.combinePair((char)ch, low);
                }
                int chClass = data.getCanonicalClass(ch);
                if (chClass != 0) {
                    int step;
                    for (k = target.length(); k > 0; k -= step) {
                        step = 1;
                        int ch2 = target.charAt(k - 1);
                        if (UTF16.isSurrogate(ch2)) {
                            step = 2;
                            char high = target.charAt(k - 2);
                            ch2 = UTF16.combinePair(high, (char)ch2);
                        }
                        if (data.getCanonicalClass(ch2) <= chClass) break;
                    }
                }
                if (ch < 65536) {
                    target.insert(k, (char)ch);
                    continue;
                }
                char[] chars = new char[]{UTF16.highSurrogate(ch), UTF16.lowSurrogate(ch)};
                target.insert(k, chars);
            }
        }
    }

    private void internalCompose(StringBuffer target) {
        int lastClass;
        int starterPos = 0;
        int starterCh = target.charAt(0);
        int compPos = 1;
        if (UTF16.isHighSurrogate(starterCh)) {
            starterCh = UTF16.combinePair((char)starterCh, target.charAt(1));
            ++compPos;
        }
        if ((lastClass = data.getCanonicalClass(starterCh)) != 0) {
            lastClass = 256;
        }
        int oldLen = target.length();
        int decompPos = compPos;
        while (decompPos < target.length()) {
            int ch;
            if (UTF16.isHighSurrogate(ch = target.charAt(decompPos++))) {
                ch = UTF16.combinePair((char)ch, target.charAt(decompPos++));
            }
            int chClass = data.getCanonicalClass(ch);
            char composite = data.getPairwiseComposition(starterCh, ch);
            if (composite != '\uffff' && (lastClass < chClass || lastClass == 0)) {
                Normalizer.setCharAt(target, starterPos, composite);
                starterCh = composite;
                continue;
            }
            if (chClass == 0) {
                starterPos = compPos;
                starterCh = ch;
            }
            lastClass = chClass;
            Normalizer.setCharAt(target, compPos, ch);
            if (target.length() != oldLen) {
                decompPos += target.length() - oldLen;
                oldLen = target.length();
            }
            compPos += ch < 65536 ? 1 : 2;
        }
        target.setLength(compPos);
    }

    private static void setCharAt(StringBuffer target, int offset, int ch32) {
        if (ch32 < 65536) {
            if (UTF16.isHighSurrogate(target.charAt(offset))) {
                target.setCharAt(offset, (char)ch32);
                target.deleteCharAt(offset + 1);
            } else {
                target.setCharAt(offset, (char)ch32);
            }
        } else if (UTF16.isHighSurrogate(target.charAt(offset))) {
            target.setCharAt(offset, UTF16.highSurrogate(ch32));
            target.setCharAt(offset + 1, UTF16.lowSurrogate(ch32));
        } else {
            target.setCharAt(offset, UTF16.highSurrogate(ch32));
            target.insert(offset + 1, UTF16.lowSurrogate(ch32));
        }
    }

    boolean getExcluded(char ch) {
        return data.getExcluded(ch);
    }

    String getRawDecompositionMapping(char ch) {
        return data.getRawDecompositionMapping(ch);
    }
}

