/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPref;
import cz.cuni.amis.pogamut.ut2004.bot.command.ImprovedShooting;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.utils.Heatup;
import java.util.concurrent.TimeUnit;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.AbstractWeaponShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.util.FacingUtil;

public class IonPainterShooting
extends AbstractWeaponShooting {
    protected static final WeaponPref DEFAULT_WEAPON_PREF = new WeaponPref(ItemType.ION_PAINTER, false);
    protected static int ION_PAINTER_CHARGE_TIME = 3;
    private Heatup chargeTime = new Heatup(ION_PAINTER_CHARGE_TIME, TimeUnit.SECONDS);

    public IonPainterShooting(UT2004Bot<?, ?, ?> agent, AgentInfo info, ImprovedShooting shoot, Weaponry weaponry) {
        super(agent, info, shoot, weaponry);
    }

    @Override
    protected void shoot() {
        if (!this.isWeaponReady()) {
            return;
        }
        if (!this.hasTarget()) {
            this.shoot.stopShooting();
            return;
        }
        if (this.chargeTime.isHot()) {
            return;
        }
        if (!(this.target instanceof Player)) {
            this.shoot.shootPrimaryCharged(this.target, (double)ION_PAINTER_CHARGE_TIME);
            this.chargeTime.heat();
            return;
        }
        Player player = (Player)this.target;
        if (!player.isVisible() || !FacingUtil.isFacing2D(this.info, (ILocated)player, 30.0)) {
            return;
        }
        this.shoot.shootPrimaryCharged(player, (double)ION_PAINTER_CHARGE_TIME);
        this.chargeTime.heat();
    }

    @Override
    protected WeaponPref getDefaultWeaponPref() {
        return DEFAULT_WEAPON_PREF;
    }
}

