/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.server;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnection;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.params.UT2004AgentParameters;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.AddInventory;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.ChangeTeam;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Pause;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Respawn;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SetGameSpeed;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SpawnActor;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004WorldView;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import cz.cuni.amis.utils.exception.PogamutException;
import eis.eis2java.annotation.AsAction;
import nl.tudelft.goal.ut2004.messages.UnrealIdOrLocation;

public class EnvironmentControllerServer
extends UT2004Server {
    private IWorldEventListener<GameInfo> pausedListener = new IWorldEventListener<GameInfo>(){

        @Override
        public void notify(GameInfo event) {
        }
    };

    @Inject
    public EnvironmentControllerServer(UT2004AgentParameters params, IAgentLogger agentLogger, IComponentBus bus, SocketConnection connection, UT2004WorldView worldView, IAct act) {
        super(params, agentLogger, bus, connection, worldView, act);
        worldView.addEventListener(GameInfo.class, this.pausedListener);
    }

    public void sendResumeGame() {
        Pause resume = new Pause(false, false);
        this.getAct().act(resume);
    }

    public void sendPausegame() {
        Pause pause = new Pause(true, false);
        this.getAct().act(pause);
    }

    @AsAction(name="addInventory")
    public void addInventory(UnrealId id, ItemType.Category category, ItemType.Group group) {
        for (ItemType item : group.getTypes()) {
            if (item.getCategory() != category) continue;
            AddInventory addInventory = new AddInventory(id, item.getName());
            this.getAct().act(addInventory);
            return;
        }
        String message = String.format("%s was not a ItemType in the %s category.", new Object[]{group, category});
        throw new PogamutException(message, (Object)this);
    }

    @AsAction(name="respawn")
    public void respawn(UnrealId id, UnrealIdOrLocation unrealIdOrLocation, Rotation rotation) {
        ILocated location = unrealIdOrLocation.toILocated((IWorldView)this.getWorldView());
        if (location == null) {
            String message = String.format("Could not resolve %s to a location", unrealIdOrLocation);
            throw new PogamutException(message, (Object)this);
        }
        this.getAct().act(new Respawn(id, location.getLocation(), rotation));
    }

    @AsAction(name="changeTeam")
    public void changeTeam(UnrealId id) {
        Player player = ((UT2004WorldView)this.getWorldView()).get(id, Player.class);
        if (player == null) {
            return;
        }
        this.getAct().act(new ChangeTeam(id, 1 - player.getTeam()));
    }

    @AsAction(name="setGameSpeed")
    public void setGameSpeed(Double speed) {
        this.getAct().act(new SetGameSpeed(speed));
    }

    @AsAction(name="spawnItem")
    public void spawnItem(UnrealIdOrLocation unrealIdOrLocation, ItemType.Category category, ItemType.Group group) {
        ILocated location = unrealIdOrLocation.toILocated((IWorldView)this.getWorldView());
        if (location == null) {
            String message = String.format("Could not resolve %s to a location", unrealIdOrLocation);
            throw new PogamutException(message, (Object)this);
        }
        for (ItemType item : group.getTypes()) {
            if (item.getCategory() != category) continue;
            SpawnActor spawn = new SpawnActor(location.getLocation(), Rotation.ZERO, item.getName());
            this.getAct().act(spawn);
            return;
        }
        String message = String.format("%s was not a ItemType in the %s category.", new Object[]{group, category});
        throw new PogamutException(message, (Object)this);
    }
}

