/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.floydwarshall;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.agent.navigation.impl.PrecomputedPathFuture;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.MapPointListObtained;
import cz.cuni.amis.pogamut.ut2004.utils.LinkFlag;
import cz.cuni.amis.utils.collections.MyCollections;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Point3d;

public class FloydWarshallMap
implements IPathPlanner<NavPoint> {
    public static final int BAD_EDGE_FLAG = LinkFlag.FLY.get() | LinkFlag.LADDER.get() | LinkFlag.PROSCRIBED.get() | LinkFlag.SWIM.get() | LinkFlag.PLAYERONLY.get();
    protected int badEdgeFlag = 0;
    protected Map<UnrealId, Integer> navPointIndices;
    protected Map<Integer, NavPoint> indicesNavPoints;
    protected PathMatrixNode[][] pathMatrix;
    protected Object mutex = new Object();
    private Logger log;

    public static boolean isWalkable(int flag) {
        return (flag & BAD_EDGE_FLAG) == 0 && (flag & LinkFlag.SPECIAL.get()) == 0;
    }

    public FloydWarshallMap(Logger log) {
        this(BAD_EDGE_FLAG, log);
    }

    public FloydWarshallMap(int badEdgeFlag, Logger log) {
        this.badEdgeFlag = badEdgeFlag;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshPathMatrix(List<NavPoint> navPoints) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(this + ": Refreshing path matrix...");
            }
            this.performFloydWarshall(navPoints);
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.warning(this + ": Path matrix refreshed!");
            }
        }
    }

    protected void performFloydWarshall(MapPointListObtained map) {
        List<NavPoint> navPoints = MyCollections.asList(map.getNavPoints().values());
        this.performFloydWarshall(navPoints);
    }

    protected void performFloydWarshall(List<NavPoint> navPoints) {
        int i;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(this + ": Beginning Floyd-Warshall algorithm...");
        }
        long start = System.currentTimeMillis();
        int size = navPoints.size();
        this.navPointIndices = new HashMap<UnrealId, Integer>(size);
        this.indicesNavPoints = new HashMap<Integer, NavPoint>(size);
        this.pathMatrix = new PathMatrixNode[size][size];
        for (i = 0; i < navPoints.size(); ++i) {
            this.navPointIndices.put(navPoints.get(i).getId(), i);
            this.indicesNavPoints.put(i, navPoints.get(i));
        }
        for (i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                this.pathMatrix[i][j] = new PathMatrixNode(i == j ? 0.0f : Float.POSITIVE_INFINITY);
            }
        }
        for (i = 0; i < size; ++i) {
            Point3d location = navPoints.get(i).getLocation().getPoint3d();
            for (NavPointNeighbourLink link : navPoints.get(i).getOutgoingEdges().values()) {
                if (!this.checkLink(link)) continue;
                this.pathMatrix[i][this.navPointIndices.get(link.getToNavPoint().getId())].setDistance((float)location.distance(link.getToNavPoint().getLocation().getPoint3d()));
            }
        }
        for (int k = 0; k < size; ++k) {
            for (int i2 = 0; i2 < size; ++i2) {
                for (int j = 0; j < size; ++j) {
                    float newLen = this.pathMatrix[i2][k].getDistance() + this.pathMatrix[k][j].getDistance();
                    if (!(this.pathMatrix[i2][j].getDistance() > newLen)) continue;
                    this.pathMatrix[i2][j].setDistance(newLen);
                    this.pathMatrix[i2][j].setViaNode(k);
                }
            }
        }
        int count = 0;
        for (int i3 = 0; i3 < size; ++i3) {
            for (int j = 0; j < size; ++j) {
                if (this.pathMatrix[i3][j].getDistance() == Float.POSITIVE_INFINITY) {
                    if (this.log.isLoggable(Level.FINER)) {
                        this.log.finer("Unreachable path from " + navPoints.get(i3).getId().getStringId() + " -> " + navPoints.get(j).getId().getStringId());
                    }
                    ++count;
                    continue;
                }
                this.pathMatrix[i3][j].setPath(this.retrievePath(i3, j));
            }
        }
        if (count > 0 && this.log.isLoggable(Level.WARNING)) {
            this.log.warning(this + ": There are " + count + " unreachable nav point pairs (if you wish to see more, set logging to Level.FINER).");
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this + ": computation for " + size + " navpoints took " + (System.currentTimeMillis() - start) + " millis");
        }
        this.indicesNavPoints = null;
    }

    public boolean checkLink(NavPointNeighbourLink edge) {
        if ((edge.getFlags() & this.badEdgeFlag) != 0) {
            return false;
        }
        if ((edge.getFlags() & LinkFlag.SPECIAL.get()) != 0) {
            return true;
        }
        if (edge.getNeededJump() != null && edge.getNeededJump().z > 680.0) {
            return false;
        }
        return !edge.getToNavPoint().isLiftJumpExit();
    }

    private List<NavPoint> retrievePathInner(Integer from, Integer to) {
        PathMatrixNode node = this.pathMatrix[from][to];
        if (node.getDistance() == Float.POSITIVE_INFINITY) {
            return null;
        }
        if (node.getViaNode() == null) {
            return new ArrayList<NavPoint>(0);
        }
        if (node.getViaNode() == null) {
            return new ArrayList<NavPoint>(0);
        }
        ArrayList<NavPoint> path = new ArrayList<NavPoint>();
        path.addAll(this.retrievePathInner(from, node.getViaNode()));
        path.add(this.indicesNavPoints.get(node.getViaNode()));
        path.addAll(this.retrievePathInner(node.getViaNode(), to));
        return path;
    }

    private List<NavPoint> retrievePath(Integer from, Integer to) {
        ArrayList<NavPoint> path = new ArrayList<NavPoint>();
        path.add(this.indicesNavPoints.get(from));
        path.addAll(this.retrievePathInner(from, to));
        path.add(this.indicesNavPoints.get(to));
        return path;
    }

    protected PathMatrixNode getPathMatrixNode(NavPoint np1, NavPoint np2) {
        return this.pathMatrix[this.navPointIndices.get(np1.getId())][this.navPointIndices.get(np2.getId())];
    }

    public boolean reachable(NavPoint from, NavPoint to) {
        if (from == null || to == null) {
            return false;
        }
        return this.getPathMatrixNode(from, to).getDistance() != Float.POSITIVE_INFINITY;
    }

    public float getDistance(NavPoint from, NavPoint to) {
        if (from == null || to == null) {
            return Float.POSITIVE_INFINITY;
        }
        return this.getPathMatrixNode(from, to).getDistance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NavPoint> getPath(NavPoint from, NavPoint to) {
        Object object = this.mutex;
        synchronized (object) {
            List<NavPoint> path;
            if (from == null || to == null) {
                return null;
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Retrieving path: " + from.getId().getStringId() + "[" + from.getLocation() + "] -> " + to.getId().getStringId() + "[" + to.getLocation() + "]");
            }
            if ((path = this.getPathMatrixNode(from, to).getPath()) == null) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("PATH NOT EXIST: " + from.getId().getStringId() + "[" + from.getLocation() + "] -> " + to.getId().getStringId() + "[" + to.getLocation() + "]");
                }
            } else if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Path exists - " + path.size() + " navpoints.");
            }
            return path;
        }
    }

    protected void cleanUp() {
        this.pathMatrix = null;
        this.navPointIndices = null;
    }

    public String toString() {
        return "FloydWarshallMap";
    }

    @Override
    public IPathFuture<NavPoint> computePath(NavPoint from, NavPoint to) {
        return new PrecomputedPathFuture<NavPoint>(from, to, this.getPath(from, to));
    }

    public static class PathMatrixNode {
        private float distance = Float.POSITIVE_INFINITY;
        private Integer viaNode = null;
        private List<NavPoint> path = null;

        public PathMatrixNode() {
        }

        public PathMatrixNode(float distance) {
            this.distance = distance;
        }

        public float getDistance() {
            return this.distance;
        }

        public void setDistance(float distance) {
            this.distance = distance;
        }

        public Integer getViaNode() {
            return this.viaNode;
        }

        public void setViaNode(Integer indice) {
            this.viaNode = indice;
        }

        public List<NavPoint> getPath() {
            return this.path;
        }

        public void setPath(List<NavPoint> path) {
            this.path = path;
        }
    }
}

