/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.maps;

import cz.cuni.amis.utils.listener.Event;
import cz.cuni.amis.utils.listener.IListener;
import cz.cuni.amis.utils.listener.Listeners;
import cz.cuni.amis.utils.listener.ListenersMap;
import java.util.HashMap;
import java.util.Map;

public class MapWithKeyListeners<KEY, VALUE> {
    private Map<KEY, VALUE> map = new HashMap<KEY, VALUE>();
    private ListenersMap<KEY> listeners = new ListenersMap();
    private KeyCreatedEventListenerNotifier<KEY, VALUE> notifier = new KeyCreatedEventListenerNotifier();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(KEY key, VALUE value) {
        Object oldValue = null;
        Map<KEY, VALUE> map = this.map;
        synchronized (map) {
            oldValue = this.map.put(key, value);
        }
        if (oldValue == null) {
            this.notifier.event = new KeyCreatedEvent<KEY, VALUE>(key, value);
            this.listeners.notify(key, this.notifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(KEY key) {
        Map<KEY, VALUE> map = this.map;
        synchronized (map) {
            this.map.remove(key);
        }
    }

    public void addWeakListener(KEY key, IKeyCreatedListener<KEY, VALUE> listener) {
        this.listeners.add(key, listener);
    }

    public boolean isListening(KEY key, IKeyCreatedListener<KEY, VALUE> listener) {
        return this.listeners.isListening(key, listener);
    }

    public void removeListener(KEY key, IKeyCreatedListener<KEY, VALUE> listener) {
        this.listeners.remove(key, listener);
    }

    public static class KeyCreatedEventListenerNotifier<KEY, VALUE>
    implements Listeners.ListenerNotifier<IListener> {
        public KeyCreatedEvent<KEY, VALUE> event;

        @Override
        public Object getEvent() {
            return this.event;
        }

        @Override
        public void notify(IListener listener) {
            listener.notify(this.event);
        }
    }

    public static interface IKeyCreatedListener<KEY, VALUE>
    extends IListener<KeyCreatedEvent<KEY, VALUE>> {
    }

    public static class KeyCreatedEvent<KEY, VALUE>
    implements Event {
        private KEY key;
        private VALUE value;

        public KeyCreatedEvent(KEY key, VALUE value) {
            this.key = key;
            this.value = value;
        }

        public KEY getKey() {
            return this.key;
        }

        public void setKey(KEY key) {
            this.key = key;
        }

        public VALUE getValue() {
            return this.value;
        }

        public void setValue(VALUE value) {
            this.value = value;
        }
    }
}

