/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004multi.communication.worldview.objects;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.multi.communication.translator.event.IStaticWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.IStaticWorldObject;
import cz.cuni.amis.pogamut.ut2004multi.communication.worldview.objects.TestCompositeViewableObject;
import cz.cuni.amis.pogamut.ut2004multi.communication.worldview.objects.TestStaticViewableObjectImpl;
import cz.cuni.amis.utils.exception.PogamutException;

public abstract class TestStaticViewableObject
implements IStaticWorldObject {
    protected WorldObjectId id;
    protected long simTime;

    public abstract String getStaticString();

    public abstract long getStaticLong();

    protected TestStaticViewableObject(WorldObjectId id, long simTime) {
        this.id = id;
        this.simTime = simTime;
    }

    @Override
    public WorldObjectId getId() {
        return this.id;
    }

    @Override
    public long getSimTime() {
        return this.simTime;
    }

    @Override
    public Class getCompositeClass() {
        return TestCompositeViewableObject.class;
    }

    public IStaticWorldObjectUpdatedEvent createUpdateEvent(long time2) {
        return new TestStaticViewableObjectUpdatedEvent(this, time2);
    }

    public static class TestStaticViewableObjectUpdatedEvent
    implements IStaticWorldObjectUpdatedEvent {
        private long time;
        private TestStaticViewableObject obj;

        public TestStaticViewableObjectUpdatedEvent(TestStaticViewableObject object, long time2) {
            this.time = time2;
            this.obj = object;
        }

        @Override
        public long getSimTime() {
            return this.time;
        }

        @Override
        public IWorldObjectUpdateResult<IStaticWorldObject> update(IStaticWorldObject object) {
            if (object == null) {
                TestStaticViewableObjectImpl impl = new TestStaticViewableObjectImpl(this.obj);
                this.obj = impl;
                return new IWorldObjectUpdateResult.WorldObjectUpdateResult<IStaticWorldObject>(IWorldObjectUpdateResult.Result.CREATED, impl);
            }
            if (object instanceof TestStaticViewableObjectImpl) {
                TestStaticViewableObjectImpl updatee = (TestStaticViewableObjectImpl)object;
                boolean updated = false;
                if (updatee.getStaticLong() != this.obj.getStaticLong()) {
                    updated = true;
                }
                if (!updatee.getStaticString().equals(this.obj.getStaticString())) {
                    updated = true;
                }
                if (!updated) {
                    updatee.simTime = this.time;
                    this.obj = updatee;
                    return new IWorldObjectUpdateResult.WorldObjectUpdateResult<IStaticWorldObject>(IWorldObjectUpdateResult.Result.SAME, this.obj);
                }
                throw new PogamutException("Trying to change a staticWorldObjec " + this.obj.getId() + " .", (Object)this);
            }
            throw new IllegalArgumentException("Wrong object class provided. Expected TestStaticObjectImpl, instead got " + object.getClass());
        }

        @Override
        public WorldObjectId getId() {
            return this.obj.getId();
        }
    }
}

