/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.pogamut.unreal.agent.module.shooting;

import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weapon;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPref;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPrefs;
import cz.cuni.amis.pogamut.ut2004.bot.command.ImprovedShooting;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.utils.SafeEquals;
import java.util.HashMap;
import java.util.Map;
import nl.tudelft.pogamut.unreal.agent.module.shooting.WeaponShooting;
import nl.tudelft.pogamut.unreal.agent.module.shooting.util.FocusProvider;
import nl.tudelft.pogamut.unreal.agent.module.shooting.weapon.GenericWeaponShooting;

public class WeaponryShooting
extends SensorModule<UT2004Bot> {
    protected ILocated currentTarget = null;
    protected WeaponPref currentWeaponPref = null;
    protected WeaponShooting currentWeaponShooting = null;
    private EndMessageListener endMessageListener;
    protected FocusProvider focus = new FocusProvider();
    protected AgentInfo info;
    protected ILocated lastTarget = null;
    protected WeaponPref lastWeaponPref = null;
    protected WeaponShooting lastWeaponShooting = null;
    protected ImprovedShooting shoot;
    protected WeaponPrefs weaponPrefs;
    protected Weaponry weaponry;
    protected Map<ItemType, WeaponShooting> weaponShootings = new HashMap<ItemType, WeaponShooting>();

    public WeaponryShooting(UT2004Bot bot, AgentInfo info, Weaponry weaponry, WeaponPrefs weaponPrefs, ImprovedShooting shoot) {
        super(bot);
        this.info = info;
        this.weaponry = weaponry;
        this.weaponPrefs = weaponPrefs;
        this.shoot = shoot;
        this.endMessageListener = new EndMessageListener(this.worldView);
    }

    public WeaponShooting addWeaponShooting(WeaponShooting weaponShooting) {
        return this.weaponShootings.put(weaponShooting.getWeaponType(), weaponShooting);
    }

    public WeaponShooting removeWeaponShooting(ItemType weapon) {
        return this.weaponShootings.remove(weapon);
    }

    public ILocated getFocus() {
        return this.focus;
    }

    public ILocated getLastTarget() {
        return this.lastTarget;
    }

    public ILocated getTarget() {
        return this.currentTarget;
    }

    public WeaponPref getWeaponPref() {
        return this.currentWeaponPref;
    }

    public WeaponShooting getWeaponShooting() {
        return this.currentWeaponShooting;
    }

    private WeaponShooting selectWeaponShooting(Weapon weapon) {
        if (weapon == null) {
            return null;
        }
        if (!this.weaponShootings.containsKey(weapon.getType())) {
            GenericWeaponShooting genericWeaponShooting = new GenericWeaponShooting((UT2004Bot)this.agent, this.info, this.shoot, this.weaponry, weapon.getType());
            this.weaponShootings.put(weapon.getType(), genericWeaponShooting);
            return genericWeaponShooting;
        }
        return this.weaponShootings.get(weapon.getType());
    }

    private void shoot() {
        this.lastWeaponShooting = this.currentWeaponShooting;
        WeaponPref suggested = this.weaponPrefs.getWeaponPreference(this.currentTarget);
        if (this.shoot.mayChangeWeapon()) {
            this.lastWeaponPref = this.currentWeaponPref;
            this.currentWeaponPref = suggested;
        }
        if (this.currentWeaponPref != null) {
            this.currentWeaponShooting = this.selectWeaponShooting(this.weaponry.getWeapon(this.currentWeaponPref.getWeapon()));
        } else {
            this.currentWeaponShooting = this.selectWeaponShooting(this.weaponry.getCurrentWeapon());
            this.currentWeaponPref = new WeaponPref(this.weaponry.getCurrentWeapon().getType());
        }
        if (this.lastWeaponShooting != null && this.lastWeaponShooting != this.currentWeaponShooting) {
            this.lastWeaponShooting.stopShoot();
            this.focus.clearFocus();
        }
        if (this.currentWeaponShooting == null) {
            return;
        }
        if (this.lastWeaponShooting != this.currentWeaponShooting) {
            this.currentWeaponShooting.shoot(this.currentWeaponPref, this.currentTarget);
            this.focus.setFocus(this.currentWeaponShooting.getFocus());
        } else if (!this.currentWeaponPref.equals(this.lastWeaponPref) || !SafeEquals.equals(this.lastTarget, this.currentTarget)) {
            this.currentWeaponShooting.shoot(this.currentWeaponPref, this.currentTarget);
        }
    }

    public void shoot(ILocated target) {
        if (this.currentTarget != target) {
            this.lastTarget = this.currentTarget;
            this.currentTarget = target;
        }
    }

    public void stopShoot() {
        if (this.currentTarget != null) {
            this.lastTarget = this.currentTarget;
            this.currentTarget = null;
        }
        this.currentWeaponShooting.stopShoot();
    }

    private class EndMessageListener
    implements IWorldEventListener<EndMessage> {
        public EndMessageListener(IWorldView worldView) {
            worldView.addEventListener(EndMessage.class, this);
        }

        @Override
        public void notify(EndMessage event) {
            WeaponryShooting.this.shoot();
        }
    }
}

