/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.curve;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import math.geom2d.Point2D;
import math.geom2d.UnboundedShapeException;
import math.geom2d.curve.ContinuousCurve2D;
import math.geom2d.polygon.LinearRing2D;
import math.geom2d.polygon.Polyline2D;

public abstract class AbstractContinuousCurve2D
implements ContinuousCurve2D,
Cloneable {
    protected static <T extends ContinuousCurve2D> Collection<T> wrapCurve(T curve) {
        ArrayList<T> list = new ArrayList<T>(1);
        list.add(curve);
        return list;
    }

    @Override
    public Polyline2D getAsPolyline(int n) {
        if (!this.isBounded()) {
            throw new UnboundedShapeException(this);
        }
        double t0 = this.getT0();
        double dt = (this.getT1() - t0) / (double)n;
        if (this.isClosed()) {
            Point2D[] points = new Point2D[n];
            for (int i = 0; i < n; ++i) {
                points[i] = this.getPoint(t0 + (double)i * dt);
            }
            return new LinearRing2D(points);
        }
        Point2D[] points = new Point2D[n + 1];
        for (int i = 0; i < n + 1; ++i) {
            points[i] = this.getPoint(t0 + (double)i * dt);
        }
        return new Polyline2D(points);
    }

    @Override
    public Collection<? extends ContinuousCurve2D> getContinuousCurves() {
        return AbstractContinuousCurve2D.wrapCurve(this);
    }

    @Override
    public Point2D getFirstPoint() {
        double t0 = this.getT0();
        if (Double.isInfinite(t0)) {
            throw new UnboundedShapeException(this);
        }
        return this.getPoint(t0);
    }

    @Override
    public Point2D getLastPoint() {
        double t1 = this.getT1();
        if (Double.isInfinite(t1)) {
            throw new UnboundedShapeException(this);
        }
        return this.getPoint(t1);
    }

    @Override
    public void draw(Graphics2D g2) {
        g2.draw(this.getAsAWTShape());
    }

    @Override
    public Shape getAsAWTShape() {
        if (!this.isBounded()) {
            throw new UnboundedShapeException(this);
        }
        GeneralPath path = new GeneralPath();
        Point2D point = this.getFirstPoint();
        path.moveTo((float)point.getX(), (float)point.getY());
        path = this.appendPath(path);
        return path;
    }

    @Override
    public abstract ContinuousCurve2D clone();
}

