/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.ItemDescriptors;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UT2004ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemPickedUp;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.ItemDescriptor;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.WeaponDescriptor;
import java.util.logging.Level;

public class UT2004Weaponry
extends Weaponry {
    private RedeemerPickedUpListener redeemerPickedUpListener;

    public UT2004Weaponry(UT2004Bot bot, ItemDescriptors descriptors, LogCategory moduleLog) {
        super(bot);
        this.redeemerPickedUpListener = new RedeemerPickedUpListener(this.worldView);
    }

    public UT2004Weaponry(UT2004Bot bot, ItemDescriptors itemDescriptors) {
        this(bot, itemDescriptors, null);
    }

    private class RedeemerPickedUpListener
    implements IWorldEventListener<ItemPickedUp> {
        public RedeemerPickedUpListener(IWorldView worldView) {
            worldView.addEventListener(ItemPickedUp.class, this);
        }

        @Override
        public void notify(ItemPickedUp event) {
            if (event == null) {
                return;
            }
            if (event.getType() == null) {
                return;
            }
            if (event.getType().getCategory() != ItemType.Category.AMMO && event.getType().getCategory() != ItemType.Category.WEAPON) {
                return;
            }
            if (event.getDescriptor().getPickupType() == UT2004ItemType.REDEEMER || event.getDescriptor().getPickupType() == UT2004ItemType.REDEEMER_AMMO || event.getDescriptor().getPickupType() == UT2004ItemType.ION_PAINTER || event.getDescriptor().getPickupType() == UT2004ItemType.ION_PAINTER_AMMO) {
                ItemDescriptor descriptor = UT2004Weaponry.this.itemDescriptors.getDescriptor(event.getType());
                if (descriptor == null) {
                    if (UT2004Weaponry.this.log.isLoggable(Level.WARNING)) {
                        UT2004Weaponry.this.log.warning("RedeemerPickedUpListener.notify(): There is no ItemDescriptor for the item type " + event.getType() + "!");
                    }
                    return;
                }
                if (descriptor.getItemCategory() == ItemType.Category.AMMO) {
                    UT2004Weaponry.this.ammo.weaponUpdate(event.getType(), 1);
                } else if (descriptor.getItemCategory() == ItemType.Category.WEAPON) {
                    WeaponDescriptor desc = (WeaponDescriptor)descriptor;
                    UT2004Weaponry.this.ammo.weaponUpdate(desc.getPriAmmoItemType(), 1);
                }
                return;
            }
        }
    }
}

