/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj;

import jogamp.opengl.util.pngj.FilterType;
import jogamp.opengl.util.pngj.ImageInfo;

class FilterWriteStrategy {
    private static final int COMPUTE_STATS_EVERY_N_LINES = 8;
    final ImageInfo imgInfo;
    public final FilterType configuredType;
    private FilterType currentType;
    private int lastRowTested = -1000000;
    private double[] lastSums = new double[5];
    private double[] lastEntropies = new double[5];
    private double[] preference = new double[]{1.1, 1.1, 1.1, 1.1, 1.2};
    private int discoverEachLines = -1;
    private double[] histogram1 = new double[256];

    FilterWriteStrategy(ImageInfo imageInfo, FilterType filterType) {
        this.imgInfo = imageInfo;
        this.configuredType = filterType;
        this.currentType = filterType.val < 0 ? (imageInfo.rows < 8 && imageInfo.cols < 8 || imageInfo.indexed || imageInfo.bitDepth < 8 ? FilterType.FILTER_NONE : FilterType.FILTER_PAETH) : filterType;
        if (filterType == FilterType.FILTER_AGGRESSIVE) {
            this.discoverEachLines = 8;
        }
        if (filterType == FilterType.FILTER_VERYAGGRESSIVE) {
            this.discoverEachLines = 1;
        }
    }

    boolean shouldTestAll(int n) {
        if (this.discoverEachLines > 0 && this.lastRowTested + this.discoverEachLines <= n) {
            this.currentType = null;
            return true;
        }
        return false;
    }

    public void setPreference(double d, double d2, double d3, double d4, double d5) {
        this.preference = new double[]{d, d2, d3, d4, d5};
    }

    public boolean computesStatistics() {
        return this.discoverEachLines > 0;
    }

    void fillResultsForFilter(int n, FilterType filterType, double d, int[] nArray, boolean bl) {
        this.lastRowTested = n;
        this.lastSums[filterType.val] = d;
        if (nArray != null) {
            double d2 = n == 0 ? 0.0 : 0.3;
            double d3 = 1.0 - d2;
            double d4 = 0.0;
            for (int i = 0; i < 256; ++i) {
                double d5 = (double)nArray[i] / (double)this.imgInfo.cols;
                d5 = this.histogram1[i] * d2 + d5 * d3;
                if (bl) {
                    d4 += d5 > 1.0E-8 ? d5 * Math.log(d5) : 0.0;
                    continue;
                }
                this.histogram1[i] = d5;
            }
            this.lastEntropies[filterType.val] = -d4;
        }
    }

    FilterType gimmeFilterType(int n, boolean bl) {
        if (this.currentType == null) {
            if (n == 0) {
                this.currentType = FilterType.FILTER_SUB;
            } else {
                double d = Double.MAX_VALUE;
                for (int i = 0; i < 5; ++i) {
                    double d2 = bl ? this.lastEntropies[i] : this.lastSums[i];
                    if (!((d2 /= this.preference[i]) <= d)) continue;
                    d = d2;
                    this.currentType = FilterType.getByVal(i);
                }
            }
        }
        if (this.configuredType == FilterType.FILTER_ALTERNATE) {
            this.currentType = FilterType.getByVal((this.currentType.val + 1) % 5);
        }
        return this.currentType;
    }
}

