/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.astar;

import cz.cuni.amis.utils.SafeEquals;
import cz.cuni.amis.utils.astar.AStarEvaluator;
import cz.cuni.amis.utils.astar.AStarGoal;
import cz.cuni.amis.utils.astar.AStarHeap;
import cz.cuni.amis.utils.astar.AStarHeapComparator;
import cz.cuni.amis.utils.astar.AStarHeuristic;
import cz.cuni.amis.utils.astar.AStarMap;
import cz.cuni.amis.utils.astar.AStarResult;
import java.util.Collection;

@Deprecated
public class AStar<NODE> {
    public static <NODE> AStarResult<NODE> aStar(AStarMap<NODE> map, NODE start, AStarGoal<NODE> goal, long iterationsMax) {
        AStarResult<NODE> result = new AStarResult<NODE>();
        AStarHeap<NODE> open = new AStarHeap<NODE>(new AStarHeapComparator(result.estimatedCost), 64);
        result.openList = open;
        Collection close = result.closeList;
        goal.setCloseList(result.closeList);
        goal.setOpenList(result.openList);
        result.startNode = start;
        result.putCostToNode(result.startNode, 0);
        result.putEstimatedCostToNode(result.startNode, goal.getEstimatedDistanceToGoal(result.startNode));
        open.add((NODE)result.startNode);
        while (!(open.empty() || iterationsMax > 0L && result.interations >= iterationsMax)) {
            ++result.interations;
            Object node = open.getMin();
            if (node == null) {
                result.success = false;
                break;
            }
            open.deleteMin();
            if (goal.isGoalReached(node)) {
                result.goalNode = node;
                result.success = true;
                break;
            }
            int nodePathCost = result.getCostToNode(node);
            Collection<NODE> neighbours = map.getNodeNeighbours(node);
            for (NODE nextNode : neighbours) {
                int estimatedPathCost;
                if (!goal.isNodeOpened(nextNode)) continue;
                int travelCost = map.getEdgeCost(node, nextNode);
                int extraCost = goal.getExtraCost(node, nextNode);
                int nextNodePathCost = result.getCostToNode(nextNode);
                if (nextNodePathCost == -1) {
                    nextNodePathCost = nodePathCost + travelCost + extraCost;
                    if (nextNodePathCost < 0) {
                        nextNodePathCost = 0;
                    }
                    result.putCostToNode(nextNode, nextNodePathCost);
                    result.putPreviousNode(nextNode, node);
                    estimatedPathCost = nextNodePathCost + goal.getEstimatedDistanceToGoal(nextNode);
                    result.putEstimatedCostToNode(nextNode, estimatedPathCost);
                    open.add(nextNode);
                    continue;
                }
                int newNextNodePathCost = nodePathCost + travelCost + extraCost;
                if (newNextNodePathCost < 0) {
                    newNextNodePathCost = 0;
                }
                if (newNextNodePathCost >= nextNodePathCost) continue;
                estimatedPathCost = newNextNodePathCost + goal.getEstimatedDistanceToGoal(nextNode);
                result.putCostToNode(nextNode, newNextNodePathCost);
                result.putEstimatedCostToNode(nextNode, estimatedPathCost);
                if (close.contains(nextNode)) {
                    close.remove(nextNode);
                    open.add(nextNode);
                    continue;
                }
                if (open.contains(nextNode)) {
                    open.decreaseKey(node);
                    continue;
                }
                open.add(nextNode);
            }
            close.add(node);
        }
        return result;
    }

    public static <NODE> AStarResult<NODE> aStar(AStarMap<NODE> map, NODE start, AStarGoal<NODE> goal) {
        return AStar.aStar(map, start, goal, -1L);
    }

    public static <NODE> AStarResult<NODE> aStar(AStarMap<NODE> map, final AStarEvaluator<NODE> evaluator, NODE start, final NODE goal, int maxIterations) {
        return AStar.aStar(map, start, new AStarGoal<NODE>(){

            @Override
            public boolean isGoalReached(NODE actualNode) {
                return SafeEquals.equals(actualNode, goal);
            }

            @Override
            public void setCloseList(Collection<NODE> closeList) {
            }

            @Override
            public void setOpenList(Collection<NODE> openList) {
            }

            @Override
            public int getExtraCost(NODE nodeFrom, NODE nodeTo) {
                return evaluator.getExtraCost(nodeFrom, nodeTo);
            }

            @Override
            public boolean isNodeOpened(NODE node) {
                return evaluator.isNodeOpened(node);
            }

            @Override
            public int getEstimatedDistanceToGoal(NODE node) {
                return evaluator.getEstimatedDistanceToGoal(node);
            }
        }, maxIterations);
    }

    public static <NODE> AStarResult<NODE> aStar(AStarMap<NODE> map, AStarEvaluator<NODE> evaluator, NODE start, NODE goal) {
        return AStar.aStar(map, evaluator, start, goal, -1);
    }

    public static <NODE> AStarResult<NODE> aStar(AStarMap<NODE> map, final AStarHeuristic<NODE> heuristic, NODE start, final NODE goal, int maxIterations) {
        return AStar.aStar(map, start, new AStarGoal<NODE>(){

            @Override
            public boolean isGoalReached(NODE actualNode) {
                return SafeEquals.equals(actualNode, goal);
            }

            @Override
            public void setCloseList(Collection<NODE> closeList) {
            }

            @Override
            public void setOpenList(Collection<NODE> openList) {
            }

            @Override
            public int getExtraCost(NODE nodeFrom, NODE nodeTo) {
                return 0;
            }

            @Override
            public boolean isNodeOpened(NODE node) {
                return true;
            }

            @Override
            public int getEstimatedDistanceToGoal(NODE node) {
                return heuristic.getEstimatedDistanceToGoal(node);
            }
        }, maxIterations);
    }

    public static <NODE> AStarResult<NODE> aStar(AStarMap<NODE> map, AStarHeuristic<NODE> heuristic, NODE start, NODE goal) {
        return AStar.aStar(map, heuristic, start, goal, -1);
    }
}

