/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.gui.dialogs;

import cz.cuni.amis.utils.collections.CollectionEventListener;
import cz.cuni.amis.utils.collections.ObservableSet;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import nl.tudelft.goal.ut2004.visualizer.connection.EnvironmentService;
import nl.tudelft.goal.ut2004.visualizer.controller.ServerController;
import nl.tudelft.goal.ut2004.visualizer.data.EnvironmentData;
import nl.tudelft.goal.ut2004.visualizer.util.CollectionEventAdaptor;
import nl.tudelft.goal.ut2004.visualizer.util.SelectableEnvironment;
import nl.tudelft.goal.ut2004.visualizer.util.WindowPersistenceHelper;

public class ListEnvironmentsDialog
extends JDialog {
    private final JList environmentList;
    private WindowPersistenceHelper persistenceHelper;

    public ListEnvironmentsDialog(Frame parent) {
        super(parent, false);
        this.setTitle("Environments");
        this.setLayout(new FlowLayout());
        this.persistenceHelper = new WindowPersistenceHelper(this);
        this.persistenceHelper.load();
        ServerController controller = ServerController.getInstance();
        EnvironmentData data = controller.getEnvironmentData();
        ObservableSet<EnvironmentService> clients = data.getEnvironments();
        Collection<SelectableEnvironment> s = SelectableEnvironment.fromCollection(clients);
        this.environmentList = new JList<Object>(s.toArray());
        this.environmentList.setSelectionMode(0);
        clients.addCollectionListener((CollectionEventListener)new CollectionEventAdaptor<EnvironmentService>(){

            @Override
            public void postAddEvent(Collection<EnvironmentService> alreadyAdded, final Collection<EnvironmentService> whereWereAdded) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Collection<SelectableEnvironment> s = SelectableEnvironment.fromCollection(whereWereAdded);
                        ListEnvironmentsDialog.this.environmentList.setModel(new DefaultComboBoxModel<Object>(s.toArray()));
                    }
                });
            }

            @Override
            public void postRemoveEvent(Collection<EnvironmentService> alreadyRemoved, final Collection<EnvironmentService> whereWereRemoved) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Collection<SelectableEnvironment> s = SelectableEnvironment.fromCollection(whereWereRemoved);
                        ListEnvironmentsDialog.this.environmentList.setModel(new DefaultComboBoxModel<Object>(s.toArray()));
                    }
                });
            }
        });
        this.add(this.environmentList);
        this.setSize(400, 225);
    }
}

