/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.gui.action;

import cz.cuni.amis.pogamut.ut2004.server.IUT2004Server;
import cz.cuni.amis.utils.collections.CollectionEventListener;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.Collection;
import javax.swing.JDialog;
import nl.tudelft.goal.ut2004.visualizer.connection.EnvironmentService;
import nl.tudelft.goal.ut2004.visualizer.controller.ServerController;
import nl.tudelft.goal.ut2004.visualizer.gui.action.ShowDialogueAction;
import nl.tudelft.goal.ut2004.visualizer.util.CollectionEventAdaptor;

public class ShowServerEnvironmentDependentDialogueAction
extends ShowDialogueAction {
    private boolean environmentsAvailable = false;
    private boolean serverAvailable = false;

    public ShowServerEnvironmentDependentDialogueAction(JDialog dialog, String name, String description) {
        super(dialog, name, description);
        ServerController controller = ServerController.getInstance();
        controller.getServerDefinition().getServerFlag().addListener((FlagListener)new ServerListener());
        controller.getEnvironmentData().getEnvironments().addCollectionListener((CollectionEventListener)new CollectionListener());
        this.setEnabled(controller.getServer() != null);
    }

    private void checkStatus() {
        if (this.environmentsAvailable && this.serverAvailable) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
            this.dialog.setVisible(false);
        }
    }

    private class ServerListener
    implements FlagListener<IUT2004Server> {
        private ServerListener() {
        }

        public void flagChanged(IUT2004Server changedValue) {
            ShowServerEnvironmentDependentDialogueAction.this.serverAvailable = changedValue != null;
            ShowServerEnvironmentDependentDialogueAction.this.checkStatus();
        }
    }

    private class CollectionListener
    extends CollectionEventAdaptor<EnvironmentService> {
        private CollectionListener() {
        }

        @Override
        public void postAddEvent(Collection<EnvironmentService> alreadyAdded, Collection<EnvironmentService> whereWereAdded) {
            ShowServerEnvironmentDependentDialogueAction.this.environmentsAvailable = !whereWereAdded.isEmpty();
            ShowServerEnvironmentDependentDialogueAction.this.checkStatus();
        }

        @Override
        public void postRemoveEvent(Collection<EnvironmentService> alreadyRemoved, Collection<EnvironmentService> whereWereRemoved) {
            ShowServerEnvironmentDependentDialogueAction.this.environmentsAvailable = !whereWereRemoved.isEmpty();
            ShowServerEnvironmentDependentDialogueAction.this.checkStatus();
        }
    }
}

