/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.data;

import cz.cuni.amis.utils.collections.ObservableSet;
import java.io.Serializable;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashSet;
import nl.tudelft.goal.ut2004.visualizer.connection.EnvironmentService;
import nl.tudelft.goal.ut2004.visualizer.connection.VisualizerService;

public class EnvironmentData {
    public static final String serviceName = "UnrealVisualizerService";
    private final ObservableSet<EnvironmentService> environments;
    private RegistrationHandler handler;

    public EnvironmentData() {
        HashSet set = new HashSet();
        this.environments = new ObservableSet(set);
    }

    public ObservableSet<EnvironmentService> getEnvironments() {
        return this.environments;
    }

    public void connect() {
        System.out.println("RMI server started");
        try {
            LocateRegistry.createRegistry(1099);
            System.out.println("Java RMI registry created.");
        }
        catch (RemoteException e) {
            System.out.println("Java RMI registry already exists.");
        }
        try {
            this.handler = new RegistrationHandler();
            Naming.rebind(serviceName, this.handler);
            System.out.println("UnrealVisualizerService bound in registry");
        }
        catch (Exception e) {
            System.err.println("RMI server exception:" + e);
            e.printStackTrace();
        }
    }

    public class RegistrationHandler
    extends UnicastRemoteObject
    implements VisualizerService,
    Serializable {
        protected RegistrationHandler() throws RemoteException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerEnvironment(EnvironmentService environment) throws RemoteException {
            ObservableSet observableSet = EnvironmentData.this.environments;
            synchronized (observableSet) {
                if (EnvironmentData.this.environments.contains((Object)environment)) {
                    EnvironmentData.this.environments.remove((Object)environment);
                }
                EnvironmentData.this.environments.add((Object)environment);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterEnvironment(EnvironmentService environment) throws RemoteException {
            ObservableSet observableSet = EnvironmentData.this.environments;
            synchronized (observableSet) {
                EnvironmentData.this.environments.remove((Object)environment);
            }
        }
    }
}

