/*
 * Decompiled with CFR 0.152.
 */
package eis.iilang;

import eis.iilang.IILObjectVisitor;
import eis.iilang.IILVisitor;
import eis.iilang.Parameter;

public class TruthValue
extends Parameter {
    private static final long serialVersionUID = 377656049621872537L;
    private String value;

    public TruthValue(String value) {
        this.value = value;
    }

    public TruthValue(boolean bool) {
        this.value = bool ? "true" : "false";
    }

    @Override
    protected String toXML(int depth) {
        return String.valueOf(this.indent(depth)) + "<truthvalue value=\"" + this.value + "\"/>" + "\n";
    }

    @Override
    public String toProlog() {
        String ret = "";
        ret = String.valueOf(ret) + this.value;
        return ret;
    }

    public String getValue() {
        return this.value;
    }

    public boolean getBooleanValue() {
        if (this.value.equals("true")) {
            return true;
        }
        if (this.value.equals("false")) {
            return false;
        }
        throw new AssertionError((Object)(String.valueOf(this.value) + "cannot be converted to boolean"));
    }

    @Override
    public Object clone() {
        return new TruthValue(this.value);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TruthValue)) {
            return false;
        }
        TruthValue other = (TruthValue)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public Object accept(IILObjectVisitor visitor, Object object) {
        return visitor.visit(this, object);
    }

    @Override
    public void accept(IILVisitor visitor) {
        visitor.visit(this);
    }
}

