/*
 * Decompiled with CFR 0.152.
 */
package eis.iilang;

import eis.iilang.IILObjectVisitor;
import eis.iilang.IILVisitor;
import eis.iilang.Parameter;
import java.util.LinkedList;

public class Function
extends Parameter {
    private static final long serialVersionUID = -4047099586973739090L;
    private String name = null;
    private LinkedList<Parameter> params = new LinkedList();

    public Function(String name, Parameter ... parameters) {
        this.setName(name);
        Parameter[] parameterArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter p = parameterArray[n2];
            this.params.add(p);
            ++n2;
        }
    }

    public Function(String name, LinkedList<Parameter> parameters) {
        this.setName(name);
        this.params = parameters;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        assert (Character.isLowerCase(name.charAt(0))) : String.valueOf(name) + " should start with a lowercase letter";
        this.name = name;
    }

    public LinkedList<Parameter> getParameters() {
        return this.params;
    }

    public void setParameters(LinkedList<Parameter> parameters) {
        this.params = parameters;
    }

    public LinkedList<Parameter> getClonedParameters() {
        LinkedList<Parameter> ret = new LinkedList<Parameter>();
        for (Parameter p : this.params) {
            ret.add((Parameter)p.clone());
        }
        return ret;
    }

    @Override
    protected String toXML(int depth) {
        String xml = "";
        xml = String.valueOf(xml) + this.indent(depth) + "<function name=\"" + this.name + "\">" + "\n";
        for (Parameter p : this.params) {
            xml = String.valueOf(xml) + p.toXML(depth + 1);
        }
        xml = String.valueOf(xml) + this.indent(depth) + "</function>" + "\n";
        return xml;
    }

    @Override
    public String toProlog() {
        String ret = this.name;
        if (this.params.size() > 0) {
            ret = String.valueOf(ret) + "(";
            ret = String.valueOf(ret) + this.params.getFirst().toProlog();
            int a = 1;
            while (a < this.params.size()) {
                ret = String.valueOf(ret) + "," + this.params.get(a).toProlog();
                ++a;
            }
            ret = String.valueOf(ret) + ")";
        }
        return ret;
    }

    @Override
    public Object clone() {
        return new Function(this.name, this.getClonedParameters());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Function)) {
            return false;
        }
        Function other = (Function)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.params == null ? other.params != null : !this.params.equals(other.params));
    }

    @Override
    public Object accept(IILObjectVisitor visitor, Object object) {
        return visitor.visit(this, object);
    }

    @Override
    public void accept(IILVisitor visitor) {
        visitor.visit(this);
    }
}

